/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixelS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.ImageType;

public class ImplBilinearPixel_U16
extends BilinearPixelS<GrayU16> {
    public ImplBilinearPixel_U16() {
    }

    public ImplBilinearPixel_U16(GrayU16 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((GrayU16)this.orig).startIndex + yt * this.stride + xt;
        short[] data = ((GrayU16)this.orig).data;
        float val2 = (1.0f - ax) * (1.0f - ay) * (float)(data[index] & 0xFFFF);
        val2 += ax * (1.0f - ay) * (float)(data[index + 1] & 0xFFFF);
        val2 += ax * ay * (float)(data[index + 1 + this.stride] & 0xFFFF);
        return val2 += (1.0f - ax) * ay * (float)(data[index + this.stride] & 0xFFFF);
    }

    public float get_border(float x, float y) {
        float xf = (float)Math.floor(x);
        float yf = (float)Math.floor(y);
        int xt = (int)xf;
        int yt = (int)yf;
        float ax = x - xf;
        float ay = y - yf;
        ImageBorder_S32 border = (ImageBorder_S32)this.border;
        float val2 = (1.0f - ax) * (1.0f - ay) * (float)border.get(xt, yt);
        val2 += ax * (1.0f - ay) * (float)border.get(xt + 1, yt);
        val2 += ax * ay * (float)border.get(xt + 1, yt + 1);
        return val2 += (1.0f - ax) * ay * (float)border.get(xt, yt + 1);
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 2) || y > (float)(this.height - 2)) {
            return this.get_border(x, y);
        }
        return this.get_fast(x, y);
    }

    @Override
    public InterpolatePixelS<GrayU16> copy() {
        ImplBilinearPixel_U16 out = new ImplBilinearPixel_U16();
        out.setBorder(this.border);
        return out;
    }

    @Override
    public ImageType<GrayU16> getImageType() {
        return ImageType.single(GrayU16.class);
    }
}

