/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate;

import boofcv.core.image.GImageGray;
import boofcv.misc.BoofMiscOps;
import org.ejml.UtilEjml;

public class ImageLineIntegral {
    GImageGray image;
    double length;

    public void setImage(GImageGray image) {
        this.image = image;
    }

    public double compute(double x0, double y0, double x1, double y1) {
        double sum = 0.0;
        double slopeX = x1 - x0;
        double slopeY = y1 - y0;
        this.length = Math.sqrt(slopeX * slopeX + slopeY * slopeY);
        int sgnX = (int)Math.signum(slopeX);
        int sgnY = (int)Math.signum(slopeY);
        int px = (int)x0;
        int py = (int)y0;
        if (slopeX == 0.0 || slopeY == 0.0) {
            if (slopeX == slopeY) {
                return 0.0;
            }
            double t = slopeX == 0.0 ? (slopeY > 0.0 ? (double)(py + 1) - y0 : (double)py - y0) : (slopeX > 0.0 ? (double)(px + 1) - x0 : (double)px - x0);
            if ((t /= slopeX + slopeY) > 1.0) {
                t = 1.0;
            }
            if (t > 0.0) {
                sum += t * this.image.unsafe_getD(px, py);
            }
            double deltaT = (double)(sgnX + sgnY) / (slopeX + slopeY);
            while (t < 1.0) {
                px += sgnX;
                py += sgnY;
                double nextT = t + deltaT;
                double actualDeltaT = deltaT;
                if (nextT > 1.0) {
                    actualDeltaT = 1.0 - t;
                }
                t = nextT;
                sum += actualDeltaT * this.image.unsafe_getD(px, py);
            }
        } else {
            double deltaTX = slopeX > 0.0 ? (double)(px + 1) - x0 : (double)px - x0;
            double deltaTY = slopeY > 0.0 ? (double)(py + 1) - y0 : (double)py - y0;
            double t = Math.min(deltaTX /= slopeX, deltaTY /= slopeY);
            if (t > 1.0) {
                t = 1.0;
            }
            if (t > 0.0) {
                sum += t * this.image.unsafe_getD(px, py);
            }
            double x = x0 + t * slopeX;
            double y = y0 + t * slopeY;
            px = (int)x;
            py = (int)y;
            int nx = px + sgnX;
            int ny = py + sgnY;
            while (t < 1.0) {
                double nextT;
                deltaTX = ((double)nx - x) / slopeX;
                deltaTY = ((double)ny - y) / slopeY;
                double deltaT = Math.min(deltaTX, deltaTY);
                if (deltaT <= UtilEjml.TEST_F64) {
                    deltaT = Math.max(deltaTX, deltaTY);
                }
                if ((nextT = t + deltaT) > 1.0) {
                    deltaT = 1.0 - t;
                }
                double sampleT = t + 0.5 * deltaT;
                x = x0 + sampleT * slopeX;
                y = y0 + sampleT * slopeY;
                sum += deltaT * this.image.unsafe_getD((int)x, (int)y);
                x = x0 + (t += deltaT) * slopeX;
                y = y0 + t * slopeY;
                px = (int)x;
                py = (int)y;
                nx = px + sgnX;
                ny = py + sgnY;
            }
        }
        return sum *= this.length;
    }

    public boolean isInside(double x, double y) {
        return BoofMiscOps.isInside(this.image.getWidth(), this.image.getHeight(), x, y);
    }

    public double getLength() {
        return this.length;
    }
}

