/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import georegression.geometry.GeometryMath_F64;
import georegression.metric.ClosestPoint3D_F64;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;

public class Triangulate2ViewsGeometricMetric {
    final LineParametric3D_F64 rayA = new LineParametric3D_F64();
    final LineParametric3D_F64 rayB = new LineParametric3D_F64();

    public boolean triangulate(Point2D_F64 a, Point2D_F64 b, Se3_F64 a_to_b, Point3D_F64 foundInA) {
        Vector3D_F64 t = a_to_b.getT();
        this.rayB.p.setTo(-t.x, -t.y, -t.z);
        GeometryMath_F64.multTran(a_to_b.getR(), this.rayB.p, this.rayB.p);
        GeometryMath_F64.multTran(a_to_b.getR(), b, this.rayB.slope);
        this.rayA.slope.setTo(a.x, a.y, 1.0);
        return null != ClosestPoint3D_F64.closestPoint(this.rayA, this.rayB, foundInA);
    }

    public void triangulate(Point2D_F64 a, Point2D_F64 b, Se3_F64 a_to_b, Point4D_F64 foundInA) {
        Vector3D_F64 t = a_to_b.getT();
        this.rayB.p.setTo(-t.x, -t.y, -t.z);
        GeometryMath_F64.multTran(a_to_b.getR(), this.rayB.p, this.rayB.p);
        GeometryMath_F64.multTran(a_to_b.getR(), b, this.rayB.slope);
        this.rayA.slope.setTo(a.x, a.y, 1.0);
        ClosestPoint3D_F64.closestPoint(this.rayA, this.rayB, foundInA);
    }
}

