/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.alg.geo.DecomposeEssential;
import boofcv.alg.geo.DecomposeProjectiveToMetric;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolver;

public class TwoViewToCalibratingHomography {
    public Triangulate2ViewsMetric triangulate = FactoryMultiView.triangulate2ViewMetric(null);
    public final DecomposeEssential decomposeEssential = new DecomposeEssential();
    public final DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    public final DMatrixRMaj F21 = new DMatrixRMaj(3, 3);
    public final DMatrixRMaj E21 = new DMatrixRMaj(3, 3);
    public final DogArray<DMatrixRMaj> hypothesesH = new DogArray<DMatrixRMaj>(() -> new DMatrixRMaj(4, 4));
    public int bestSolutionIdx;
    public int bestInvalid = Integer.MAX_VALUE;
    public double bestModelError = Double.MAX_VALUE;
    private final DMatrixRMaj A = new DMatrixRMaj(3, 3);
    private final Vector3D_F64 a = new Vector3D_F64();
    private final DMatrixRMaj AK1 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj KiR = new DMatrixRMaj(3, 3);
    private final CameraPinhole intrinsic1 = new CameraPinhole();
    private final CameraPinhole intrinsic2 = new CameraPinhole();
    private final Se3_F64 view_1_to_2 = new Se3_F64();
    private final DMatrixRMaj calibratingH = new DMatrixRMaj(4, 4);
    private final Point3D_F64 pointIn1 = new Point3D_F64();
    private final Point3D_F64 Xcam = new Point3D_F64();
    private final AssociatedTriple an = new AssociatedTriple();
    private final LinearSolver<DMatrixRMaj, DMatrixRMaj> linear = LinearSolverFactory_DDRM.leastSquares(9, 3);
    private final DMatrixRMaj matA = new DMatrixRMaj(9, 3);
    private final DMatrixRMaj matX = new DMatrixRMaj(9, 1);
    private final DMatrixRMaj matB = new DMatrixRMaj(9, 1);
    private final DecomposeProjectiveToMetric projectiveToMetric = new DecomposeProjectiveToMetric();
    private final DMatrixRMaj K1_inv = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj K2_prime = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj P1_prime = new DMatrixRMaj(3, 4);
    private final DMatrixRMaj P2_prime = new DMatrixRMaj(3, 4);
    private final DMatrixRMaj H_prime = new DMatrixRMaj(4, 4);
    private final DMatrixRMaj P_tmp = new DMatrixRMaj(3, 4);

    public void initialize(DMatrixRMaj F21, DMatrixRMaj P2) {
        BoofMiscOps.checkTrue(F21.numRows == 3 && F21.numCols == 3);
        BoofMiscOps.checkTrue(P2.numRows == 3 && P2.numCols == 4);
        this.F21.setTo(F21);
        this.P2.setTo(P2);
    }

    public boolean process(DMatrixRMaj K1, DMatrixRMaj K2, List<AssociatedPair> observations) {
        this.bestSolutionIdx = -1;
        MultiViewOps.fundamentalToEssential(this.F21, K1, K2, this.E21);
        this.decomposeEssential.decompose(this.E21);
        List<Se3_F64> list_view_1_to_2 = this.decomposeEssential.getSolutions();
        this.computeHypothesesForH(K1, K2, list_view_1_to_2);
        this.bestInvalid = Integer.MAX_VALUE;
        this.bestModelError = Double.MAX_VALUE;
        for (int motionIdx = 0; motionIdx < this.hypothesesH.size; ++motionIdx) {
            int invalid = this.checkGeometry(list_view_1_to_2.get(motionIdx), (DMatrixRMaj)this.hypothesesH.get(motionIdx), K1, K2, observations);
            if ((double)invalid == Double.MAX_VALUE || invalid >= this.bestInvalid) continue;
            this.bestInvalid = invalid;
            this.bestSolutionIdx = motionIdx;
            this.bestModelError = this.projectiveToMetric.singularError;
        }
        return this.bestSolutionIdx >= 0;
    }

    public DMatrixRMaj getCalibrationHomography() {
        return (DMatrixRMaj)this.hypothesesH.get(this.bestSolutionIdx);
    }

    void computeHypothesesForH(DMatrixRMaj K1, DMatrixRMaj K2, List<Se3_F64> list_view_1_to_2) {
        CommonOps_DDRM.invert(K1, this.K1_inv);
        CommonOps_DDRM.mult(this.K1_inv, K2, this.K2_prime);
        CommonOps_DDRM.insert(this.K1_inv, this.P1_prime, 0, 0);
        CommonOps_DDRM.mult(this.K1_inv, this.P2, this.P2_prime);
        MultiViewOps.projectiveToIdentityH(this.P1_prime, this.H_prime);
        CommonOps_DDRM.mult(this.P2_prime, this.H_prime, this.P_tmp);
        this.P2_prime.setTo(this.P_tmp);
        PerspectiveOps.projectionSplit(this.P2_prime, this.A, this.a);
        this.AK1.setTo(this.A);
        CommonOps_DDRM.setIdentity(this.calibratingH);
        this.hypothesesH.reset();
        for (int motionIdx = 0; motionIdx < list_view_1_to_2.size(); ++motionIdx) {
            int i;
            this.view_1_to_2.setTo(list_view_1_to_2.get(motionIdx));
            CommonOps_DDRM.mult(this.K2_prime, this.view_1_to_2.R, this.KiR);
            double bestBottom = 0.0;
            double bestScale = 0.0;
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        if (i == k) continue;
                        double top = this.AK1.get(i, j) * this.a.getIdx(k) - this.AK1.get(k, j) * this.a.getIdx(i);
                        double bottom = this.a.getIdx(k) * this.KiR.get(i, j) - this.a.getIdx(i) * this.KiR.get(k, j);
                        double scale = top / bottom;
                        if (!(Math.abs(bottom) > bestBottom)) continue;
                        bestBottom = Math.abs(bottom);
                        bestScale = scale;
                    }
                }
            }
            int row = 0;
            for (int j = 0; j < 3; ++j) {
                int i2 = 0;
                while (i2 < 3) {
                    this.matA.set(row, j, this.a.getIdx(i2));
                    this.matB.set(row, 0, this.KiR.get(i2, j) * bestScale - this.AK1.get(i2, j));
                    ++i2;
                    ++row;
                }
            }
            if (!this.linear.setA(this.matA)) continue;
            this.linear.solve(this.matB, this.matX);
            for (i = 0; i < 3; ++i) {
                this.calibratingH.set(3, i, this.matX.get(i));
            }
            CommonOps_DDRM.mult(this.H_prime, this.calibratingH, this.hypothesesH.grow());
        }
    }

    private int checkGeometry(Se3_F64 view_1_to_2e, DMatrixRMaj H, DMatrixRMaj K1, DMatrixRMaj K2, List<AssociatedPair> observations) {
        PerspectiveOps.matrixToPinhole(K1, 0, 0, this.intrinsic1);
        PerspectiveOps.matrixToPinhole(K2, 0, 0, this.intrinsic2);
        if (!this.projectiveToMetric.projectiveToMetricKnownK(this.P2, H, K2, this.view_1_to_2)) {
            return Integer.MAX_VALUE;
        }
        double scale = this.view_1_to_2.T.norm();
        this.view_1_to_2.T.divide(scale);
        if (view_1_to_2e.T.distance((GeoTuple_F64)this.view_1_to_2.T) > 1.0) {
            scale *= -1.0;
        }
        this.view_1_to_2.setTo(view_1_to_2e);
        H.set(3, 3, 1.0 / scale);
        int foundInvalid = 0;
        for (int i = 0; i < observations.size(); ++i) {
            AssociatedPair ap = observations.get(i);
            PerspectiveOps.convertPixelToNorm(this.intrinsic1, ap.p1.x, ap.p1.y, this.an.p1);
            PerspectiveOps.convertPixelToNorm(this.intrinsic2, ap.p2.x, ap.p2.y, this.an.p2);
            this.triangulate.triangulate(this.an.p1, this.an.p2, this.view_1_to_2, this.pointIn1);
            if (this.pointIn1.z < 0.0) {
                ++foundInvalid;
            }
            SePointOps_F64.transform(this.view_1_to_2, this.pointIn1, this.Xcam);
            if (!(this.Xcam.z < 0.0)) continue;
            ++foundInvalid;
        }
        return foundInvalid;
    }

    public int getBestSolutionIdx() {
        return this.bestSolutionIdx;
    }

    public int getBestInvalid() {
        return this.bestInvalid;
    }

    public double getBestModelError() {
        return this.bestModelError;
    }
}

