/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.ScaleTranslate2D;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;

public class GenerateScaleTranslate2D
implements ModelGenerator<ScaleTranslate2D, AssociatedPair> {
    double centerX1;
    double centerY1;
    double centerX2;
    double centerY2;

    @Override
    public boolean generate(List<AssociatedPair> dataSet, ScaleTranslate2D output) {
        AssociatedPair a = dataSet.get(0);
        AssociatedPair b = dataSet.get(1);
        this.centerX1 = (a.p1.x + b.p1.x) / 2.0;
        this.centerY1 = (a.p1.y + b.p1.y) / 2.0;
        this.centerX2 = (a.p2.x + b.p2.x) / 2.0;
        this.centerY2 = (a.p2.y + b.p2.y) / 2.0;
        double dx = a.p1.x - this.centerX1;
        double dy = a.p1.y - this.centerY1;
        double r1 = Math.sqrt(dx * dx + dy * dy);
        if (r1 == 0.0) {
            return false;
        }
        dx = a.p2.x - this.centerX2;
        dy = a.p2.y - this.centerY2;
        double r2 = Math.sqrt(dx * dx + dy * dy);
        double scale1 = r2 / r1;
        dx = b.p1.x - this.centerX1;
        dy = b.p1.y - this.centerY1;
        r1 = Math.sqrt(dx * dx + dy * dy);
        if (r1 == 0.0) {
            return false;
        }
        dx = b.p2.x - this.centerX2;
        dy = b.p2.y - this.centerY2;
        r2 = Math.sqrt(dx * dx + dy * dy);
        double scale2 = r2 / r1;
        output.scale = (scale1 + scale2) / 2.0;
        output.transX = this.centerX2 - this.centerX1 * output.scale;
        output.transY = this.centerY2 - this.centerY1 * output.scale;
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 2;
    }
}

