/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistanceSe2Sq
implements DistanceFromModel<Se2_F64, AssociatedPair> {
    Se2_F64 keyToCurr;
    Point2D_F64 curr2D = new Point2D_F64();

    @Override
    public void setModel(Se2_F64 keyToCurr) {
        this.keyToCurr = keyToCurr;
    }

    @Override
    public double distance(AssociatedPair sample) {
        SePointOps_F64.transform(this.keyToCurr, sample.p1, this.curr2D);
        double dx = this.curr2D.x - sample.p2.x;
        double dy = this.curr2D.y - sample.p2.y;
        return dx * dx + dy * dy;
    }

    @Override
    public void distances(List<AssociatedPair> samples, double[] distance) {
        for (int i = 0; i < samples.size(); ++i) {
            distance[i] = this.distance(samples.get(i));
        }
    }

    @Override
    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    @Override
    public Class<Se2_F64> getModelType() {
        return Se2_F64.class;
    }
}

