/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.f.EpipolarMinimizeGeometricError;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.DogArray;
import org.ejml.LinearSolverSafe;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class HomographyInducedStereo3Pts {
    private final DMatrixRMaj F21 = new DMatrixRMaj(3, 3);
    private final Point3D_F64 e2 = new Point3D_F64();
    private final DMatrixRMaj H = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj A = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj M = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj temp0 = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj temp1 = new DMatrixRMaj(3, 1);
    private final Point3D_F64 A_inv_b = new Point3D_F64();
    private final Point3D_F64 Ax = new Point3D_F64();
    private final Point3D_F64 b = new Point3D_F64();
    private final Point3D_F64 t0 = new Point3D_F64();
    private final Point3D_F64 t1 = new Point3D_F64();
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    EpipolarMinimizeGeometricError adjusterEpipolar = new EpipolarMinimizeGeometricError();
    private final DogArray<AssociatedPair> adjustedPairs = new DogArray<AssociatedPair>(AssociatedPair::new);

    public HomographyInducedStereo3Pts() {
        this.solver = new LinearSolverSafe<DMatrixRMaj>(LinearSolverFactory_DDRM.linear(3));
    }

    public void setFundamental(DMatrixRMaj F, Point3D_F64 e2) {
        if (e2 != null) {
            this.e2.setTo(e2);
        } else {
            MultiViewOps.extractEpipoles(F, new Point3D_F64(), this.e2);
        }
        GeometryMath_F64.multCrossA(this.e2, F, this.A);
        this.F21.setTo(F);
    }

    public boolean process(AssociatedPair p1, AssociatedPair p2, AssociatedPair p3) {
        this.adjustedPairs.resize(3);
        this.adjustEpipolar(p1, (AssociatedPair)this.adjustedPairs.get(0));
        this.adjustEpipolar(p2, (AssociatedPair)this.adjustedPairs.get(1));
        this.adjustEpipolar(p3, (AssociatedPair)this.adjustedPairs.get(2));
        this.fillM(((AssociatedPair)this.adjustedPairs.get((int)0)).p1, ((AssociatedPair)this.adjustedPairs.get((int)1)).p1, ((AssociatedPair)this.adjustedPairs.get((int)2)).p1);
        this.b.x = this.computeB(((AssociatedPair)this.adjustedPairs.get((int)0)).p2);
        this.b.y = this.computeB(((AssociatedPair)this.adjustedPairs.get((int)1)).p2);
        this.b.z = this.computeB(((AssociatedPair)this.adjustedPairs.get((int)2)).p2);
        if (!this.solver.setA(this.M)) {
            return false;
        }
        GeometryMath_F64.toMatrix(this.b, this.temp0);
        this.solver.solve(this.temp0, this.temp1);
        GeometryMath_F64.toTuple3D(this.temp1, this.A_inv_b);
        GeometryMath_F64.addOuterProd(this.A, -1.0, this.e2, this.A_inv_b, this.H);
        this.adjust.adjust(this.H, p1);
        return true;
    }

    private void adjustEpipolar(AssociatedPair a, AssociatedPair adjusted) {
        this.adjusterEpipolar.process(this.F21, a.p1.x, a.p1.y, a.p2.x, a.p2.y, adjusted.p1, adjusted.p2);
    }

    private void fillM(Point2D_F64 x1, Point2D_F64 x2, Point2D_F64 x3) {
        this.M.data[0] = x1.x;
        this.M.data[1] = x1.y;
        this.M.data[2] = 1.0;
        this.M.data[3] = x2.x;
        this.M.data[4] = x2.y;
        this.M.data[5] = 1.0;
        this.M.data[6] = x3.x;
        this.M.data[7] = x3.y;
        this.M.data[8] = 1.0;
    }

    private double computeB(Point2D_F64 x) {
        GeometryMath_F64.mult(this.A, x, (GeoTuple3D_F64)this.Ax);
        GeometryMath_F64.cross((GeoTuple2D_F64)x, (GeoTuple3D_F64)this.Ax, (GeoTuple3D_F64)this.t0);
        GeometryMath_F64.cross((GeoTuple2D_F64)x, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.t1);
        double top = GeometryMath_F64.dot(this.t0, this.t1);
        double bottom = this.t1.normSq();
        return top / bottom;
    }

    public DMatrixRMaj getHomography() {
        return this.H;
    }
}

