/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.ModelObservationResidual;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class EssentialResidualSampson
implements ModelObservationResidual<DMatrixRMaj, AssociatedPair> {
    DMatrixRMaj E;
    DMatrixRMaj K2E = new DMatrixRMaj(3, 3);
    DMatrixRMaj EK1 = new DMatrixRMaj(3, 3);
    Point3D_F64 temp = new Point3D_F64();
    DMatrixRMaj K1_inv = new DMatrixRMaj(3, 3);
    DMatrixRMaj K2_inv = new DMatrixRMaj(3, 3);

    public void setCalibration1(CameraPinhole pinhole) {
        DMatrixRMaj K = new DMatrixRMaj(3, 3);
        PerspectiveOps.pinholeToMatrix(pinhole, K);
        CommonOps_DDRM.invert(K, this.K1_inv);
    }

    public void setCalibration2(CameraPinhole pinhole) {
        DMatrixRMaj K = new DMatrixRMaj(3, 3);
        PerspectiveOps.pinholeToMatrix(pinhole, K);
        CommonOps_DDRM.invert(K, this.K2_inv);
    }

    @Override
    public void setModel(DMatrixRMaj E) {
        this.E = E;
        CommonOps_DDRM.multTransA(this.K2_inv, E, this.K2E);
        CommonOps_DDRM.mult(E, this.K1_inv, this.EK1);
    }

    @Override
    public double computeResidual(AssociatedPair observation) {
        double bottom = 0.0;
        GeometryMath_F64.mult(this.K2E, observation.p1, (GeoTuple3D_F64)this.temp);
        bottom += this.temp.x * this.temp.x + this.temp.y * this.temp.y;
        GeometryMath_F64.multTran(this.EK1, observation.p2, this.temp);
        if ((bottom += this.temp.x * this.temp.x + this.temp.y * this.temp.y) == 0.0) {
            return Double.MAX_VALUE;
        }
        GeometryMath_F64.multTran(this.E, observation.p2, this.temp);
        return (this.temp.x * observation.p1.x + this.temp.y * observation.p1.y + this.temp.z) / bottom;
    }
}

