/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class GradientTwo1_Standard {
    public static void process(GrayF32 orig, GrayF32 derivX, GrayF32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight();
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + orig.stride * y + 1; indexSrc < endX; ++indexSrc) {
                float val2 = data[indexSrc];
                imgX[indexX++] = val2 - data[indexSrc - 1];
                imgY[indexY++] = val2 - data[indexSrc - stride];
            }
        }
    }

    public static void process(GrayU8 orig, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight();
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                int val2 = data[indexSrc] & 0xFF;
                imgX[indexX++] = (short)(val2 - (data[indexSrc - 1] & 0xFF));
                imgY[indexY++] = (short)(val2 - (data[indexSrc - stride] & 0xFF));
            }
        }
    }

    public static void process(GrayS16 orig, GrayS16 derivX, GrayS16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight();
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                short val2 = data[indexSrc];
                imgX[indexX++] = (short)(val2 - data[indexSrc - 1]);
                imgY[indexY++] = (short)(val2 - data[indexSrc - stride]);
            }
        }
    }
}

