/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.struct.image.GrayU8;

public class ImplMedianHistogramInnerNaive {
    public static void process(GrayU8 input, GrayU8 output, int radiusX, int radiusY, int[] offset, int[] histogram) {
        if (histogram == null) {
            histogram = new int[256];
        } else if (histogram.length < 256) {
            throw new IllegalArgumentException("'histogram' must have at least 256 elements.");
        }
        int w = 2 * radiusX + 1;
        int h = 2 * radiusY + 1;
        if (offset == null) {
            offset = new int[w * h];
        } else if (offset.length < w * h) {
            throw new IllegalArgumentException("'offset' must be at least of length " + w * w);
        }
        int threshold = w * w / 2 + 1;
        int index = 0;
        for (int i = -radiusY; i <= radiusY; ++i) {
            for (int j = -radiusX; j <= radiusX; ++j) {
                offset[index++] = i * input.stride + j;
            }
        }
        for (int y = radiusY; y < input.height - radiusY; ++y) {
            for (int x = radiusX; x < input.width - radiusX; ++x) {
                int median;
                int i;
                int seed = input.startIndex + y * input.stride + x;
                for (i = 0; i < 256; ++i) {
                    histogram[i] = 0;
                }
                for (i = 0; i < offset.length; ++i) {
                    int val2;
                    int n = val2 = input.data[seed + offset[i]] & 0xFF;
                    histogram[n] = histogram[n] + 1;
                }
                int count = 0;
                for (median = 0; median < 256 && (count += histogram[median]) < threshold; ++median) {
                }
                output.data[output.startIndex + y * output.stride + x] = (byte)median;
            }
        }
    }
}

