/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.ContourTracerBase;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.ConnectRule;
import boofcv.struct.PackedSetsPoint2D_I32;
import boofcv.struct.image.GrayU8;

public class LinearExternalContours {
    private int maxContourLength = Integer.MAX_VALUE;
    private int minContourLength = 0;
    private int adjustX;
    private int adjustY;
    private Tracer tracer;
    private final PackedSetsPoint2D_I32 storagePoints = new PackedSetsPoint2D_I32();

    public LinearExternalContours(ConnectRule rule) {
        this.tracer = new Tracer(rule);
    }

    public void process(GrayU8 binary, int adjustX, int adjustY) {
        this.adjustX = adjustX;
        this.adjustY = adjustY;
        this.storagePoints.reset();
        ImageMiscOps.fillBorder(binary, 0, 1);
        this.tracer.setInputs(binary);
        byte[] binaryData = binary.data;
        block0: for (int y = 1; y < binary.height - 1; ++y) {
            int delta;
            int x = 1;
            int indexBinary = binary.startIndex + y * binary.stride + 1;
            int end = indexBinary + binary.width - 2;
            while ((indexBinary += (delta = LinearExternalContours.findNotZero(binaryData, indexBinary, end) - indexBinary)) != end) {
                x += delta;
                if (binaryData[indexBinary] == 1) {
                    if (this.tracer.trace(x, y, true)) {
                        int N = this.storagePoints.sizeOfTail();
                        if (N < this.minContourLength || N >= this.maxContourLength) {
                            this.storagePoints.removeTail();
                        }
                    } else {
                        this.storagePoints.removeTail();
                    }
                }
                if ((indexBinary += (delta = LinearExternalContours.findZero(binaryData, indexBinary, end) - indexBinary)) == end) continue block0;
                x += delta;
                if (binaryData[indexBinary - 1] == 1) {
                    this.tracer.trace(x - 1, y, false);
                    this.storagePoints.removeTail();
                    continue;
                }
                binaryData[indexBinary - 1] = -2;
            }
        }
    }

    static int findNotZero(byte[] data, int index, int end) {
        while (index < end && data[index] == 0) {
            ++index;
        }
        return index;
    }

    static int findZero(byte[] data, int index, int end) {
        while (index < end && data[index] != 0) {
            ++index;
        }
        return index;
    }

    public ConnectRule getConnectRule() {
        return this.tracer.rule;
    }

    public void setConnectRule(ConnectRule rule) {
        this.tracer = new Tracer(rule);
    }

    public PackedSetsPoint2D_I32 getExternalContours() {
        return this.storagePoints;
    }

    public int getMaxContourLength() {
        return this.maxContourLength;
    }

    public void setMaxContourLength(int maxContourLength) {
        this.maxContourLength = maxContourLength;
    }

    public int getMinContourLength() {
        return this.minContourLength;
    }

    public void setMinContourLength(int minContourLength) {
        this.minContourLength = minContourLength;
    }

    class Tracer
    extends ContourTracerBase {
        public int maxContourLength;

        public Tracer(ConnectRule rule) {
            super(rule);
            this.maxContourLength = Integer.MAX_VALUE;
        }

        public boolean trace(int initialX, int initialY, boolean external) {
            if (external) {
                this.indexBinary = this.binary.getIndex(initialX, initialY);
                if (this.rule == ConnectRule.EIGHT) {
                    if (this.binary.data[this.indexBinary + this.offsetsBinary[5]] != 0 || this.binary.data[this.indexBinary + this.offsetsBinary[6]] != 0 || this.binary.data[this.indexBinary + this.offsetsBinary[7]] != 0) {
                        external = false;
                    }
                } else if (this.binary.data[this.indexBinary + this.offsetsBinary[3]] != 0) {
                    external = false;
                }
            }
            this.maxContourLength = external ? LinearExternalContours.this.maxContourLength : -1;
            LinearExternalContours.this.storagePoints.grow();
            this.dir = this.rule == ConnectRule.EIGHT ? (external ? 7 : 6) : (external ? 0 : 3);
            this.x = initialX;
            this.y = initialY;
            this.indexBinary = this.binary.getIndex(this.x, this.y);
            LinearExternalContours.this.storagePoints.addPointToTail(this.x - LinearExternalContours.this.adjustX, this.y - LinearExternalContours.this.adjustY);
            this.binary.data[this.indexBinary] = -2;
            if (!this.searchNotZero()) {
                return true;
            }
            int initialDir = this.dir;
            this.moveToNext();
            this.dir = this.nextDirection[this.dir];
            while (true) {
                this.searchNotZero();
                if (this.binary.data[this.indexBinary] != -2) {
                    this.binary.data[this.indexBinary] = -1;
                } else {
                    if (this.x != initialX || this.y != initialY) {
                        return false;
                    }
                    if (this.dir == initialDir) {
                        return external;
                    }
                }
                if (LinearExternalContours.this.storagePoints.sizeOfTail() <= this.maxContourLength) {
                    LinearExternalContours.this.storagePoints.addPointToTail(this.x - LinearExternalContours.this.adjustX, this.y - LinearExternalContours.this.adjustY);
                }
                this.moveToNext();
                this.dir = this.nextDirection[this.dir];
            }
        }

        private boolean searchNotZero() {
            if (this.ruleN == 4) {
                return this.searchNotOne4();
            }
            return this.searchNotOne8();
        }

        private boolean searchNotOne4() {
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 4;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 4;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 4;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 4;
            return false;
        }

        private boolean searchNotOne8() {
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            if (this.binary.data[this.indexBinary + this.offsetsBinary[this.dir]] != 0) {
                return true;
            }
            this.dir = (this.dir + 1) % 8;
            return false;
        }

        private void moveToNext() {
            this.indexBinary += this.offsetsBinary[this.dir];
            int a = this.indexBinary - this.binary.startIndex;
            this.x = a % this.binary.stride;
            this.y = a / this.binary.stride;
        }
    }
}

