/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

public class ComputeOtsu {
    private boolean useOtsu2;
    public double threshold;
    public double variance;
    private double tuning;
    public boolean down;
    private double scale;

    public ComputeOtsu(boolean useOtsu2, double tuning, boolean down, double scale) {
        this.useOtsu2 = useOtsu2;
        this.tuning = tuning;
        this.down = down;
        this.scale = scale;
    }

    public ComputeOtsu(boolean useOtsu2, boolean down) {
        this(useOtsu2, 0.0, down, 1.0);
    }

    public void compute(int[] histogram, int length, int totalPixels) {
        if (this.useOtsu2) {
            this.computeOtsu2(histogram, length, totalPixels);
        } else {
            this.computeOtsu(histogram, length, totalPixels);
        }
        this.variance += 0.001;
        int adjustment = (int)(this.tuning * this.threshold * this.tuning * this.threshold / this.variance + 0.5);
        this.threshold += this.down ? (double)(-adjustment) : (double)adjustment;
        this.threshold = (int)(this.scale * Math.max(this.threshold, 0.0) + 0.5);
    }

    protected void computeOtsu(int[] histogram, int length, int totalPixels) {
        double dlength = length;
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)i / dlength * (double)histogram[i];
        }
        double sumB = 0.0;
        int wB = 0;
        this.variance = 0.0;
        this.threshold = 0.0;
        for (int i = 0; i < length; ++i) {
            double mF;
            double varBetween;
            if ((wB += histogram[i]) == 0) continue;
            int wF = totalPixels - wB;
            if (wF == 0) break;
            double f = (double)i / dlength;
            double mB = (sumB += f * (double)histogram[i]) / (double)wB;
            if (!((varBetween = (double)wB * (double)wF * (mB - (mF = (sum - sumB) / (double)wF)) * (mB - mF)) > this.variance)) continue;
            this.variance = varBetween;
            this.threshold = i;
        }
    }

    protected void computeOtsu2(int[] histogram, int length, int totalPixels) {
        double dlength = length;
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)i / dlength * (double)histogram[i];
        }
        double sumB = 0.0;
        int wB = 0;
        this.variance = 0.0;
        this.threshold = 0.0;
        double selectedMB = 0.0;
        double selectedMF = 0.0;
        for (int i = 0; i < length; ++i) {
            double mF;
            double varBetween;
            if ((wB += histogram[i]) == 0) continue;
            int wF = totalPixels - wB;
            if (wF == 0) break;
            double f = (double)i / dlength;
            double mB = (sumB += f * (double)histogram[i]) / (double)wB;
            if (!((varBetween = (double)wB * (double)wF * (mB - (mF = (sum - sumB) / (double)wF)) * (mB - mF)) > this.variance)) continue;
            this.variance = varBetween;
            selectedMB = mB;
            selectedMF = mF;
        }
        this.threshold = (double)length * (selectedMB + selectedMF) / 2.0;
    }

    public boolean isUseOtsu2() {
        return this.useOtsu2;
    }

    public void setUseOtsu2(boolean useOtsu2) {
        this.useOtsu2 = useOtsu2;
    }

    public double getTuning() {
        return this.tuning;
    }

    public void setTuning(double tuning) {
        this.tuning = tuning;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }
}

