/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeAlignmentPatternLocator;
import boofcv.alg.fiducial.qrcode.QrCodeBinaryGridReader;
import boofcv.alg.fiducial.qrcode.QrCodeDecoderBits;
import boofcv.alg.fiducial.qrcode.QrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.QrCodePolynomialMath;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class QrCodeDecoderImage<T extends ImageGray<T>> {
    QrCodeDecoderBits decoder;
    DogArray<QrCode> storageQR = new DogArray<QrCode>(QrCode::new);
    List<QrCode> successes = new ArrayList<QrCode>();
    List<QrCode> failures = new ArrayList<QrCode>();
    PackedBits8 bits = new PackedBits8();
    Point2D_F64 grid = new Point2D_F64();
    QrCodeAlignmentPatternLocator<T> alignmentLocator;
    QrCodeBinaryGridReader<T> gridReader;

    public QrCodeDecoderImage(String forceEncoding, Class<T> imageType) {
        this.decoder = new QrCodeDecoderBits(forceEncoding);
        this.gridReader = new QrCodeBinaryGridReader<T>(imageType);
        this.alignmentLocator = new QrCodeAlignmentPatternLocator<T>(imageType);
    }

    public void process(DogArray<PositionPatternNode> pps, T gray) {
        this.gridReader.setImage(gray);
        this.storageQR.reset();
        this.successes.clear();
        this.failures.clear();
        for (int i = 0; i < pps.size; ++i) {
            PositionPatternNode ppn = (PositionPatternNode)pps.get(i);
            int j = 3;
            int k = 0;
            while (k < 4) {
                if (ppn.edges[j] != null && ppn.edges[k] != null) {
                    QrCode qr = this.storageQR.grow();
                    qr.reset();
                    QrCodeDecoderImage.setPositionPatterns(ppn, j, k, qr);
                    QrCodeDecoderImage.computeBoundingBox(qr);
                    if (this.decode(gray, qr)) {
                        this.successes.add(qr);
                    } else {
                        this.failures.add(qr);
                    }
                }
                j = k++;
            }
        }
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.alignmentLocator.setLensDistortion(width, height, model);
        this.gridReader.setLensDistortion(width, height, model);
    }

    static void setPositionPatterns(PositionPatternNode ppn, int cornerToRight, int cornerToDown, QrCode qr) {
        PositionPatternNode right = (PositionPatternNode)ppn.edges[cornerToRight].destination(ppn);
        PositionPatternNode down = (PositionPatternNode)ppn.edges[cornerToDown].destination(ppn);
        qr.ppRight.setTo(right.square);
        qr.ppCorner.setTo(ppn.square);
        qr.ppDown.setTo(down.square);
        qr.threshRight = right.grayThreshold;
        qr.threshCorner = ppn.grayThreshold;
        qr.threshDown = down.grayThreshold;
        int indexR = right.findEdgeIndex(ppn);
        int indexD = down.findEdgeIndex(ppn);
        QrCodeDecoderImage.rotateUntilAt(qr.ppRight, indexR, 3);
        QrCodeDecoderImage.rotateUntilAt(qr.ppCorner, cornerToRight, 1);
        QrCodeDecoderImage.rotateUntilAt(qr.ppDown, indexD, 0);
    }

    static void rotateUntilAt(Polygon2D_F64 square, int current, int desired) {
        while (current != desired) {
            UtilPolygons2D_F64.shiftDown(square);
            current = (current + 1) % 4;
        }
    }

    static void computeBoundingBox(QrCode qr) {
        qr.bounds.get(0).setTo(qr.ppCorner.get(0));
        qr.bounds.get(1).setTo(qr.ppRight.get(1));
        Intersection2D_F64.intersection(qr.ppRight.get(1), qr.ppRight.get(2), qr.ppDown.get(3), qr.ppDown.get(2), qr.bounds.get(2));
        qr.bounds.get(3).setTo(qr.ppDown.get(3));
    }

    private boolean decode(T gray, QrCode qr) {
        boolean removed;
        if (!this.extractFormatInfo(qr)) {
            qr.failureCause = QrCode.Failure.FORMAT;
            return false;
        }
        if (!this.extractVersionInfo(qr)) {
            qr.failureCause = QrCode.Failure.VERSION;
            return false;
        }
        if (!this.alignmentLocator.process(gray, qr)) {
            qr.failureCause = QrCode.Failure.ALIGNMENT;
            return false;
        }
        boolean success = false;
        this.gridReader.setMarker(qr);
        this.gridReader.getTransformGrid().addAllFeatures(qr);
        for (int i = 0; i < 6 && (i <= 0 || (removed = this.gridReader.getTransformGrid().removeFeatureWithLargestError())); ++i) {
            this.gridReader.getTransformGrid().computeTransform();
            qr.failureCause = QrCode.Failure.NONE;
            if (!this.readRawData(qr)) {
                qr.failureCause = QrCode.Failure.READING_BITS;
                continue;
            }
            if (!this.decoder.applyErrorCorrection(qr)) {
                qr.failureCause = QrCode.Failure.ERROR_CORRECTION;
                continue;
            }
            success = true;
            break;
        }
        if (success && !this.decoder.decodeMessage(qr)) {
            success = false;
        }
        qr.Hinv.setTo(this.gridReader.getTransformGrid().Hinv);
        return success;
    }

    private boolean extractFormatInfo(QrCode qr) {
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                this.readFormatRegion0(qr);
            } else {
                this.readFormatRegion1(qr);
            }
            int bitField = this.bits.read(0, 15, false);
            int message = QrCodePolynomialMath.checkFormatBits(bitField ^= 0x5412) ? bitField >> 10 : QrCodePolynomialMath.correctFormatBits(bitField);
            if (message < 0) continue;
            QrCodePolynomialMath.decodeFormatMessage(message, qr);
            return true;
        }
        return false;
    }

    final boolean readFormatRegion0(QrCode qr) {
        int i;
        this.gridReader.setSquare(qr.ppCorner, (float)qr.threshCorner);
        this.bits.resize(15);
        this.bits.zero();
        for (i = 0; i < 6; ++i) {
            this.read(i, i, 8);
        }
        this.read(6, 7, 8);
        this.read(7, 8, 8);
        this.read(8, 8, 7);
        for (i = 0; i < 6; ++i) {
            this.read(9 + i, 8, 5 - i);
        }
        return true;
    }

    final boolean readFormatRegion1(QrCode qr) {
        int i;
        this.gridReader.setSquare(qr.ppRight, (float)qr.threshRight);
        this.bits.resize(15);
        this.bits.zero();
        for (i = 0; i < 8; ++i) {
            this.read(i, 8, 6 - i);
        }
        this.gridReader.setSquare(qr.ppDown, (float)qr.threshDown);
        for (i = 0; i < 7; ++i) {
            this.read(i + 8, i, 8);
        }
        return true;
    }

    private boolean readRawData(QrCode qr) {
        QrCode.VersionInfo info = QrCode.VERSION_INFO[qr.version];
        qr.rawbits = new byte[info.codewords];
        this.bits.resize(info.codewords * 8);
        List<Point2D_I32> locationBits = QrCode.LOCATION_BITS[qr.version];
        for (int i = 0; i < this.bits.size; ++i) {
            Point2D_I32 b = locationBits.get(i);
            this.readDataMatrix(i, b.y, b.x, qr.mask);
        }
        System.arraycopy(this.bits.data, 0, qr.rawbits, 0, qr.rawbits.length);
        return true;
    }

    private void read(int bit, int row, int col) {
        int value = this.gridReader.readBit(row, col);
        if (value == -1) {
            value = 0;
        }
        this.bits.set(bit, value);
    }

    private void readDataMatrix(int bit, int row, int col, QrCodeMaskPattern mask) {
        int value = this.gridReader.readBit(row, col);
        if (value == -1) {
            value = 0;
        }
        this.bits.set(bit, mask.apply(row, col, value));
    }

    boolean extractVersionInfo(QrCode qr) {
        int version = this.estimateVersionBySize(qr);
        if (version >= 7) {
            this.readVersionRegion0(qr);
            int version0 = this.decodeVersion();
            this.readVersionRegion1(qr);
            int version1 = this.decodeVersion();
            version = version0 < 1 && version1 < 1 ? -1 : (version0 < 1 ? version1 : (version1 < 1 ? version0 : (version0 != version1 ? -1 : version0)));
        } else if (version <= 0) {
            version = -1;
        }
        qr.version = version;
        return version >= 1 && version <= 40;
    }

    int decodeVersion() {
        int bitField = this.bits.read(0, 18, false);
        int message = QrCodePolynomialMath.checkVersionBits(bitField) ? bitField >> 12 : QrCodePolynomialMath.correctVersionBits(bitField);
        if (message > 40 || message < 7) {
            return -1;
        }
        return message;
    }

    int estimateVersionBySize(QrCode qr) {
        this.gridReader.setMarkerUnknownVersion(qr, 0.0f);
        this.gridReader.imageToGrid(qr.ppRight.get(0), this.grid);
        if (Math.abs(this.grid.y / this.grid.x) >= 0.3) {
            return -1;
        }
        double versionX = (this.grid.x + 7.0 - 17.0) / 4.0;
        this.gridReader.imageToGrid(qr.ppDown.get(0), this.grid);
        if (Math.abs(this.grid.x / this.grid.y) >= 0.3) {
            return -1;
        }
        double versionY = (this.grid.y + 7.0 - 17.0) / 4.0;
        if (Math.abs(versionX - versionY) / Math.max(versionX, versionY) > 0.4) {
            return -1;
        }
        return (int)((versionX + versionY) / 2.0 + 0.5);
    }

    private boolean readVersionRegion0(QrCode qr) {
        this.gridReader.setSquare(qr.ppRight, (float)qr.threshRight);
        this.bits.resize(18);
        this.bits.zero();
        for (int i = 0; i < 18; ++i) {
            int row = i / 3;
            int col = i % 3;
            this.read(i, row, col - 4);
        }
        return true;
    }

    private boolean readVersionRegion1(QrCode qr) {
        this.gridReader.setSquare(qr.ppDown, (float)qr.threshDown);
        this.bits.resize(18);
        this.bits.zero();
        for (int i = 0; i < 18; ++i) {
            int row = i % 3;
            int col = i / 3;
            this.read(i, row - 4, col);
        }
        return true;
    }

    public QrCodeAlignmentPatternLocator<T> getAlignmentLocator() {
        return this.alignmentLocator;
    }

    public List<QrCode> getFound() {
        return this.successes;
    }

    public List<QrCode> getFailures() {
        return this.failures;
    }
}

