/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray_B;

public class ChessboardPolygonHelper<T extends ImageGray<T>>
implements PolygonHelper {
    int width;
    int height;

    @Override
    public void setImageShape(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean filterContour(List<Point2D_I32> contour, boolean touchesBorder, boolean distorted) {
        return true;
    }

    @Override
    public boolean filterPixelPolygon(Polygon2D_F64 undistorted, Polygon2D_F64 distorted, DogArray_B touches, boolean touchesBorder) {
        if (touchesBorder) {
            if (distorted.size() < 3) {
                return false;
            }
            int totalRegular = distorted.size();
            for (int i = 0; i < distorted.size(); ++i) {
                if (!touches.get(i)) continue;
                --totalRegular;
            }
            return totalRegular > 0;
        }
        return distorted.size() == 4;
    }

    @Override
    public void configureBeforePolyline(PointsToPolyline contourToPolyline, boolean touchesBorder) {
        if (touchesBorder) {
            contourToPolyline.setConvex(false);
            contourToPolyline.setMinimumSides(3);
            contourToPolyline.setMaximumSides(8);
        } else {
            contourToPolyline.setConvex(true);
            contourToPolyline.setMinimumSides(4);
            contourToPolyline.setMaximumSides(4);
        }
    }
}

