/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.GrayF32;

public class ImplSsdCornerWeighted_F32
extends ImplSsdCornerBase<GrayF32, GrayF32> {
    ImplSsdCornerBase.CornerIntensity_F32 intensity;
    Kernel1D_F32 kernel;
    GrayF32 temp = new GrayF32(1, 1);

    public ImplSsdCornerWeighted_F32(int radius, ImplSsdCornerBase.CornerIntensity_F32 intensity) {
        super(radius, GrayF32.class, GrayF32.class);
        this.intensity = intensity;
        this.kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, -1.0, radius);
    }

    @Override
    public void process(GrayF32 derivX, GrayF32 derivY, GrayF32 intensity) {
        int y;
        InputSanityCheck.checkSameShape(derivX, derivY);
        intensity.reshape(derivX.width, derivX.height);
        int w = derivX.width;
        int h = derivX.height;
        ((GrayF32)this.horizXX).reshape(w, h);
        ((GrayF32)this.horizXY).reshape(w, h);
        ((GrayF32)this.horizYY).reshape(w, h);
        this.temp.reshape(w, h);
        intensity.reshape(w, h);
        for (y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int index = ((GrayF32)this.horizXX).stride * y;
            int x = 0;
            while (x < w) {
                float dx = derivX.data[indexX++];
                float dy = derivY.data[indexY++];
                ((GrayF32)this.horizXX).data[index] = dx * dx;
                ((GrayF32)this.horizXY).data[index] = dx * dy;
                ((GrayF32)this.horizYY).data[index] = dy * dy;
                ++x;
                ++index;
            }
        }
        this.blur((GrayF32)this.horizXX, this.temp);
        this.blur((GrayF32)this.horizXY, this.temp);
        this.blur((GrayF32)this.horizYY, this.temp);
        for (y = 0; y < h; ++y) {
            int index = ((GrayF32)this.horizXX).stride * y;
            int x = 0;
            while (x < w) {
                float totalXX = ((GrayF32)this.horizXX).data[index];
                float totalXY = ((GrayF32)this.horizXY).data[index];
                float totalYY = ((GrayF32)this.horizYY).data[index];
                intensity.data[index] = this.intensity.compute(totalXX, totalXY, totalYY);
                ++x;
                ++index;
            }
        }
    }

    private void blur(GrayF32 image, GrayF32 temp) {
        ConvolveImageNormalized.horizontal(this.kernel, image, temp);
        ConvolveImageNormalized.vertical(this.kernel, temp, image);
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }
}

