/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import org.jetbrains.annotations.Nullable;

public class NonMaxBlock {
    protected final Configuration configuration = new Configuration();
    protected int border;
    protected Search search;

    public NonMaxBlock(Search search) {
        this.search = search;
    }

    public void process(GrayF32 intensityImage, @Nullable QueueCorner localMin, @Nullable QueueCorner localMax) {
        if (localMin != null) {
            localMin.reset();
        }
        if (localMax != null) {
            localMax.reset();
        }
        int endX = intensityImage.width - this.border;
        int endY = intensityImage.height - this.border;
        int step = this.configuration.radius + 1;
        this.search.initialize(this.configuration, intensityImage, localMin, localMax);
        for (int y = this.border; y < endY; y += step) {
            int y1 = y + step;
            if (y1 > endY) {
                y1 = endY;
            }
            for (int x = this.border; x < endX; x += step) {
                int x1 = x + step;
                if (x1 > endX) {
                    x1 = endX;
                }
                this.search.searchBlock(x, y, x1, y1);
            }
        }
    }

    public Search getSearch() {
        return this.search;
    }

    public void setSearchRadius(int radius) {
        this.configuration.radius = radius;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public int getSearchRadius() {
        return this.configuration.radius;
    }

    public float getThresholdMin() {
        return this.configuration.thresholdMin;
    }

    public void setThresholdMin(float thresholdMin) {
        this.configuration.thresholdMin = thresholdMin;
    }

    public float getThresholdMax() {
        return this.configuration.thresholdMax;
    }

    public void setThresholdMax(float thresholdMax) {
        this.configuration.thresholdMax = thresholdMax;
    }

    static class Configuration {
        public float thresholdMin;
        public float thresholdMax;
        public int radius;

        Configuration() {
        }
    }

    public static interface Search {
        public void initialize(Configuration var1, GrayF32 var2, QueueCorner var3, QueueCorner var4);

        public void searchBlock(int var1, int var2, int var3, int var4);

        public boolean isDetectMinimums();

        public boolean isDetectMaximums();

        public Search newInstance();
    }
}

