/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.impl;

import boofcv.alg.feature.describe.SurfDescribeOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sparse.SparseGradientSafe;
import boofcv.struct.sparse.SparseScaleGradient;

public class ImplSurfDescribeOps {
    public static void gradientInner(GrayF32 ii, double tl_x, double tl_y, double samplePeriod, int regionSize, double kernelSize, float[] derivX, float[] derivY) {
        tl_x += 0.5;
        tl_y += 0.5;
        int w = (int)(kernelSize + 0.5);
        int r = w / 2;
        if (r <= 0) {
            r = 1;
        }
        w = r * 2 + 1;
        int i = 0;
        for (int y = 0; y < regionSize; ++y) {
            int pixelsY = (int)(tl_y + (double)y * samplePeriod);
            int indexRow1 = ii.startIndex + (pixelsY - r - 1) * ii.stride - r - 1;
            int indexRow2 = indexRow1 + r * ii.stride;
            int indexRow3 = indexRow2 + ii.stride;
            int indexRow4 = indexRow3 + r * ii.stride;
            int x = 0;
            while (x < regionSize) {
                int pixelsX = (int)(tl_x + (double)x * samplePeriod);
                int indexSrc1 = indexRow1 + pixelsX;
                int indexSrc2 = indexRow2 + pixelsX;
                int indexSrc3 = indexRow3 + pixelsX;
                int indexSrc4 = indexRow4 + pixelsX;
                float p0 = ii.data[indexSrc1];
                float p1 = ii.data[indexSrc1 + r];
                float p2 = ii.data[indexSrc1 + r + 1];
                float p3 = ii.data[indexSrc1 + w];
                float p11 = ii.data[indexSrc2];
                float p4 = ii.data[indexSrc2 + w];
                float p10 = ii.data[indexSrc3];
                float p5 = ii.data[indexSrc3 + w];
                float p9 = ii.data[indexSrc4];
                float p8 = ii.data[indexSrc4 + r];
                float p7 = ii.data[indexSrc4 + r + 1];
                float p6 = ii.data[indexSrc4 + w];
                float left = p8 - p9 - p1 + p0;
                float right = p6 - p7 - p3 + p2;
                float top = p4 - p11 - p3 + p0;
                float bottom = p6 - p9 - p5 + p10;
                derivX[i] = right - left;
                derivY[i] = bottom - top;
                ++x;
                ++i;
            }
        }
    }

    public static void gradientInner(GrayS32 ii, double tl_x, double tl_y, double samplePeriod, int regionSize, double kernelSize, int[] derivX, int[] derivY) {
        tl_x += 0.5;
        tl_y += 0.5;
        int w = (int)(kernelSize + 0.5);
        int r = w / 2;
        if (r <= 0) {
            r = 1;
        }
        w = r * 2 + 1;
        int i = 0;
        for (int y = 0; y < regionSize; ++y) {
            int pixelsY = (int)(tl_y + (double)y * samplePeriod);
            int indexRow1 = ii.startIndex + (pixelsY - r - 1) * ii.stride - r - 1;
            int indexRow2 = indexRow1 + r * ii.stride;
            int indexRow3 = indexRow2 + ii.stride;
            int indexRow4 = indexRow3 + r * ii.stride;
            int x = 0;
            while (x < regionSize) {
                int pixelsX = (int)(tl_x + (double)x * samplePeriod);
                int indexSrc1 = indexRow1 + pixelsX;
                int indexSrc2 = indexRow2 + pixelsX;
                int indexSrc3 = indexRow3 + pixelsX;
                int indexSrc4 = indexRow4 + pixelsX;
                int p0 = ii.data[indexSrc1];
                int p1 = ii.data[indexSrc1 + r];
                int p2 = ii.data[indexSrc1 + r + 1];
                int p3 = ii.data[indexSrc1 + w];
                int p11 = ii.data[indexSrc2];
                int p4 = ii.data[indexSrc2 + w];
                int p10 = ii.data[indexSrc3];
                int p5 = ii.data[indexSrc3 + w];
                int p9 = ii.data[indexSrc4];
                int p8 = ii.data[indexSrc4 + r];
                int p7 = ii.data[indexSrc4 + r + 1];
                int p6 = ii.data[indexSrc4 + w];
                int left = p8 - p9 - p1 + p0;
                int right = p6 - p7 - p3 + p2;
                int top = p4 - p11 - p3 + p0;
                int bottom = p6 - p9 - p5 + p10;
                derivX[i] = right - left;
                derivY[i] = bottom - top;
                ++x;
                ++i;
            }
        }
    }

    public static <T extends ImageGray<T>> void naiveGradient(T ii, double tl_x, double tl_y, double samplePeriod, int regionSize, double kernelSize, boolean useHaar, double[] derivX, double[] derivY) {
        SparseScaleGradient<?, ?> gg = SurfDescribeOps.createGradient(useHaar, ii.getClass());
        gg.setWidth(kernelSize);
        gg.setImage(ii);
        SparseGradientSafe g = new SparseGradientSafe(gg);
        tl_x += 0.5;
        tl_y += 0.5;
        int i = 0;
        for (int y = 0; y < regionSize; ++y) {
            int x = 0;
            while (x < regionSize) {
                int xx = (int)(tl_x + (double)x * samplePeriod);
                int yy = (int)(tl_y + (double)y * samplePeriod);
                Object deriv = g.compute(xx, yy);
                derivX[i] = deriv.getX();
                derivY[i] = deriv.getY();
                ++x;
                ++i;
            }
        }
    }
}

