/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.struct.geo.GeoLL_F32;
import georegression.geometry.ConvertCoordinates3D_F32;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;

public class EquirectangularTools_F32 {
    int width;
    int height;
    GeoLL_F32 temp = new GeoLL_F32();

    public void configure(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void equiToNorm(float x, float y, Point3D_F32 norm) {
        this.equiToLatLon(x, y, this.temp);
        ConvertCoordinates3D_F32.latlonToUnitVector(this.temp.lat, this.temp.lon, norm);
    }

    public void normToEqui(float nx, float ny, float nz, Point2D_F32 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe((double)(-nz), r);
        this.latlonToEqui((float)lat, (float)lon, rect);
    }

    public void equiToNormFV(float x, float y, Point3D_F32 norm) {
        this.equiToLatLonFV(x, y, this.temp);
        ConvertCoordinates3D_F32.latlonToUnitVector(this.temp.lat, this.temp.lon, norm);
    }

    public void normToEquiFV(float nx, float ny, float nz, Point2D_F32 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe((double)(-nz), r);
        this.latlonToEquiFV((float)lat, (float)lon, rect);
    }

    public void equiToLatLon(float x, float y, GeoLL_F32 geo) {
        geo.lon = (x / (float)this.width - 0.5f) * GrlConstants.F_PI2;
        geo.lat = (y / (float)(this.height - 1) - 0.5f) * GrlConstants.F_PI;
    }

    public void equiToLatLonFV(float x, float y, GeoLL_F32 geo) {
        geo.lon = (x / (float)this.width - 0.5f) * GrlConstants.F_PI2;
        geo.lat = (((float)this.height - y - 1.0f) / (float)(this.height - 1) - 0.5f) * GrlConstants.F_PI;
    }

    public void latlonToEqui(float lat, float lon, Point2D_F32 rect) {
        rect.x = UtilAngle.wrapZeroToOne(lon / GrlConstants.F_PI2 + 0.5f) * (float)this.width;
        rect.y = UtilAngle.reflectZeroToOne(lat / GrlConstants.F_PI + 0.5f) * (float)(this.height - 1);
    }

    public void latlonToEquiFV(float lat, float lon, Point2D_F32 rect) {
        rect.x = UtilAngle.wrapZeroToOne(lon / GrlConstants.F_PI2 + 0.5f) * (float)this.width;
        rect.y = UtilAngle.reflectZeroToOne(lat / GrlConstants.F_PI + 0.5f) * (float)(this.height - 1);
        rect.y = (float)this.height - rect.y - 1.0f;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

