/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.PointTransformHomography_F64;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.PointToPixelTransform_F64;
import boofcv.struct.distort.SequencePoint2Transform2_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.RectangleLength2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class LensDistortionOps_F64 {
    public static <O extends CameraPinhole, D extends CameraPinhole> Point2Transform2_F64 transformChangeModel(AdjustmentType type, O paramOriginal, D paramDesired, boolean desiredToOriginal, D paramMod) {
        RectangleLength2D_F64 bound;
        LensDistortionNarrowFOV original = LensDistortionFactory.narrow(paramOriginal);
        LensDistortionNarrowFOV desired = LensDistortionFactory.narrow(paramDesired);
        Point2Transform2_F64 ori_p_to_n = original.undistort_F64(true, false);
        Point2Transform2_F64 des_n_to_p = desired.distort_F64(false, true);
        SequencePoint2Transform2_F64 ori_to_des = new SequencePoint2Transform2_F64(ori_p_to_n, des_n_to_p);
        Point2D_F64 work = new Point2D_F64();
        if (type == AdjustmentType.FULL_VIEW) {
            bound = DistortImageOps.boundBox_F64(paramOriginal.width, paramOriginal.height, new PointToPixelTransform_F64(ori_to_des), work);
        } else if (type == AdjustmentType.EXPAND) {
            bound = LensDistortionOps_F64.boundBoxInside(paramOriginal.width, paramOriginal.height, new PointToPixelTransform_F64(ori_to_des), work);
            LensDistortionOps_F64.roundInside(bound);
        } else if (type == AdjustmentType.CENTER) {
            bound = LensDistortionOps_F64.centerBoxInside(paramOriginal.width, paramOriginal.height, new PointToPixelTransform_F64(ori_to_des), work);
        } else if (type == AdjustmentType.NONE) {
            bound = new RectangleLength2D_F64(0.0, 0.0, paramDesired.width, paramDesired.height);
        } else {
            throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
        }
        double scaleX = bound.width / (double)paramDesired.width;
        double scaleY = bound.height / (double)paramDesired.height;
        double scale = type == AdjustmentType.FULL_VIEW ? Math.max(scaleX, scaleY) : (type == AdjustmentType.EXPAND ? Math.min(scaleX, scaleY) : (type == AdjustmentType.CENTER ? Math.max(scaleX, scaleY) : 1.0));
        double deltaX = bound.x0 + (scaleX - scale) * (double)paramDesired.width / 2.0;
        double deltaY = bound.y0 + (scaleY - scale) * (double)paramDesired.height / 2.0;
        DMatrixRMaj A = new DMatrixRMaj(3, 3, true, scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0);
        DMatrixRMaj A_inv = new DMatrixRMaj(3, 3);
        if (!CommonOps_DDRM.invert(A, A_inv)) {
            throw new RuntimeException("Failed to invert adjustment matrix. Probably bad.");
        }
        if (paramMod != null) {
            PerspectiveOps.adjustIntrinsic(paramDesired, A_inv, paramMod);
        }
        if (desiredToOriginal) {
            Point2Transform2_F64 des_p_to_n = desired.undistort_F64(true, false);
            Point2Transform2_F64 ori_n_to_p = original.distort_F64(false, true);
            PointTransformHomography_F64 adjust = new PointTransformHomography_F64(A);
            return new SequencePoint2Transform2_F64(adjust, des_p_to_n, ori_n_to_p);
        }
        PointTransformHomography_F64 adjust = new PointTransformHomography_F64(A_inv);
        return new SequencePoint2Transform2_F64(ori_to_des, adjust);
    }

    public static RectangleLength2D_F64 boundBoxInside(int srcWidth, int srcHeight, PixelTransform<Point2D_F64> transform, Point2D_F64 work) {
        List<Point2D_F64> points = LensDistortionOps_F64.computeBoundingPoints(srcWidth, srcHeight, transform, work);
        Point2D_F64 center = new Point2D_F64();
        UtilPoint2D_F64.mean(points, center);
        double y0 = 3.4028234663852886E38;
        double x0 = 3.4028234663852886E38;
        double y1 = -3.4028234663852886E38;
        double x1 = -3.4028234663852886E38;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (p.x < x0) {
                x0 = p.x;
            }
            if (p.x > x1) {
                x1 = p.x;
            }
            if (p.y < y0) {
                y0 = p.y;
            }
            if (!(p.y > y1)) continue;
            y1 = p.y;
        }
        double ox0 = x0 -= center.x;
        double oy0 = y0 -= center.y;
        double ox1 = x1 -= center.x;
        double oy1 = y1 -= center.y;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            double dx = p.x - center.x;
            double dy = p.y - center.y;
            if (!(dx > x0) || !(dy > y0) || !(dx < x1) || !(dy < y1)) continue;
            double d0 = Math.abs(dx - x0) + x0 - ox0;
            double d1 = Math.abs(dx - x1) + ox1 - x1;
            double d2 = Math.abs(dy - y0) + y0 - oy0;
            double d3 = Math.abs(dy - y1) + oy1 - y1;
            if (d0 <= d1 && d0 <= d2 && d0 <= d3) {
                x0 = dx;
                continue;
            }
            if (d1 <= d2 && d1 <= d3) {
                x1 = dx;
                continue;
            }
            if (d2 <= d3) {
                y0 = dy;
                continue;
            }
            y1 = dy;
        }
        return new RectangleLength2D_F64(x0 + center.x, y0 + center.y, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F64 centerBoxInside(int srcWidth, int srcHeight, PixelTransform<Point2D_F64> transform, Point2D_F64 work) {
        List<Point2D_F64> points = LensDistortionOps_F64.computeBoundingPoints(srcWidth, srcHeight, transform, work);
        Point2D_F64 center = new Point2D_F64();
        UtilPoint2D_F64.mean(points, center);
        double y1 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double x0 = 0.0;
        double by1 = Double.MAX_VALUE;
        double by0 = Double.MAX_VALUE;
        double bx1 = Double.MAX_VALUE;
        double bx0 = Double.MAX_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            double ady;
            Point2D_F64 p = points.get(i);
            double dx = p.x - center.x;
            double dy = p.y - center.y;
            double adx = Math.abs(dx);
            if (adx < (ady = Math.abs(dy))) {
                if (dy < 0.0) {
                    if (!(adx < by0)) continue;
                    by0 = adx;
                    y0 = dy;
                    continue;
                }
                if (!(adx < by1)) continue;
                by1 = adx;
                y1 = dy;
                continue;
            }
            if (dx < 0.0) {
                if (!(ady < bx0)) continue;
                bx0 = ady;
                x0 = dx;
                continue;
            }
            if (!(ady < bx1)) continue;
            bx1 = ady;
            x1 = dx;
        }
        return new RectangleLength2D_F64(x0 + center.x, y0 + center.y, x1 - x0, y1 - y0);
    }

    private static List<Point2D_F64> computeBoundingPoints(int srcWidth, int srcHeight, PixelTransform<Point2D_F64> transform, Point2D_F64 work) {
        ArrayList<Point2D_F64> points = new ArrayList<Point2D_F64>();
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0, work);
            points.add(new Point2D_F64(work.x, work.y));
            transform.compute(x, srcHeight, work);
            points.add(new Point2D_F64(work.x, work.y));
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y, work);
            points.add(new Point2D_F64(work.x, work.y));
            transform.compute(srcWidth, y, work);
            points.add(new Point2D_F64(work.x, work.y));
        }
        return points;
    }

    public static void roundInside(RectangleLength2D_F64 bound) {
        double x0 = Math.ceil(bound.x0);
        double y0 = Math.ceil(bound.y0);
        double x1 = Math.floor(bound.x0 + bound.width);
        double y1 = Math.floor(bound.y0 + bound.height);
        bound.x0 = x0;
        bound.y0 = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }
}

