/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AssignPixelValue_MB;
import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageInterleaved;
import georegression.struct.point.Point2D_F32;
import java.util.ArrayDeque;

public class ImageDistortBasic_IL_MT<Input extends ImageInterleaved<Input>, Output extends ImageInterleaved<Output>>
extends ImageDistortBasic<Input, Output, InterpolatePixelMB<Input>> {
    private AssignPixelValue_MB<Output> assigner;
    private final ArrayDeque<BlockDistort> queue = new ArrayDeque();

    public ImageDistortBasic_IL_MT(AssignPixelValue_MB<Output> assigner, InterpolatePixelMB<Input> interp) {
        super(interp);
        this.assigner = assigner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockDistort pop() {
        ArrayDeque<BlockDistort> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            if (this.queue.isEmpty()) {
                return new BlockDistort();
            }
            return this.queue.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(BlockDistort b) {
        ArrayDeque<BlockDistort> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            this.queue.push(b);
        }
    }

    @Override
    protected void init(Input srcImg, Output dstImg) {
        super.init(srcImg, dstImg);
        this.assigner.setImage(dstImg);
    }

    @Override
    public void applyAll() {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyAll(y0, y1);
            this.recycle(b);
        });
    }

    @Override
    public void applyAll(GrayU8 mask) {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyAll(y0, y1, mask);
            this.recycle(b);
        });
    }

    @Override
    public void applyOnlyInside() {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyOnlyInside(y0, y1);
            this.recycle(b);
        });
    }

    @Override
    public void applyOnlyInside(GrayU8 mask) {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyOnlyInside(y0, y1, mask);
            this.recycle(b);
        });
    }

    private int getNumberOfBands() {
        return ((ImageInterleaved)this.srcImg).numBands;
    }

    private class BlockDistort {
        Point2D_F32 distorted = new Point2D_F32();
        PixelTransform<Point2D_F32> dstToSrc;
        InterpolatePixelMB<Input> interp;
        float[] values;

        private BlockDistort() {
            this.interp = ((InterpolatePixelMB)ImageDistortBasic_IL_MT.this.interp).copy();
            this.values = new float[ImageDistortBasic_IL_MT.this.getNumberOfBands()];
        }

        public void init() {
            this.dstToSrc = ImageDistortBasic_IL_MT.this.dstToSrc.copyConcurrent();
            this.interp.setImage((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg);
        }

        void applyAll(int y0, int y1) {
            this.init();
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).startIndex + ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).stride * y + ImageDistortBasic_IL_MT.this.x0 * ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                int x = ImageDistortBasic_IL_MT.this.x0;
                while (x < ImageDistortBasic_IL_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    this.interp.get(this.distorted.x, this.distorted.y, this.values);
                    ImageDistortBasic_IL_MT.this.assigner.assign(indexDst, this.values);
                    ++x;
                    indexDst += ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                }
            }
        }

        void applyAll(int y0, int y1, GrayU8 mask) {
            this.init();
            float maxWidth = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg).getWidth() - 1;
            float maxHeight = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg).getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).startIndex + ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).stride * y + ImageDistortBasic_IL_MT.this.x0 * ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                int indexMsk = mask.startIndex + mask.stride * y + ImageDistortBasic_IL_MT.this.x0;
                int x = ImageDistortBasic_IL_MT.this.x0;
                while (x < ImageDistortBasic_IL_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    this.interp.get(this.distorted.x, this.distorted.y, this.values);
                    ImageDistortBasic_IL_MT.this.assigner.assign(indexDst, this.values);
                    mask.data[indexMsk] = this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight ? (byte)1 : 0;
                    ++x;
                    indexDst += ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                    ++indexMsk;
                }
            }
        }

        void applyOnlyInside(int y0, int y1) {
            this.init();
            float maxWidth = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg).getWidth() - 1;
            float maxHeight = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg).getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).startIndex + ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).stride * y + ImageDistortBasic_IL_MT.this.x0 * ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                int x = ImageDistortBasic_IL_MT.this.x0;
                while (x < ImageDistortBasic_IL_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                        this.interp.get(this.distorted.x, this.distorted.y, this.values);
                        ImageDistortBasic_IL_MT.this.assigner.assign(indexDst, this.values);
                    }
                    ++x;
                    indexDst += ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                }
            }
        }

        void applyOnlyInside(int y0, int y1, GrayU8 mask) {
            this.init();
            float maxWidth = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg).getWidth() - 1;
            float maxHeight = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.srcImg).getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).startIndex + ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).stride * y + ImageDistortBasic_IL_MT.this.x0 * ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                int indexMsk = mask.startIndex + mask.stride * y + ImageDistortBasic_IL_MT.this.x0;
                int x = ImageDistortBasic_IL_MT.this.x0;
                while (x < ImageDistortBasic_IL_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                        this.interp.get(this.distorted.x, this.distorted.y, this.values);
                        ImageDistortBasic_IL_MT.this.assigner.assign(indexDst, this.values);
                        mask.data[indexMsk] = 1;
                    } else {
                        mask.data[indexMsk] = 0;
                    }
                    ++x;
                    indexDst += ((ImageInterleaved)ImageDistortBasic_IL_MT.this.dstImg).numBands;
                    ++indexMsk;
                }
            }
        }
    }
}

