/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background;

import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageGray;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.RArray2D_F32;
import boofcv.struct.image.ImageType;

public class BackgroundGmmCommon {
    public RArray2D_F32 model = new RArray2D_F32(1, 1);
    public int imageWidth;
    public int imageHeight;
    public int numBands;
    public int modelStride;
    public int gaussianStride;
    public float learningRate;
    public float decay;
    public int maxGaussians;
    public float maxDistance = 9.0f;
    public float significantWeight;
    public float initialVariance = 100.0f;
    public int unknownValue = 0;
    public GImageMultiBand inputWrapperMB;
    public float[] inputPixel;
    public GImageGray inputWrapperG;

    public BackgroundGmmCommon(float learningPeriod, float decayCoef, int maxGaussians, ImageType imageType) {
        if (learningPeriod <= 0.0f) {
            throw new IllegalArgumentException("Must be greater than zero");
        }
        if (maxGaussians >= 256 || maxGaussians <= 0) {
            throw new IllegalArgumentException("Maximum number of gaussians per pixel is 255");
        }
        this.setLearningPeriod(learningPeriod);
        this.decay = decayCoef;
        this.maxGaussians = maxGaussians;
        this.significantWeight = Math.min(0.2f, 100.0f * this.learningRate);
        switch (imageType.getFamily()) {
            case GRAY: {
                this.inputWrapperG = FactoryGImageGray.create(imageType.getImageClass());
                break;
            }
            default: {
                this.inputWrapperMB = FactoryGImageMultiBand.create(imageType);
                this.inputPixel = new float[imageType.numBands];
            }
        }
        this.numBands = imageType.numBands;
        this.gaussianStride = 2 + this.numBands;
        this.modelStride = maxGaussians * this.gaussianStride;
    }

    public int updateMixture(float[] pixelValue, float[] dataRow, int modelIndex) {
        float variance;
        int index = modelIndex;
        float bestDistance = this.maxDistance * (float)this.numBands;
        int bestIndex = -1;
        int ng = 0;
        while (ng < this.maxGaussians && !((variance = dataRow[index + 1]) <= 0.0f)) {
            float mahalanobis = 0.0f;
            for (int i = 0; i < this.numBands; ++i) {
                float mean = dataRow[index + 2 + i];
                float delta = pixelValue[i] - mean;
                mahalanobis += delta * delta / variance;
            }
            if (mahalanobis < bestDistance) {
                bestDistance = mahalanobis;
                bestIndex = index;
            }
            ++ng;
            index += this.gaussianStride;
        }
        if (bestIndex != -1) {
            float weight = dataRow[bestIndex];
            float variance2 = dataRow[bestIndex + 1];
            weight += this.learningRate * (1.0f - weight);
            dataRow[bestIndex] = 1.0f;
            float sumDeltaSq = 0.0f;
            for (int i = 0; i < this.numBands; ++i) {
                float mean = dataRow[bestIndex + 2 + i];
                float delta = pixelValue[i] - mean;
                dataRow[bestIndex + 2 + i] = mean + delta * this.learningRate / weight;
                sumDeltaSq += delta * delta;
            }
            dataRow[bestIndex + 1] = variance2 + this.learningRate / weight * ((sumDeltaSq /= (float)this.numBands) * 1.2f - variance2);
            this.updateWeightAndPrune(dataRow, modelIndex, ng, bestIndex, weight);
            return weight >= this.significantWeight ? 0 : 1;
        }
        if (ng < this.maxGaussians) {
            bestIndex = modelIndex + ng * this.gaussianStride;
            dataRow[bestIndex] = 1.0f;
            dataRow[bestIndex + 1] = this.initialVariance;
            for (int i = 0; i < this.numBands; ++i) {
                dataRow[bestIndex + 2 + i] = pixelValue[i];
            }
            if (ng == 0) {
                return this.unknownValue;
            }
            this.updateWeightAndPrune(dataRow, modelIndex, ng + 1, bestIndex, this.learningRate);
            return 1;
        }
        return 1;
    }

    public void updateWeightAndPrune(float[] dataRow, int modelIndex, int ng, int bestIndex, float bestWeight) {
        int index = modelIndex;
        float weightTotal = 0.0f;
        int i = 0;
        while (i < ng) {
            float weight = dataRow[index];
            if ((weight -= this.learningRate * (weight + this.decay)) <= 0.0f) {
                int indexLast = modelIndex + (ng - 1) * this.gaussianStride;
                for (int j = 0; j < this.gaussianStride; ++j) {
                    dataRow[index + j] = dataRow[indexLast + j];
                }
                if (indexLast == bestIndex) {
                    bestIndex = index;
                }
                dataRow[indexLast + 1] = 0.0f;
                --ng;
                continue;
            }
            dataRow[index] = weight;
            weightTotal += weight;
            index += this.gaussianStride;
            ++i;
        }
        if (bestIndex != -1) {
            weightTotal -= dataRow[bestIndex];
            weightTotal += bestWeight;
            dataRow[bestIndex] = bestWeight;
        }
        index = modelIndex;
        i = 0;
        while (i < ng) {
            int n = index;
            dataRow[n] = dataRow[n] / weightTotal;
            ++i;
            index += this.gaussianStride;
        }
    }

    public int updateMixture(float pixelValue, float[] dataRow, int modelIndex) {
        int index = modelIndex;
        float bestDistance = this.maxDistance;
        int bestIndex = -1;
        int ng = 0;
        while (ng < this.maxGaussians) {
            float variance = dataRow[index + 1];
            float mean = dataRow[index + 2];
            if (variance <= 0.0f) break;
            float delta = pixelValue - mean;
            float mahalanobis = delta * delta / variance;
            if (mahalanobis < bestDistance) {
                bestDistance = mahalanobis;
                bestIndex = index;
            }
            ++ng;
            index += 3;
        }
        if (bestDistance != this.maxDistance) {
            float weight = dataRow[bestIndex];
            float variance = dataRow[bestIndex + 1];
            float mean = dataRow[bestIndex + 2];
            float delta = pixelValue - mean;
            weight += this.learningRate * (1.0f - weight);
            dataRow[bestIndex] = 1.0f;
            dataRow[bestIndex + 1] = variance + this.learningRate / weight * (delta * delta * 1.2f - variance);
            dataRow[bestIndex + 2] = mean + delta * this.learningRate / weight;
            this.updateWeightAndPrune(dataRow, modelIndex, ng, bestIndex, weight);
            return weight >= this.significantWeight ? 0 : 1;
        }
        if (ng < this.maxGaussians) {
            bestIndex = modelIndex + ng * 3;
            dataRow[bestIndex] = 1.0f;
            dataRow[bestIndex + 1] = this.initialVariance;
            dataRow[bestIndex + 2] = pixelValue;
            if (ng == 0) {
                return this.unknownValue;
            }
            this.updateWeightAndPrune(dataRow, modelIndex, ng + 1, bestIndex, this.learningRate);
            return 1;
        }
        return 1;
    }

    public int checkBackground(float[] pixelValue, float[] dataRow, int modelIndex) {
        float variance;
        int index = modelIndex;
        float bestDistance = this.maxDistance * (float)this.numBands;
        float bestWeight = 0.0f;
        int ng = 0;
        while (ng < this.maxGaussians && !((variance = dataRow[index + 1]) <= 0.0f)) {
            float mahalanobis = 0.0f;
            for (int i = 0; i < this.numBands; ++i) {
                float mean = dataRow[index + 2 + i];
                float delta = pixelValue[i] - mean;
                mahalanobis += delta * delta / variance;
            }
            if (mahalanobis < bestDistance) {
                bestDistance = mahalanobis;
                bestWeight = dataRow[index];
            }
            ++ng;
            index += this.gaussianStride;
        }
        if (ng == 0) {
            return this.unknownValue;
        }
        return bestWeight >= this.significantWeight ? 0 : 1;
    }

    public int checkBackground(float pixelValue, float[] dataRow, int modelIndex) {
        int index = modelIndex;
        float bestDistance = this.maxDistance;
        float bestWeight = 0.0f;
        int ng = 0;
        while (ng < this.maxGaussians) {
            float variance = dataRow[index + 1];
            float mean = dataRow[index + 2];
            if (variance <= 0.0f) break;
            float delta = pixelValue - mean;
            float mahalanobis = delta * delta / variance;
            if (mahalanobis < bestDistance) {
                bestDistance = mahalanobis;
                bestWeight = dataRow[index];
            }
            ++ng;
            index += 3;
        }
        if (ng == 0) {
            return this.unknownValue;
        }
        return bestWeight >= this.significantWeight ? 0 : 1;
    }

    public void setLearningPeriod(float period) {
        this.learningRate = 1.0f / period;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public float getSignificantWeight() {
        return this.significantWeight;
    }

    public void setSignificantWeight(float significantWeight) {
        this.significantWeight = significantWeight;
    }

    public float getInitialVariance() {
        return this.initialVariance;
    }

    public void setInitialVariance(float initialVariance) {
        this.initialVariance = initialVariance;
    }
}

