/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.triangulate;

import boofcv.abst.geo.RefineTriangulateMetricH;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.triangulate.ResidualsTriangulateProjective;
import boofcv.misc.BoofMiscOps;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;

public class TriangulateRefineMetricHgLS
implements RefineTriangulateMetricH {
    final ResidualsTriangulateProjective func = new ResidualsTriangulateProjective();
    final UnconstrainedLeastSquares<DMatrixRMaj> minimizer;
    final DogArray<DMatrixRMaj> cameras = new DogArray<DMatrixRMaj>(() -> new DMatrixRMaj(3, 4));
    final double[] param = new double[4];
    int maxIterations;
    double convergenceTol;

    public TriangulateRefineMetricHgLS(double convergenceTol, int maxIterations) {
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, false);
        BoofMiscOps.checkEq(4, this.func.getNumOfInputsN());
    }

    @Override
    public boolean process(List<Point2D_F64> observations, List<Se3_F64> listWorldToView, Point4D_F64 worldPt, Point4D_F64 refinedPt) {
        int i;
        this.cameras.resize(listWorldToView.size());
        for (i = 0; i < this.cameras.size; ++i) {
            PerspectiveOps.convertToMatrix(listWorldToView.get(i), (DMatrixRMaj)this.cameras.get(i));
        }
        this.func.setObservations(observations, this.cameras.toList());
        this.minimizer.setFunction(this.func, null);
        this.param[0] = worldPt.x;
        this.param[1] = worldPt.y;
        this.param[2] = worldPt.z;
        this.param[3] = worldPt.w;
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)observations.size());
        for (i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        double[] found = this.minimizer.getParameters();
        refinedPt.x = found[0];
        refinedPt.y = found[1];
        refinedPt.z = found[2];
        refinedPt.w = found[3];
        return true;
    }

    public ResidualsTriangulateProjective getFunc() {
        return this.func;
    }

    public UnconstrainedLeastSquares<DMatrixRMaj> getMinimizer() {
        return this.minimizer;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getConvergenceTol() {
        return this.convergenceTol;
    }

    public void setConvergenceTol(double convergenceTol) {
        this.convergenceTol = convergenceTol;
    }
}

