/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.circle.DetectCircleRegularGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.fiducial.calib.circle.KeyPointsCircleRegularGrid;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class CalibrationDetectorCircleRegularGrid
implements DetectorFiducialCalibration {
    private DetectCircleRegularGrid<GrayF32> detector;
    private KeyPointsCircleRegularGrid keypoint = new KeyPointsCircleRegularGrid();
    private List<Point2D_F64> layout;
    private CalibrationObservation results;
    double spaceToDiameter;

    public CalibrationDetectorCircleRegularGrid(ConfigCircleRegularGrid configDet, ConfigGridDimen configGrid) {
        InputToBinary<GrayF32> inputToBinary = FactoryThresholdBinary.threshold(configDet.thresholding, GrayF32.class);
        BinaryEllipseDetector<GrayF32> ellipseDetector = FactoryShapeDetector.ellipse(configDet.ellipse, GrayF32.class);
        this.spaceToDiameter = configGrid.shapeDistance / configGrid.shapeSize;
        double spaceToRadius = 2.0 * this.spaceToDiameter;
        EllipsesIntoClusters e2c = new EllipsesIntoClusters(spaceToRadius * 1.5, configDet.ellipseSizeSimilarity, configDet.edgeIntensitySimilarityTolerance);
        this.detector = new DetectCircleRegularGrid<GrayF32>(configGrid.numRows, configGrid.numCols, inputToBinary, ellipseDetector, e2c);
        this.layout = CalibrationDetectorCircleRegularGrid.createLayout(this.detector.getRows(), this.detector.getColumns(), configGrid.shapeDistance, configGrid.shapeSize);
    }

    @Override
    public boolean process(GrayF32 input) {
        this.results = new CalibrationObservation(input.width, input.height);
        this.detector.process(input);
        List<EllipseClustersIntoGrid.Grid> grids = this.detector.getGrids();
        if (grids.size() != 1) {
            return false;
        }
        if (!this.keypoint.process(grids.get(0))) {
            return false;
        }
        DogArray<PointIndex2D_F64> foundPixels = this.keypoint.getKeyPoints();
        for (int i = 0; i < foundPixels.size; ++i) {
            this.results.add((Point2D_F64)((PointIndex2D_F64)foundPixels.get((int)i)).p, i);
        }
        return true;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        return this.results;
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.layout;
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion == null) {
            this.detector.getEllipseDetector().setLensDistortion(null, null);
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
            this.detector.getEllipseDetector().setLensDistortion(distToUndist, undistToDist);
        }
    }

    public static List<Point2D_F64> createLayout(int numRows, int numCols, double centerDistance, double diameter) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        double radius = diameter / 2.0;
        double width = (double)(numCols - 1) * centerDistance;
        double height = (double)(numRows - 1) * centerDistance;
        for (int row = 0; row < numRows; ++row) {
            double y = (double)(numRows - row - 1) * centerDistance - height / 2.0;
            for (int col = 0; col < numCols; ++col) {
                double x = (double)col * centerDistance - width / 2.0;
                ret.add(new Point2D_F64(x, y - radius));
                ret.add(new Point2D_F64(x + radius, y));
                ret.add(new Point2D_F64(x, y + radius));
                ret.add(new Point2D_F64(x - radius, y));
            }
        }
        return ret;
    }

    public DetectCircleRegularGrid<GrayF32> getDetector() {
        return this.detector;
    }

    public KeyPointsCircleRegularGrid getKeypointFinder() {
        return this.keypoint;
    }

    public int getRows() {
        return this.detector.getRows();
    }

    public int getColumns() {
        return this.detector.getColumns();
    }

    public double getSpaceToDiameter() {
        return this.spaceToDiameter;
    }
}

