/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DescribeSurf_RadiusAngle<T extends ImageGray<T>, II extends ImageGray<II>>
implements DescribePointRadiusAngle<T, TupleDesc_F64> {
    DescribePointSurf<II> surf;
    II ii;
    ImageType<T> imageType;
    final double canonicalRadius;

    public DescribeSurf_RadiusAngle(DescribePointSurf<II> surf, Class<T> imageType) {
        this.surf = surf;
        this.imageType = ImageType.single(imageType);
        this.canonicalRadius = (double)surf.getCanonicalWidth() / 2.0;
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.surf.getDescriptionLength());
    }

    @Override
    public void setImage(T image) {
        if (this.ii != null) {
            ((ImageGray)this.ii).reshape(((ImageGray)image).width, ((ImageGray)image).height);
        }
        this.ii = GIntegralImageOps.transform(image, this.ii);
        this.surf.setImage(this.ii);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, TupleDesc_F64 storage) {
        double scale = radius / this.canonicalRadius;
        this.surf.describe(x, y, orientation, scale, true, storage);
        return true;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public boolean isOriented() {
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.surf.getCanonicalWidth();
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

