/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardOCR;
import boardsync.BoardPosition;
import boardsync.BoardSyncTool;
import boardsync.IntDocument;
import boardsync.LineDetection;
import boardsync.ScreenShotDialog;
import boardsync.SettingsFrame;
import boardsync.Utils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ToolFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public boolean isKeepSyncing = false;
    public boolean keepSyncThreadInterrupted = false;
    private JPanel dialogPane = new JPanel();
    private JPanel northPane = new JPanel();
    private JPanel centerPane = new JPanel();
    private JPanel southPane = new JPanel();
    private final JButton btnSelectBoard = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnSelectBoard"));
    private final JButton btnSelectRow1 = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnSelectRow1"));
    private final JButton btnHelp = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnHelp"));
    private final JButton btnKeepSync;
    private final JButton btnOneTimeSync;
    private final JButton btnSettings;
    public final JCheckBox chkBothSync;
    private final JCheckBox chkAutoPlay;
    private final JRadioButton rdoPlayBlack;
    private final JRadioButton rdoPlayWhite;
    public final JTextField txtTotalVisits;
    private final JLabel lblTotalVisits;
    public final JTextField txtTotalTime;
    private final JLabel lblTotalTime;
    private final JPanel boardPane;
    private final JLabel lblBoard;
    private final JTextField txtBoardWidth;
    private final JLabel lblTimes;
    private final JTextField txtBoardHeight;
    private final JButton btnPass;
    private final JButton btnClear;
    private final JButton btnToggleAnalyze;
    private JFrame thisFrame;
    private final JLabel lblFirstVisits;
    public final JTextField txtFirstVisits;

    public ToolFrame() {
        this.btnKeepSync = new JButton(String.valueOf(BoardSyncTool.resourceBundle.getString("ToolFrame.btnKeepSync")) + "(" + BoardSyncTool.config.keepSyncIntervalMillseconds + "ms)");
        this.btnOneTimeSync = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnOneTimeSync"));
        this.btnSettings = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnSettings"));
        this.chkBothSync = new JCheckBox(BoardSyncTool.resourceBundle.getString("ToolFrame.chkBothSync"));
        this.chkAutoPlay = new JCheckBox(BoardSyncTool.resourceBundle.getString("ToolFrame.chkAutoPlay"));
        this.rdoPlayBlack = new JRadioButton(BoardSyncTool.resourceBundle.getString("ToolFrame.rdoPlayBlack"));
        this.rdoPlayWhite = new JRadioButton(BoardSyncTool.resourceBundle.getString("ToolFrame.rdoPlayWhite"));
        this.txtTotalVisits = new JTextField();
        this.lblTotalVisits = new JLabel(BoardSyncTool.resourceBundle.getString("ToolFrame.lblTotalVisits"));
        this.txtTotalTime = new JTextField();
        this.lblTotalTime = new JLabel(BoardSyncTool.resourceBundle.getString("ToolFrame.lblTotalTime"));
        this.boardPane = new JPanel();
        this.lblBoard = new JLabel(BoardSyncTool.resourceBundle.getString("ToolFrame.lblBoard"));
        this.txtBoardWidth = new JTextField();
        this.lblTimes = new JLabel("X");
        this.txtBoardHeight = new JTextField();
        this.btnPass = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnPass"));
        this.btnClear = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnClear"));
        this.btnToggleAnalyze = new JButton(BoardSyncTool.resourceBundle.getString("ToolFrame.btnToggleAnalyze"));
        this.thisFrame = this;
        this.lblFirstVisits = new JLabel(BoardSyncTool.resourceBundle.getString("ToolFrame.lblFirstVisits"));
        this.txtFirstVisits = new JTextField();
        this.txtFirstVisits.setColumns(6);
        this.txtBoardHeight.setColumns(2);
        this.txtBoardWidth.setColumns(2);
        this.txtTotalTime.setColumns(6);
        this.txtTotalVisits.setColumns(6);
        final ButtonGroup rdoGroup = new ButtonGroup();
        rdoGroup.add(this.rdoPlayBlack);
        rdoGroup.add(this.rdoPlayWhite);
        this.chkBothSync.setSelected(BoardSyncTool.config.lastTimeBothSync);
        if (this.chkBothSync.isSelected()) {
            Utils.send("bothSync");
            this.rdoPlayBlack.setEnabled(false);
            this.rdoPlayWhite.setEnabled(false);
            this.txtFirstVisits.setEnabled(false);
            this.txtTotalTime.setEnabled(false);
            this.txtTotalVisits.setEnabled(false);
        } else {
            Utils.send("nobothSync");
            this.chkAutoPlay.setEnabled(false);
            this.rdoPlayBlack.setEnabled(false);
            this.rdoPlayWhite.setEnabled(false);
            this.txtFirstVisits.setEnabled(false);
            this.txtTotalTime.setEnabled(false);
            this.txtTotalVisits.setEnabled(false);
        }
        this.chkBothSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ToolFrame.this.chkBothSync.isSelected()) {
                    ToolFrame.this.chkAutoPlay.setEnabled(true);
                    Utils.send("bothSync");
                } else {
                    Utils.send("nobothSync");
                    rdoGroup.remove(ToolFrame.this.rdoPlayBlack);
                    rdoGroup.remove(ToolFrame.this.rdoPlayWhite);
                    ToolFrame.this.chkAutoPlay.setEnabled(false);
                    ToolFrame.this.rdoPlayBlack.setSelected(false);
                    ToolFrame.this.rdoPlayWhite.setSelected(false);
                    ToolFrame.this.chkAutoPlay.setSelected(false);
                    ToolFrame.this.rdoPlayBlack.setEnabled(false);
                    ToolFrame.this.rdoPlayWhite.setEnabled(false);
                    ToolFrame.this.txtFirstVisits.setEnabled(false);
                    ToolFrame.this.txtTotalTime.setEnabled(false);
                    ToolFrame.this.txtTotalVisits.setEnabled(false);
                    rdoGroup.add(ToolFrame.this.rdoPlayBlack);
                    rdoGroup.add(ToolFrame.this.rdoPlayWhite);
                }
            }
        });
        this.chkAutoPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ToolFrame.this.chkAutoPlay.isSelected()) {
                    ToolFrame.this.rdoPlayBlack.setEnabled(true);
                    ToolFrame.this.rdoPlayWhite.setEnabled(true);
                    ToolFrame.this.txtFirstVisits.setEnabled(true);
                    ToolFrame.this.txtTotalTime.setEnabled(true);
                    ToolFrame.this.txtTotalVisits.setEnabled(true);
                } else {
                    rdoGroup.remove(ToolFrame.this.rdoPlayBlack);
                    rdoGroup.remove(ToolFrame.this.rdoPlayWhite);
                    ToolFrame.this.rdoPlayBlack.setSelected(false);
                    ToolFrame.this.rdoPlayWhite.setSelected(false);
                    ToolFrame.this.rdoPlayBlack.setEnabled(false);
                    ToolFrame.this.rdoPlayWhite.setEnabled(false);
                    ToolFrame.this.txtFirstVisits.setEnabled(false);
                    ToolFrame.this.txtTotalTime.setEnabled(false);
                    ToolFrame.this.txtTotalVisits.setEnabled(false);
                    rdoGroup.add(ToolFrame.this.rdoPlayBlack);
                    rdoGroup.add(ToolFrame.this.rdoPlayWhite);
                }
            }
        });
        this.txtBoardHeight.setDocument(new IntDocument());
        this.txtBoardWidth.setDocument(new IntDocument());
        this.txtFirstVisits.setDocument(new IntDocument());
        this.txtTotalTime.setDocument(new IntDocument());
        this.txtTotalVisits.setDocument(new IntDocument());
        Document dtTxtBoardHeight = this.txtBoardHeight.getDocument();
        dtTxtBoardHeight.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ToolFrame.this.updateBoardHeight();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ToolFrame.this.updateBoardHeight();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ToolFrame.this.updateBoardHeight();
            }
        });
        Document dtTxtBoardWidth = this.txtBoardWidth.getDocument();
        dtTxtBoardWidth.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ToolFrame.this.updateBoardWidth();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ToolFrame.this.updateBoardWidth();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ToolFrame.this.updateBoardWidth();
            }
        });
        Document dtTxtFirstVisits = this.txtFirstVisits.getDocument();
        dtTxtFirstVisits.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }
        });
        Document dtTxtTotalTime = this.txtTotalTime.getDocument();
        dtTxtTotalTime.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }
        });
        Document DTtxtTotalVisits = this.txtTotalVisits.getDocument();
        DTtxtTotalVisits.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }
        });
        this.rdoPlayBlack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }
        });
        this.rdoPlayWhite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolFrame.this.sendAutoPlayInfo();
            }
        });
        this.loadValue();
        this.initComponents();
        this.sendPlayPonder();
        this.setTitle(BoardSyncTool.resourceBundle.getString("ToolFrame.title"));
        try {
            this.setIconImage(ImageIO.read(ToolFrame.class.getResourceAsStream("/assets/logo.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setLocation(BoardSyncTool.config.locationX, BoardSyncTool.config.locationY);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BoardSyncTool.shutdown();
            }
        });
    }

    private void loadValue() {
        this.txtBoardWidth.setText(String.valueOf(BoardSyncTool.boardWidth));
        this.txtBoardHeight.setText(String.valueOf(BoardSyncTool.boardHeight));
        if (BoardSyncTool.config.lastTimeTotalTime > 0) {
            this.txtTotalTime.setText(String.valueOf(BoardSyncTool.config.lastTimeTotalTime));
        }
        if (BoardSyncTool.config.lastTimeTotalVisits > 0) {
            this.txtTotalVisits.setText(String.valueOf(BoardSyncTool.config.lastTimeTotalVisits));
        }
        if (BoardSyncTool.config.lastTimeFirstVisits > 0) {
            this.txtFirstVisits.setText(String.valueOf(BoardSyncTool.config.lastTimeFirstVisits));
        }
    }

    private void updateBoardHeight() {
        try {
            BoardSyncTool.boardHeight = Integer.parseInt(this.txtBoardHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void updateBoardWidth() {
        try {
            BoardSyncTool.boardWidth = Integer.parseInt(this.txtBoardWidth.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.initDialogPane(contentPane);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void initDialogPane(Container contentPane) {
        this.dialogPane.setBorder(new EmptyBorder(3, 5, 3, 5));
        this.dialogPane.setLayout(new BorderLayout());
        this.initNorth();
        this.initCenter();
        this.initSouth();
        contentPane.add((Component)this.dialogPane, "Center");
    }

    private void initSouth() {
        this.dialogPane.add((Component)this.southPane, "South");
        this.southPane.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.southPane.setLayout(new GridLayout(1, 3, 0, 0));
        this.btnToggleAnalyze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.send("noponder");
            }
        });
        this.southPane.add(this.btnToggleAnalyze);
        this.btnPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.send("pass");
            }
        });
        this.southPane.add(this.btnPass);
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.send("clear");
            }
        });
        this.southPane.add(this.btnClear);
    }

    private void initNorth() {
        this.dialogPane.add((Component)this.northPane, "North");
        this.northPane.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.northPane.setLayout(new GridLayout(2, 4, 0, 0));
        this.btnSelectBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolFrame.this.selectBoard(false);
                    }
                });
            }
        });
        this.northPane.add(this.btnSelectBoard);
        this.btnSelectRow1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolFrame.this.selectBoard(true);
                    }
                });
            }
        });
        this.northPane.add(this.btnSelectRow1);
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().open(new File("readboard_java" + File.separator + BoardSyncTool.resourceBundle.getString("Help.helpFileName")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.northPane.add(this.btnHelp);
        this.btnKeepSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ToolFrame.this.isKeepSyncing) {
                    ToolFrame.this.stopKeepSync();
                } else {
                    ToolFrame.this.startKeepSync();
                }
            }
        });
        this.northPane.add(this.btnKeepSync);
        this.btnOneTimeSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BoardOCR boardOCR = new BoardOCR();
                try {
                    if (BoardSyncTool.isWindows) {
                        ToolFrame.this.setExtendedState(1);
                    }
                    if (BoardSyncTool.boardPosition == null) {
                        Utils.showMssage(BoardSyncTool.toolFrame, BoardSyncTool.resourceBundle.getString("ToolFrame.noBoard"), BoardSyncTool.resourceBundle.getString("ToolFrame.information"));
                        return;
                    }
                    Utils.send("start " + BoardSyncTool.boardWidth + " " + BoardSyncTool.boardHeight + " ");
                    boardOCR.oneTimeSync();
                    if (BoardSyncTool.isWindows) {
                        ToolFrame.this.setExtendedState(0);
                    }
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
            }
        });
        this.northPane.add(this.btnOneTimeSync);
        this.btnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsFrame settingsFrame = new SettingsFrame((Window)ToolFrame.this.thisFrame);
                settingsFrame.setVisible(true);
            }
        });
        this.northPane.add(this.btnSettings);
    }

    private void initCenter() {
        GridBagLayout gbl_buttonBar = new GridBagLayout();
        this.centerPane.setLayout(gbl_buttonBar);
        this.centerPane.setBorder(BorderFactory.createEtchedBorder());
        this.dialogPane.add((Component)this.centerPane, "Center");
        GridBagConstraints gbc_chkBothSync = new GridBagConstraints();
        gbc_chkBothSync.anchor = 13;
        gbc_chkBothSync.insets = new Insets(2, 0, 5, 5);
        gbc_chkBothSync.gridx = 0;
        gbc_chkBothSync.gridy = 0;
        this.centerPane.add((Component)this.chkBothSync, gbc_chkBothSync);
        GridBagConstraints gbc_rdoPlayBlack = new GridBagConstraints();
        gbc_rdoPlayBlack.fill = 2;
        gbc_rdoPlayBlack.insets = new Insets(2, 0, 5, 5);
        gbc_rdoPlayBlack.gridx = 1;
        gbc_rdoPlayBlack.gridy = 0;
        this.centerPane.add((Component)this.rdoPlayBlack, gbc_rdoPlayBlack);
        GridBagConstraints gbc_lblTotalTime = new GridBagConstraints();
        gbc_lblTotalTime.anchor = 13;
        gbc_lblTotalTime.insets = new Insets(2, 0, 5, 5);
        gbc_lblTotalTime.gridx = 2;
        gbc_lblTotalTime.gridy = 0;
        this.centerPane.add((Component)this.lblTotalTime, gbc_lblTotalTime);
        GridBagConstraints gbc_txtTotalTime = new GridBagConstraints();
        gbc_txtTotalTime.fill = 2;
        gbc_txtTotalTime.insets = new Insets(2, 0, 5, 5);
        gbc_txtTotalTime.gridx = 3;
        gbc_txtTotalTime.gridy = 0;
        this.centerPane.add((Component)this.txtTotalTime, gbc_txtTotalTime);
        GridBagConstraints gbc_lblBoard = new GridBagConstraints();
        gbc_lblBoard.anchor = 13;
        gbc_lblBoard.insets = new Insets(0, 0, 5, 5);
        gbc_lblBoard.gridx = 4;
        gbc_lblBoard.gridy = 0;
        this.centerPane.add((Component)this.lblBoard, gbc_lblBoard);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 2;
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.gridx = 5;
        gbc_panel.gridy = 0;
        this.boardPane.add(this.txtBoardWidth);
        this.boardPane.add(this.lblTimes);
        this.boardPane.add(this.txtBoardHeight);
        this.centerPane.add((Component)this.boardPane, gbc_panel);
        this.boardPane.setLayout(new FlowLayout(1, 3, 3));
        GridBagConstraints gbc_chkAutoPlay = new GridBagConstraints();
        gbc_chkAutoPlay.anchor = 13;
        gbc_chkAutoPlay.insets = new Insets(0, 0, 2, 5);
        gbc_chkAutoPlay.gridx = 0;
        gbc_chkAutoPlay.gridy = 1;
        this.centerPane.add((Component)this.chkAutoPlay, gbc_chkAutoPlay);
        GridBagConstraints gbc_rdoPlayWhite = new GridBagConstraints();
        gbc_rdoPlayWhite.fill = 2;
        gbc_rdoPlayWhite.insets = new Insets(0, 0, 2, 5);
        gbc_rdoPlayWhite.gridx = 1;
        gbc_rdoPlayWhite.gridy = 1;
        this.centerPane.add((Component)this.rdoPlayWhite, gbc_rdoPlayWhite);
        GridBagConstraints gbc_lblTotalVisits = new GridBagConstraints();
        gbc_lblTotalVisits.anchor = 13;
        gbc_lblTotalVisits.insets = new Insets(0, 0, 2, 5);
        gbc_lblTotalVisits.gridx = 2;
        gbc_lblTotalVisits.gridy = 1;
        this.centerPane.add((Component)this.lblTotalVisits, gbc_lblTotalVisits);
        GridBagConstraints gbc_txtTotalVisits = new GridBagConstraints();
        gbc_txtTotalVisits.fill = 2;
        gbc_txtTotalVisits.insets = new Insets(0, 0, 2, 5);
        gbc_txtTotalVisits.gridx = 3;
        gbc_txtTotalVisits.gridy = 1;
        this.centerPane.add((Component)this.txtTotalVisits, gbc_txtTotalVisits);
        GridBagConstraints gbc_lblFirstVisits = new GridBagConstraints();
        gbc_lblFirstVisits.insets = new Insets(0, 0, 0, 5);
        gbc_lblFirstVisits.anchor = 13;
        gbc_lblFirstVisits.gridx = 4;
        gbc_lblFirstVisits.gridy = 1;
        this.centerPane.add((Component)this.lblFirstVisits, gbc_lblFirstVisits);
        GridBagConstraints gbc_txtFirstVisits = new GridBagConstraints();
        gbc_txtFirstVisits.insets = new Insets(0, 0, 0, 5);
        gbc_txtFirstVisits.fill = 2;
        gbc_txtFirstVisits.gridx = 5;
        gbc_txtFirstVisits.gridy = 1;
        this.centerPane.add((Component)this.txtFirstVisits, gbc_txtFirstVisits);
    }

    private void sendAutoPlayInfo() {
        if (this.isKeepSyncing && !this.keepSyncThreadInterrupted && (this.rdoPlayBlack.isSelected() || this.rdoPlayWhite.isSelected())) {
            Utils.send("play>" + (this.rdoPlayBlack.isSelected() ? "black" : "white") + ">" + (this.txtTotalTime.getText().trim().equals("") ? "0" : this.txtTotalTime.getText().trim()) + " " + (this.txtTotalVisits.getText().trim().equals("") ? "0" : this.txtTotalVisits.getText().trim()) + " " + (this.txtFirstVisits.getText().trim().equals("") ? "0" : this.txtFirstVisits.getText().trim()));
        }
    }

    private void setKeepSyncStatus(boolean isSyncing) {
        if (isSyncing) {
            if (BoardSyncTool.config.autoMinimize) {
                this.setExtendedState(1);
            }
            this.btnKeepSync.setText(BoardSyncTool.resourceBundle.getString("ToolFrame.stopSync"));
            this.btnSelectBoard.setEnabled(false);
            this.btnSelectRow1.setEnabled(false);
            Utils.send("sync");
            Utils.send("start " + BoardSyncTool.boardWidth + " " + BoardSyncTool.boardHeight + " ");
            this.sendAutoPlayInfo();
        } else {
            this.btnKeepSync.setText(String.valueOf(BoardSyncTool.resourceBundle.getString("ToolFrame.btnKeepSync")) + "(" + BoardSyncTool.config.keepSyncIntervalMillseconds + "ms)");
            this.btnSelectBoard.setEnabled(true);
            this.btnSelectRow1.setEnabled(true);
            Utils.send("stopsync");
        }
        this.btnKeepSync.setEnabled(true);
        this.btnKeepSync.requestFocus();
    }

    private void stopKeepSync() {
        this.btnKeepSync.setEnabled(false);
        this.keepSyncThreadInterrupted = true;
    }

    private void startKeepSync() {
        if (this.isKeepSyncing) {
            Utils.showMssage(this.thisFrame, BoardSyncTool.resourceBundle.getString("ToolFrame.stopSyncFirst"), BoardSyncTool.resourceBundle.getString("ToolFrame.information"));
            return;
        }
        if (BoardSyncTool.boardPosition == null) {
            Utils.showMssage(BoardSyncTool.toolFrame, BoardSyncTool.resourceBundle.getString("ToolFrame.noBoard"), BoardSyncTool.resourceBundle.getString("ToolFrame.information"));
            return;
        }
        this.isKeepSyncing = true;
        this.setKeepSyncStatus(true);
        new Thread(){

            @Override
            public void run() {
                BoardOCR boardOCR = new BoardOCR();
                while (!ToolFrame.this.keepSyncThreadInterrupted) {
                    try {
                        boardOCR.oneTimeSync();
                    }
                    catch (AWTException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(BoardSyncTool.config.keepSyncIntervalMillseconds);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ToolFrame.this.isKeepSyncing = false;
                ToolFrame.this.keepSyncThreadInterrupted = false;
                ToolFrame.this.setKeepSyncStatus(false);
            }
        }.start();
    }

    private void selectBoard(final boolean selectRow1) {
        BoardSyncTool.isGettingScreen = true;
        this.setExtendedState(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenShotDialog screenShotDialog = new ScreenShotDialog();
                screenShotDialog.start();
            }
        });
        new Thread(){

            @Override
            public void run() {
                while (BoardSyncTool.isGettingScreen) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ToolFrame.this.setExtendedState(0);
                if (BoardSyncTool.screenImage != null) {
                    if (selectRow1) {
                        int vGap = Math.round((float)BoardSyncTool.screenImage.getWidth() / (float)BoardSyncTool.boardWidth);
                        int hGap = Math.round((float)BoardSyncTool.screenImage.getHeight() / (float)BoardSyncTool.boardHeight);
                        BoardPosition position = new BoardPosition();
                        position.x = BoardSyncTool.screenImageStartX - (vGap + 1) / 2;
                        position.y = BoardSyncTool.screenImageStartY - (hGap + 1) / 2;
                        position.width = BoardSyncTool.screenImage.getWidth() + (vGap + 1) / 2 * 2;
                        position.height = BoardSyncTool.screenImage.getHeight() + (hGap + 1) / 2 * 2;
                        BoardSyncTool.boardPosition = position;
                    } else {
                        LineDetection lineDetection = new LineDetection();
                        BoardSyncTool.boardPosition = lineDetection.getBoardPosition(BoardSyncTool.screenImage);
                    }
                }
            }
        }.start();
    }

    public void sendPlayPonder() {
        if (BoardSyncTool.config.playPonder) {
            Utils.send("playponder on");
        } else {
            Utils.send("playponder off");
        }
    }
}

