/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardSyncTool;
import boardsync.IntDocument;
import boardsync.ToolFrame;
import boardsync.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SettingsFrame
extends JDialog {
    private static final long serialVersionUID = 3L;
    private JTextField txtBlackOffset;
    private JTextField txtBlackPercent;
    private JTextField txtWhiteOffset;
    private JTextField txtWhitePercent;
    private JTextField txtSyncInterval;
    private JTextField txtGrayOffset;
    private JCheckBox chkAutoMin;
    private JCheckBox chkVerifyPlacedMove;
    private JCheckBox chkPlayPonder;
    private JPanel contentPane = new JPanel();
    private JPanel southPane = new JPanel();
    private JPanel buttonPane = new JPanel();
    private JPanel noticePane = new JPanel();

    public SettingsFrame(Window owner) {
        super(owner);
        this.setResizable(false);
        this.setTitle(BoardSyncTool.resourceBundle.getString("SettingsFrame.title"));
        try {
            this.setIconImage(ImageIO.read(ToolFrame.class.getResourceAsStream("/assets/logo.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.getContentPane().add((Component)this.southPane, "South");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.contentPane.setLayout(gridBagLayout);
        this.contentPane.setBorder(new EmptyBorder(12, 12, 0, 12));
        this.noticePane.setBorder(new EmptyBorder(6, 12, 3, 12));
        this.southPane.setBorder(new EmptyBorder(0, 0, 3, 0));
        JLabel lblBlackOffset = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblBlackOffset"));
        GridBagConstraints gbc_lblBlackOffset = new GridBagConstraints();
        gbc_lblBlackOffset.fill = 2;
        gbc_lblBlackOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblBlackOffset.gridx = 0;
        gbc_lblBlackOffset.gridy = 0;
        this.contentPane.add((Component)lblBlackOffset, gbc_lblBlackOffset);
        this.txtBlackOffset = new JTextField();
        GridBagConstraints gbc_txtBlackOffset = new GridBagConstraints();
        gbc_txtBlackOffset.fill = 2;
        gbc_txtBlackOffset.insets = new Insets(0, 0, 5, 5);
        gbc_txtBlackOffset.gridx = 1;
        gbc_txtBlackOffset.gridy = 0;
        this.contentPane.add((Component)this.txtBlackOffset, gbc_txtBlackOffset);
        this.txtBlackOffset.setColumns(6);
        JLabel lblBlackPercent = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblBlackPercent"));
        GridBagConstraints gbc_lblBlackPercent = new GridBagConstraints();
        gbc_lblBlackPercent.fill = 2;
        gbc_lblBlackPercent.insets = new Insets(0, 0, 5, 5);
        gbc_lblBlackPercent.gridx = 2;
        gbc_lblBlackPercent.gridy = 0;
        this.contentPane.add((Component)lblBlackPercent, gbc_lblBlackPercent);
        this.txtBlackPercent = new JTextField();
        GridBagConstraints gbc_txtBlackPercent = new GridBagConstraints();
        gbc_txtBlackPercent.fill = 2;
        gbc_txtBlackPercent.insets = new Insets(0, 0, 5, 0);
        gbc_txtBlackPercent.gridx = 3;
        gbc_txtBlackPercent.gridy = 0;
        this.contentPane.add((Component)this.txtBlackPercent, gbc_txtBlackPercent);
        this.txtBlackPercent.setColumns(6);
        JLabel lblWhiteOffset = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblWhiteOffset"));
        GridBagConstraints gbc_lblWhiteOffset = new GridBagConstraints();
        gbc_lblWhiteOffset.fill = 2;
        gbc_lblWhiteOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblWhiteOffset.gridx = 0;
        gbc_lblWhiteOffset.gridy = 1;
        this.contentPane.add((Component)lblWhiteOffset, gbc_lblWhiteOffset);
        this.txtWhiteOffset = new JTextField();
        GridBagConstraints gbc_txtWhiteOffset = new GridBagConstraints();
        gbc_txtWhiteOffset.fill = 2;
        gbc_txtWhiteOffset.insets = new Insets(0, 0, 5, 5);
        gbc_txtWhiteOffset.gridx = 1;
        gbc_txtWhiteOffset.gridy = 1;
        this.contentPane.add((Component)this.txtWhiteOffset, gbc_txtWhiteOffset);
        this.txtWhiteOffset.setColumns(6);
        JLabel lblWhitePercent = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblWhitePercent"));
        GridBagConstraints gbc_lblWhitePercent = new GridBagConstraints();
        gbc_lblWhitePercent.fill = 2;
        gbc_lblWhitePercent.insets = new Insets(0, 0, 5, 5);
        gbc_lblWhitePercent.gridx = 2;
        gbc_lblWhitePercent.gridy = 1;
        this.contentPane.add((Component)lblWhitePercent, gbc_lblWhitePercent);
        this.txtWhitePercent = new JTextField();
        GridBagConstraints gbc_txtWhitePercent = new GridBagConstraints();
        gbc_txtWhitePercent.fill = 2;
        gbc_txtWhitePercent.insets = new Insets(0, 0, 5, 0);
        gbc_txtWhitePercent.gridx = 3;
        gbc_txtWhitePercent.gridy = 1;
        this.contentPane.add((Component)this.txtWhitePercent, gbc_txtWhitePercent);
        this.txtWhitePercent.setColumns(6);
        JLabel lblSyncInterval = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblSyncInterval"));
        GridBagConstraints gbc_lblSyncInterval = new GridBagConstraints();
        gbc_lblSyncInterval.fill = 2;
        gbc_lblSyncInterval.insets = new Insets(0, 0, 5, 5);
        gbc_lblSyncInterval.gridx = 0;
        gbc_lblSyncInterval.gridy = 2;
        this.contentPane.add((Component)lblSyncInterval, gbc_lblSyncInterval);
        this.txtSyncInterval = new JTextField();
        GridBagConstraints gbc_txtSyncInterval = new GridBagConstraints();
        gbc_txtSyncInterval.fill = 2;
        gbc_txtSyncInterval.insets = new Insets(0, 0, 5, 5);
        gbc_txtSyncInterval.gridx = 1;
        gbc_txtSyncInterval.gridy = 2;
        this.contentPane.add((Component)this.txtSyncInterval, gbc_txtSyncInterval);
        this.txtSyncInterval.setColumns(6);
        JLabel lblGrayOffset = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblGrayOffset"));
        GridBagConstraints gbc_lblGrayOffset = new GridBagConstraints();
        gbc_lblGrayOffset.fill = 2;
        gbc_lblGrayOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblGrayOffset.gridx = 2;
        gbc_lblGrayOffset.gridy = 2;
        this.contentPane.add((Component)lblGrayOffset, gbc_lblGrayOffset);
        this.txtGrayOffset = new JTextField();
        GridBagConstraints gbc_txtGrayOffset = new GridBagConstraints();
        gbc_txtGrayOffset.fill = 2;
        gbc_txtGrayOffset.insets = new Insets(0, 0, 5, 0);
        gbc_txtGrayOffset.gridx = 3;
        gbc_txtGrayOffset.gridy = 2;
        this.contentPane.add((Component)this.txtGrayOffset, gbc_txtGrayOffset);
        this.txtGrayOffset.setColumns(6);
        JLabel lblAutoMin = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblAutoMin"));
        GridBagConstraints gbc_lblAutoMin = new GridBagConstraints();
        gbc_lblAutoMin.fill = 2;
        gbc_lblAutoMin.insets = new Insets(0, 0, 5, 5);
        gbc_lblAutoMin.gridx = 0;
        gbc_lblAutoMin.gridy = 3;
        this.contentPane.add((Component)lblAutoMin, gbc_lblAutoMin);
        this.chkAutoMin = new JCheckBox("");
        GridBagConstraints gbc_chkAutoMin = new GridBagConstraints();
        gbc_chkAutoMin.insets = new Insets(0, 0, 5, 5);
        gbc_chkAutoMin.gridx = 1;
        gbc_chkAutoMin.gridy = 3;
        this.contentPane.add((Component)this.chkAutoMin, gbc_chkAutoMin);
        JLabel lblVerifyPlacedMove = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblVerifyPlacedMove"));
        GridBagConstraints gbc_lblVerifyPlacedMove = new GridBagConstraints();
        gbc_lblVerifyPlacedMove.fill = 2;
        gbc_lblVerifyPlacedMove.insets = new Insets(0, 0, 5, 5);
        gbc_lblVerifyPlacedMove.gridx = 2;
        gbc_lblVerifyPlacedMove.gridy = 3;
        this.contentPane.add((Component)lblVerifyPlacedMove, gbc_lblVerifyPlacedMove);
        this.chkVerifyPlacedMove = new JCheckBox("");
        GridBagConstraints gbc_chkVerifyPlacedMove = new GridBagConstraints();
        gbc_chkVerifyPlacedMove.insets = new Insets(0, 0, 5, 0);
        gbc_chkVerifyPlacedMove.gridx = 3;
        gbc_chkVerifyPlacedMove.gridy = 3;
        this.contentPane.add((Component)this.chkVerifyPlacedMove, gbc_chkVerifyPlacedMove);
        this.southPane.setLayout(new BorderLayout());
        this.southPane.add((Component)this.buttonPane, "Center");
        this.southPane.add((Component)this.noticePane, "North");
        this.noticePane.setLayout(new GridLayout(2, 1, 0, 0));
        this.noticePane.add(new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.notice1")));
        this.noticePane.add(new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.notice2")));
        JButton btnReset = new JButton(BoardSyncTool.resourceBundle.getString("SettingsFrame.btnReset"));
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsFrame.this.txtBlackOffset.setText("96");
                SettingsFrame.this.txtBlackPercent.setText("33");
                SettingsFrame.this.txtWhiteOffset.setText("96");
                SettingsFrame.this.txtWhitePercent.setText("33");
                SettingsFrame.this.txtGrayOffset.setText("50");
                SettingsFrame.this.txtSyncInterval.setText("200");
                SettingsFrame.this.chkAutoMin.setSelected(true);
                SettingsFrame.this.chkVerifyPlacedMove.setSelected(true);
                SettingsFrame.this.chkPlayPonder.setSelected(true);
            }
        });
        this.buttonPane.add(btnReset);
        JButton btnApply = new JButton(BoardSyncTool.resourceBundle.getString("SettingsFrame.btnApply"));
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoardSyncTool.config.blackOffset = Utils.parseTextToInt(SettingsFrame.this.txtBlackOffset, BoardSyncTool.config.blackOffset, 0, 255);
                BoardSyncTool.config.blackPercent = Utils.parseTextToInt(SettingsFrame.this.txtBlackPercent, BoardSyncTool.config.blackPercent, 1, 100);
                BoardSyncTool.config.whiteOffset = Utils.parseTextToInt(SettingsFrame.this.txtWhiteOffset, BoardSyncTool.config.whiteOffset, 0, 255);
                BoardSyncTool.config.whitePercent = Utils.parseTextToInt(SettingsFrame.this.txtWhitePercent, BoardSyncTool.config.whitePercent, 1, 100);
                BoardSyncTool.config.grayOffset = Utils.parseTextToInt(SettingsFrame.this.txtGrayOffset, BoardSyncTool.config.grayOffset, 0, 255);
                BoardSyncTool.config.keepSyncIntervalMillseconds = Utils.parseTextToInt(SettingsFrame.this.txtSyncInterval, BoardSyncTool.config.keepSyncIntervalMillseconds);
                BoardSyncTool.config.autoMinimize = SettingsFrame.this.chkAutoMin.isSelected();
                BoardSyncTool.config.verifyPlacedMove = SettingsFrame.this.chkVerifyPlacedMove.isSelected();
                BoardSyncTool.config.playPonder = SettingsFrame.this.chkPlayPonder.isSelected();
                try {
                    BoardSyncTool.config.saveAndWriteConfig();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                SettingsFrame.this.setVisible(false);
                BoardSyncTool.toolFrame.sendPlayPonder();
            }
        });
        this.buttonPane.add(btnApply);
        JButton btnCancel = new JButton(BoardSyncTool.resourceBundle.getString("SettingsFrame.btnCancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsFrame.this.setVisible(false);
            }
        });
        this.buttonPane.add(btnCancel);
        this.txtBlackOffset.setDocument(new IntDocument());
        this.txtBlackPercent.setDocument(new IntDocument());
        this.txtWhiteOffset.setDocument(new IntDocument());
        this.txtWhitePercent.setDocument(new IntDocument());
        this.txtGrayOffset.setDocument(new IntDocument());
        this.txtSyncInterval.setDocument(new IntDocument());
        JLabel lblPlayPonder = new JLabel(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblPlayPonder"));
        lblPlayPonder.setToolTipText(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblPlayPonder.toolTips"));
        GridBagConstraints gbc_lblPlayPonder = new GridBagConstraints();
        gbc_lblPlayPonder.fill = 2;
        gbc_lblPlayPonder.insets = new Insets(0, 0, 0, 5);
        gbc_lblPlayPonder.gridx = 0;
        gbc_lblPlayPonder.gridy = 4;
        this.contentPane.add((Component)lblPlayPonder, gbc_lblPlayPonder);
        this.chkPlayPonder = new JCheckBox();
        GridBagConstraints gbc_chkPlayPonder = new GridBagConstraints();
        gbc_chkPlayPonder.insets = new Insets(0, 0, 0, 5);
        gbc_chkPlayPonder.gridx = 1;
        gbc_chkPlayPonder.gridy = 4;
        this.chkPlayPonder.setToolTipText(BoardSyncTool.resourceBundle.getString("SettingsFrame.lblPlayPonder.toolTips"));
        this.contentPane.add((Component)this.chkPlayPonder, gbc_chkPlayPonder);
        this.loadValue();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void loadValue() {
        this.txtBlackOffset.setText(String.valueOf(BoardSyncTool.config.blackOffset));
        this.txtBlackPercent.setText(String.valueOf(BoardSyncTool.config.blackPercent));
        this.txtWhiteOffset.setText(String.valueOf(BoardSyncTool.config.whiteOffset));
        this.txtWhitePercent.setText(String.valueOf(BoardSyncTool.config.whitePercent));
        this.txtGrayOffset.setText(String.valueOf(BoardSyncTool.config.grayOffset));
        this.txtSyncInterval.setText(String.valueOf(BoardSyncTool.config.keepSyncIntervalMillseconds));
        this.chkAutoMin.setSelected(BoardSyncTool.config.autoMinimize);
        this.chkVerifyPlacedMove.setSelected(BoardSyncTool.config.verifyPlacedMove);
        this.chkPlayPonder.setSelected(BoardSyncTool.config.playPonder);
    }
}

