/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardPosition;
import boardsync.BoardSyncTool;
import boardsync.GapCount;
import boardsync.VerticalHorizonLines;
import boardsync.lineInterval;
import boofcv.abst.feature.detect.line.DetectLineSegment;
import boofcv.factory.feature.detect.line.ConfigLineRansac;
import boofcv.factory.feature.detect.line.FactoryDetectLine;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LineDetection {
    private int size;
    private List<VerticalHorizonLines> verticalLines = new ArrayList<VerticalHorizonLines>();
    private List<VerticalHorizonLines> horizonLines = new ArrayList<VerticalHorizonLines>();
    private List<lineInterval> verticalLineIntervals = new ArrayList<lineInterval>();
    private List<lineInterval> horizonLineIntervals = new ArrayList<lineInterval>();

    private <T extends ImageGray<T>, D extends ImageGray<D>> List<LineSegment2D_F32> detectLineSegments(BufferedImage image, Class<T> imageType, int threshold) {
        this.size = Math.min(image.getHeight(), image.getWidth());
        Object input = ConvertBufferedImage.convertFromSingle(image, null, imageType);
        DetectLineSegment<Object> detector = FactoryDetectLine.lineRansac(new ConfigLineRansac(this.size / 40, threshold, 0.1, true), imageType);
        List<LineSegment2D_F32> found = detector.detect(input);
        return found;
    }

    private void CalculateLines(List<LineSegment2D_F32> lines, BufferedImage srcImage) {
        for (LineSegment2D_F32 line : lines) {
            int minX = Math.round(Math.min(line.a.x, line.b.x));
            int maxX = Math.round(Math.max(line.a.x, line.b.x));
            int minY = Math.round(Math.min(line.a.y, line.b.y));
            int maxY = Math.round(Math.max(line.a.y, line.b.y));
            int gapX = maxX - minX;
            int gapY = maxY - minY;
            if (gapX <= 4 && gapY >= 4 * gapX) {
                VerticalHorizonLines vLine = new VerticalHorizonLines();
                vLine.start = minY;
                vLine.end = maxY;
                vLine.position = (float)(minX + maxX) / 2.0f;
                vLine.lengthSum = gapY;
                this.verticalLines.add(vLine);
                continue;
            }
            if (gapY > 4 || gapX < 4 * gapY) continue;
            VerticalHorizonLines hLine = new VerticalHorizonLines();
            hLine.start = minX;
            hLine.end = maxX;
            hLine.position = (float)(minY + maxY) / 2.0f;
            hLine.lengthSum = gapX;
            this.horizonLines.add(hLine);
        }
        this.SortLines(this.horizonLines);
        this.SortLines(this.verticalLines);
    }

    private int calculateGap(List<VerticalHorizonLines> Lines) {
        ArrayList<Float> gaps = new ArrayList<Float>();
        int s = 0;
        while (s < Lines.size() - 1) {
            VerticalHorizonLines line1 = Lines.get(s);
            VerticalHorizonLines line2 = Lines.get(s + 1);
            float gap = line2.position - line1.position;
            gaps.add(Float.valueOf(gap));
            ++s;
        }
        ArrayList<GapCount> gapCounts = new ArrayList<GapCount>();
        int s2 = 0;
        while (s2 < gaps.size()) {
            float gap = ((Float)gaps.get(s2)).floatValue();
            Boolean isNew = true;
            int n = 0;
            while (n < gapCounts.size()) {
                GapCount gapCount = (GapCount)gapCounts.get(n);
                if (gap == gapCount.gap) {
                    isNew = false;
                    ++gapCount.counts;
                }
                ++n;
            }
            if (isNew.booleanValue()) {
                GapCount gapCount = new GapCount();
                gapCount.gap = gap;
                gapCount.counts = 1;
                gapCounts.add(gapCount);
            }
            ++s2;
        }
        Collections.sort(gapCounts, new Comparator<GapCount>(){

            @Override
            public int compare(GapCount gap1, GapCount gap2) {
                if (gap1.counts > gap2.counts) {
                    return -1;
                }
                if (gap1.counts < gap2.counts) {
                    return 1;
                }
                return 0;
            }
        });
        float finalGap = ((GapCount)gapCounts.get((int)0)).gap;
        return Math.round(finalGap);
    }

    private void SortLines(List<VerticalHorizonLines> lines) {
        int s;
        Collections.sort(lines, new Comparator<VerticalHorizonLines>(){

            @Override
            public int compare(VerticalHorizonLines line1, VerticalHorizonLines line2) {
                if (line1.position > line2.position) {
                    return 1;
                }
                if (line1.position < line2.position) {
                    return -1;
                }
                return 0;
            }
        });
        if (lines.size() >= 2) {
            VerticalHorizonLines line2;
            VerticalHorizonLines line1;
            s = 0;
            while (s < lines.size() / 2) {
                line1 = lines.get(s);
                line2 = lines.get(s + 1);
                if (Math.abs(line1.position - line2.position) <= 4.0f) {
                    line2.position = line1.lengthSum > line2.lengthSum ? line1.position : line2.position;
                    line2.lengthSum += line1.lengthSum;
                    line2.start = Math.min(line1.start, line2.start);
                    line2.end = Math.max(line1.end, line2.end);
                    line1.needDelete = true;
                }
                ++s;
            }
            s = lines.size();
            while (s > lines.size() / 2) {
                line1 = lines.get(s - 1);
                line2 = lines.get(s - 2);
                if (!line2.needDelete.booleanValue() && Math.abs(line1.position - line2.position) <= 4.0f) {
                    line2.position = line1.lengthSum > line2.lengthSum ? line1.position : line2.position;
                    line2.lengthSum += line1.lengthSum;
                    line2.start = Math.min(line1.start, line2.start);
                    line2.end = Math.max(line1.end, line2.end);
                    line1.needDelete = true;
                }
                --s;
            }
        }
        s = 0;
        while (s < lines.size()) {
            if (lines.get((int)s).needDelete.booleanValue()) {
                lines.remove(s);
                --s;
            } else if (lines.get((int)s).lengthSum < this.size / 30) {
                lines.remove(s);
                --s;
            }
            ++s;
        }
    }

    private void validateLines(List<VerticalHorizonLines> Lines, int rawGap) {
        int n = 0;
        while (n < Lines.size()) {
            VerticalHorizonLines line1 = Lines.get(n);
            int m = n + 1;
            while (m < Lines.size()) {
                VerticalHorizonLines line2 = Lines.get(m);
                if (Math.abs(line2.position - line1.position - (float)rawGap) <= 2.0f) {
                    line1.validate = true;
                    line2.validate = true;
                }
                ++m;
            }
            ++n;
        }
    }

    private int reCalculateGap(List<VerticalHorizonLines> Lines, int rawGap) {
        ArrayList<GapCount> gapCounts = new ArrayList<GapCount>();
        int n = 0;
        while (n < Lines.size()) {
            VerticalHorizonLines line1 = Lines.get(n);
            if (line1.validate.booleanValue()) {
                int m = n + 1;
                while (m < Lines.size()) {
                    VerticalHorizonLines line2 = Lines.get(m);
                    if (line2.validate.booleanValue()) {
                        float totalGaps = line2.position - line1.position;
                        int gap = Math.round(totalGaps / (float)Math.round(totalGaps / (float)rawGap));
                        Boolean isNew = true;
                        int s = 0;
                        while (s < gapCounts.size()) {
                            GapCount gapCount = (GapCount)gapCounts.get(s);
                            if ((float)gap == gapCount.gap) {
                                isNew = false;
                                ++gapCount.counts;
                            }
                            ++s;
                        }
                        if (isNew.booleanValue()) {
                            GapCount gapCount = new GapCount();
                            gapCount.gap = gap;
                            gapCount.counts = 1;
                            gapCounts.add(gapCount);
                        }
                    }
                    ++m;
                }
            }
            ++n;
        }
        Collections.sort(gapCounts, new Comparator<GapCount>(){

            @Override
            public int compare(GapCount gap1, GapCount gap2) {
                if (gap1.counts > gap2.counts) {
                    return -1;
                }
                if (gap1.counts < gap2.counts) {
                    return 1;
                }
                return 0;
            }
        });
        if (((GapCount)gapCounts.get((int)0)).counts >= 3) {
            return (int)((GapCount)gapCounts.get((int)0)).gap;
        }
        return rawGap;
    }

    private List<lineInterval> calculateInterval(List<VerticalHorizonLines> lines, int length) {
        ArrayList<lineInterval> lineIntervals = new ArrayList<lineInterval>();
        int s = 0;
        while (s < lines.size()) {
            VerticalHorizonLines line1 = lines.get(s);
            int n = s + 1;
            while (n < lines.size()) {
                VerticalHorizonLines line2 = lines.get(n);
                lineInterval interval = new lineInterval();
                interval.minPos = line1.position;
                interval.maxPos = line2.position;
                interval.interval = Math.abs(line2.position - line1.position - (float)length);
                lineIntervals.add(interval);
                ++n;
            }
            ++s;
        }
        Collections.sort(lineIntervals, new Comparator<lineInterval>(){

            @Override
            public int compare(lineInterval interval1, lineInterval interval2) {
                if (interval1.interval > interval2.interval) {
                    return 1;
                }
                if (interval1.interval < interval2.interval) {
                    return -1;
                }
                return 0;
            }
        });
        return lineIntervals;
    }

    private void reCalculateInterval(List<lineInterval> lineIntervals, List<VerticalHorizonLines> lines, int gap) {
        while (lineIntervals.size() >= 2 && Math.abs(lineIntervals.get((int)0).interval - lineIntervals.get((int)1).interval) <= (float)(gap / 3)) {
            int v1MinOutLinesCounts;
            float v0Min = lineIntervals.get((int)0).minPos + (float)gap / 2.0f;
            int v0MinCounts = 0;
            float v0Max = lineIntervals.get((int)0).maxPos - (float)gap / 2.0f;
            int v0MaxCounts = 0;
            float v1Min = lineIntervals.get((int)1).minPos + (float)gap / 2.0f;
            int v1MinCounts = 0;
            float v1Max = lineIntervals.get((int)1).maxPos - (float)gap / 2.0f;
            int v1MaxCounts = 0;
            int s = 0;
            while (s < lines.size()) {
                VerticalHorizonLines line = lines.get(s);
                if (line.validate.booleanValue()) {
                    if ((float)line.start < v0Min && (float)line.end > v0Min) {
                        ++v0MinCounts;
                    }
                    if ((float)line.end > v0Max && (float)line.start < v0Max) {
                        ++v0MaxCounts;
                    }
                    if ((float)line.start < v1Min && (float)line.end > v1Min) {
                        ++v1MinCounts;
                    }
                    if ((float)line.end > v1Max && (float)line.start < v1Max) {
                        ++v1MaxCounts;
                    }
                }
                ++s;
            }
            int v0MinOutLinesCounts = Math.min(v0MinCounts, v0MaxCounts);
            if (v0MinOutLinesCounts < (v1MinOutLinesCounts = Math.min(v1MinCounts, v1MaxCounts))) {
                lineIntervals.remove(0);
                continue;
            }
            lineIntervals.remove(1);
        }
    }

    public BoardPosition getBoardPosition(BufferedImage input) {
        double threshold = 50.0;
        List<LineSegment2D_F32> lines = this.detectLineSegments(input, GrayF32.class, (int)threshold);
        this.CalculateLines(lines, input);
        int lineCounts = this.verticalLines.size() + this.horizonLines.size();
        int maxTimes = 10;
        while (lineCounts < 10 && maxTimes > 0) {
            lines = this.detectLineSegments(input, GrayF32.class, (int)(threshold *= 0.9));
            this.CalculateLines(lines, input);
            lineCounts = this.verticalLines.size() + this.horizonLines.size();
            --maxTimes;
        }
        if (this.horizonLines.size() < 3 || this.verticalLines.size() < 3) {
            return null;
        }
        int hGap = this.calculateGap(this.horizonLines);
        int vGap = this.calculateGap(this.verticalLines);
        this.validateLines(this.horizonLines, hGap);
        this.validateLines(this.verticalLines, vGap);
        hGap = this.reCalculateGap(this.horizonLines, hGap);
        vGap = this.reCalculateGap(this.verticalLines, vGap);
        int boardWidth = vGap * (BoardSyncTool.boardWidth - 1);
        int boardHeight = hGap * (BoardSyncTool.boardHeight - 1);
        this.horizonLineIntervals = this.calculateInterval(this.horizonLines, boardHeight);
        this.verticalLineIntervals = this.calculateInterval(this.verticalLines, boardWidth);
        this.reCalculateInterval(this.horizonLineIntervals, this.verticalLines, hGap);
        this.reCalculateInterval(this.verticalLineIntervals, this.horizonLines, vGap);
        int x0 = Math.round(this.verticalLineIntervals.get((int)0).minPos - (float)((hGap + 1) / 2));
        int x1 = Math.round(this.verticalLineIntervals.get((int)0).maxPos + (float)((hGap + 1) / 2));
        int y0 = Math.round(this.horizonLineIntervals.get((int)0).minPos - (float)((vGap + 1) / 2));
        int y1 = Math.round(this.horizonLineIntervals.get((int)0).maxPos + (float)((vGap + 1) / 2));
        BoardPosition position = new BoardPosition();
        position.x = BoardSyncTool.screenImageStartX + x0;
        position.y = BoardSyncTool.screenImageStartY + y0;
        position.width = x1 - x0;
        position.height = y1 - y0;
        return position;
    }
}

