/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardPosition;
import boardsync.BoardSyncTool;
import boardsync.MoveColorInfo;
import boardsync.Utils;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class BoardOCR {
    public boolean hasMoveAt(int x, int y, int width, int height, int moveX, int moveY) throws AWTException {
        if (width <= 0 || height <= 0) {
            return true;
        }
        BufferedImage input = this.getScreenImage(x, y, width, height);
        boolean hasStone = false;
        MoveColorInfo colorInfo = this.getColorPercent(input, x, y, width, height, false);
        if (colorInfo.blackPercent >= BoardSyncTool.config.blackPercent) {
            return true;
        }
        if (colorInfo.whitePercent >= BoardSyncTool.config.whitePercent) {
            hasStone = moveX == 0 || moveX == BoardSyncTool.boardWidth - 1 || moveY == 0 || moveY == BoardSyncTool.boardHeight - 1 ? colorInfo.whitePercent <= 85 : colorInfo.whitePercent <= 80;
            hasStone = true;
        }
        return hasStone;
    }

    public void oneTimeSync() throws AWTException {
        BoardPosition position = BoardSyncTool.boardPosition;
        BufferedImage input = this.getScreenImage(position.x, position.y, position.width, position.height);
        this.recognizeBoard(input);
    }

    private BufferedImage getScreenImage(int x, int y, int width, int height) throws AWTException {
        Robot robot = new Robot();
        return robot.createScreenCapture(new Rectangle(x, y, width, height));
    }

    private void recognizeBoard(BufferedImage input) {
        float hGap = (float)input.getHeight() / (float)BoardSyncTool.boardHeight;
        float vGap = (float)input.getWidth() / (float)BoardSyncTool.boardWidth;
        int hGapInt = Math.round(hGap);
        int vGapInt = Math.round(vGap);
        String result = "";
        int blackMinPercent = 200;
        int blackTotalPercent = 0;
        int blackMinX = -1;
        int blackMinY = -1;
        int blackCounts = 0;
        int whiteMinPercent = 200;
        int whiteTotalPercent = 0;
        int whiteMinX = -1;
        int whiteMinY = -1;
        int whiteCounts = 0;
        int[] resultValue = new int[BoardSyncTool.boardHeight * BoardSyncTool.boardWidth];
        int redCount = 0;
        int blueCount = 0;
        int blueRedX = -1;
        int blueRedY = -1;
        boolean needCheckRedBlue = true;
        int y = 0;
        while (y < BoardSyncTool.boardHeight) {
            int x = 0;
            while (x < BoardSyncTool.boardWidth) {
                MoveColorInfo colorInfo = this.getColorPercent(input, Math.round((float)x * vGap), Math.round((float)y * hGap), vGapInt, hGapInt, needCheckRedBlue);
                boolean isBlack = colorInfo.blackPercent >= BoardSyncTool.config.blackPercent;
                boolean isWhite = false;
                if (isBlack) {
                    resultValue[y * BoardSyncTool.boardWidth + x] = 1;
                    blackTotalPercent += colorInfo.blackPercent;
                    ++blackCounts;
                    if (colorInfo.blackPercent < blackMinPercent) {
                        blackMinPercent = colorInfo.blackPercent;
                        blackMinX = x;
                        blackMinY = y;
                    }
                } else {
                    if (colorInfo.whitePercent >= BoardSyncTool.config.whitePercent) {
                        isWhite = x == 0 || x == BoardSyncTool.boardWidth - 1 || y == 0 || y == BoardSyncTool.boardHeight - 1 ? colorInfo.whitePercent <= 85 : colorInfo.whitePercent <= 80;
                    }
                    if (isWhite) {
                        resultValue[y * BoardSyncTool.boardWidth + x] = 2;
                        whiteTotalPercent += colorInfo.whitePercent;
                        ++whiteCounts;
                        if (colorInfo.whitePercent < whiteMinPercent) {
                            whiteMinPercent = colorInfo.whitePercent;
                            whiteMinX = x;
                            whiteMinY = y;
                        }
                    } else {
                        resultValue[y * BoardSyncTool.boardWidth + x] = 0;
                    }
                }
                if (needCheckRedBlue && (isWhite || isBlack)) {
                    if (colorInfo.bluePercent >= BoardSyncTool.config.bluePercent) {
                        if (redCount > 1 && ++blueCount > 1) {
                            needCheckRedBlue = false;
                        } else {
                            blueRedX = x;
                            blueRedY = y;
                        }
                    }
                    if (colorInfo.redPercent >= BoardSyncTool.config.redPercent) {
                        if (++redCount > 1 && blueCount > 1) {
                            needCheckRedBlue = false;
                        } else {
                            blueRedX = x;
                            blueRedY = y;
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
        if (redCount == 1 && blueCount != 1 || redCount != 1 && blueCount == 1) {
            if (resultValue[blueRedY * BoardSyncTool.boardWidth + blueRedX] == 1) {
                resultValue[blueRedY * BoardSyncTool.boardWidth + blueRedX] = 3;
            } else if (resultValue[blueRedY * BoardSyncTool.boardWidth + blueRedX] == 2) {
                resultValue[blueRedY * BoardSyncTool.boardWidth + blueRedX] = 4;
            }
        } else if (blackCounts >= 2 && whiteCounts >= 2) {
            float whiteMaxOffset;
            float blackMaxOffset = Math.abs((float)blackMinPercent - (float)(blackTotalPercent - blackMinPercent) / (float)(blackCounts - 1));
            if (blackMaxOffset >= (whiteMaxOffset = Math.abs((float)whiteMinPercent - (float)(whiteTotalPercent - whiteMinPercent) / (float)(whiteCounts - 1)))) {
                if (blackMinY >= 0 && blackMinX >= 0) {
                    resultValue[blackMinY * BoardSyncTool.boardWidth + blackMinX] = 3;
                }
            } else if (whiteMinY >= 0 && whiteMinX >= 0) {
                resultValue[whiteMinY * BoardSyncTool.boardWidth + whiteMinX] = 4;
            }
        } else if (blackCounts > 0 && whiteCounts > 0) {
            if (blackCounts < whiteCounts && blackMinY >= 0 && blackMinX >= 0) {
                resultValue[blackMinY * BoardSyncTool.boardWidth + blackMinX] = 3;
            }
            if (blackCounts > whiteCounts && whiteMinY >= 0 && whiteMinX >= 0) {
                resultValue[whiteMinY * BoardSyncTool.boardWidth + whiteMinX] = 4;
            }
        }
        int i = 0;
        while (i < BoardSyncTool.boardHeight) {
            int j = 0;
            while (j < BoardSyncTool.boardWidth) {
                result = String.valueOf(result) + resultValue[i * BoardSyncTool.boardWidth + j] + ",";
                if (j == BoardSyncTool.boardWidth - 1) {
                    result = result.substring(0, result.length() - 1);
                    Utils.send("re=" + result);
                    result = "";
                }
                ++j;
            }
            ++i;
        }
        Utils.send("end");
    }

    private MoveColorInfo getColorPercent(BufferedImage input, int startX, int startY, int width, int height, boolean needCheckRedBlue) {
        int blackSum = 0;
        int whiteSum = 0;
        int redSum = 0;
        int blueSum = 0;
        if (startX + width > input.getWidth()) {
            startX = input.getWidth() - width;
        }
        if (startY + height > input.getHeight()) {
            startY = input.getHeight() - height;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int[] rgb = this.getRGB(input, startX + x, startY + y);
                int red = rgb[0];
                int blue = rgb[1];
                int green = rgb[2];
                if (Math.abs(red - blue) < BoardSyncTool.config.grayOffset && Math.abs(blue - green) < BoardSyncTool.config.grayOffset && Math.abs(green - red) < BoardSyncTool.config.grayOffset) {
                    int whiteValue;
                    if (red <= BoardSyncTool.config.blackOffset && blue <= BoardSyncTool.config.blackOffset && green <= BoardSyncTool.config.blackOffset) {
                        ++blackSum;
                    }
                    if (red >= (whiteValue = 255 - BoardSyncTool.config.whiteOffset) && blue >= whiteValue && green >= whiteValue) {
                        ++whiteSum;
                    }
                }
                if (needCheckRedBlue) {
                    if (red >= 150 && blue <= 50 && green <= 50) {
                        ++redSum;
                    }
                    if (blue >= 150 && red <= 50 && green <= 50) {
                        ++blueSum;
                    }
                }
                ++x;
            }
            ++y;
        }
        MoveColorInfo colorInfo = new MoveColorInfo();
        int total = width * height;
        colorInfo.blackPercent = 100 * blackSum / total;
        colorInfo.whitePercent = 100 * whiteSum / total;
        colorInfo.redPercent = 100 * redSum / total;
        colorInfo.bluePercent = 100 * blueSum / total;
        return colorInfo;
    }

    private int[] getRGB(BufferedImage image, int x, int y) {
        int[] rgb = null;
        rgb = new int[3];
        int pixel = image.getRGB(x, y);
        rgb[0] = (pixel & 0xFF0000) >> 16;
        rgb[1] = (pixel & 0xFF00) >> 8;
        rgb[2] = pixel & 0xFF;
        return rgb;
    }
}

