-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Minion active skills
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["ChaosElementalCascadeSummoned"] = {
	name = "Cascade",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.3650000095367,
	incrementalEffectiveness = 0.040600001811981,
	description = "Icicles emerge from the ground in a series of small bursts, each damaging enemies caught in the area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Physical] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		area = true,
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 6 },
		{ "skill_physical_damage_%_to_convert_to_chaos", 100 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 3, critChance = 5, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SandstormChaosElementalSummoned"] = {
	name = "Chaos Aura",
	hidden = true,
	color = 4,
	baseEffectiveness = 6.1421999931335,
	incrementalEffectiveness = 0.052099999040365,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("dotIsArea", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "active_skill_area_of_effect_radius_+%_final", 20 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"is_area_damage",
		"spell_damage_modifiers_apply_to_skill_dot",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 8, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["SandstormChaosElementalSummonedEmpowered"] = {
	name = "Empowered Chaos Aura",
	hidden = true,
	color = 4,
	baseEffectiveness = 19.89999961853,
	incrementalEffectiveness = 0.052099999040365,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("dotIsArea", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
		{ "active_skill_area_of_effect_radius_+%_final", 50 },
		{ "chaos_damage_taken_+%", 6 },
		{ "wither_expire_speed_+%", -100 },
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"is_area_damage",
		"spell_damage_modifiers_apply_to_skill_dot",
		"sandstorm_applies_withered_to_enemies_within",
	},
	levels = {
		[1] = { 16.666667039196, cooldown = 8, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, }, },
	},
}
skills["FireElementalFlameRedSummoned"] = {
	name = "Immolate",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2546999454498,
	incrementalEffectiveness = 0.044599998742342,
	description = "Summons a totem that fires a stream of flame at nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 8,
	castTime = 0.25,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "active_skill_cast_speed_+%_final", -89 },
		{ "spell_maximum_action_distance_+%", -77 },
		{ "monster_penalty_against_minions_damage_+%_final_vs_player_minions", -25 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"always_pierce",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 0.8, levelRequirement = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["FireElementalMortarSummoned"] = {
	name = "Magma Ball",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.8238000869751,
	incrementalEffectiveness = 0.034600000828505,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 15 },
		{ "spell_maximum_action_distance_+%", -33 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, critChance = 5, damageEffectiveness = 2, levelRequirement = 34, storedUses = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["FireElementalConeSummoned"] = {
	name = "Flame Wave",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.8845000267029,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.935,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 34, storedUses = 1, statInterpolation = { 3, 3, }, },
		[2] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 36, storedUses = 1, statInterpolation = { 3, 3, }, },
		[3] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 38, storedUses = 1, statInterpolation = { 3, 3, }, },
		[4] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, }, },
		[5] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 42, storedUses = 1, statInterpolation = { 3, 3, }, },
		[6] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, 3, }, },
		[7] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 46, storedUses = 1, statInterpolation = { 3, 3, }, },
		[8] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, 3, }, },
		[9] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 50, storedUses = 1, statInterpolation = { 3, 3, }, },
		[10] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, }, },
		[11] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 54, storedUses = 1, statInterpolation = { 3, 3, }, },
		[12] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 56, storedUses = 1, statInterpolation = { 3, 3, }, },
		[13] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 3, }, },
		[14] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 60, storedUses = 1, statInterpolation = { 3, 3, }, },
		[15] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 62, storedUses = 1, statInterpolation = { 3, 3, }, },
		[16] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, }, },
		[17] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 66, storedUses = 1, statInterpolation = { 3, 3, }, },
		[18] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 68, storedUses = 1, statInterpolation = { 3, 3, }, },
		[19] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 69, storedUses = 1, statInterpolation = { 3, 3, }, },
		[20] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
		[21] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, }, },
		[22] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, }, },
		[23] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, }, },
		[24] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, }, },
		[25] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, }, },
		[26] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, }, },
		[27] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, }, },
		[28] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, }, },
		[29] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, }, },
		[30] = { 0.80000001192093, 1.25, cooldown = 2, critChance = 5, damageEffectiveness = 2, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["FireElementalMeteorSummoned"] = {
	name = "Meteor",
	hidden = true,
	color = 4,
	baseEffectiveness = 14,
	incrementalEffectiveness = 0.056000001728535,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.DamageOverTime] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 5000 },
		{ "skill_physical_damage_%_to_convert_to_fire", 100 },
		{ "active_skill_area_of_effect_radius_+%_final", 80 },
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"is_area_damage",
	},
	notMinionStat = {
		"base_fire_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 21.666666356226, baseMultiplier = 6.8, damageEffectiveness = 6.8, levelRequirement = 1, statInterpolation = { 3, }, },
	},
}
skills["IceElementalIceCyclone"] = {
	name = "Cyclone",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.85000002384186,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location. Cannot be supported by Ruthless or Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
		movement = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
	},
	constantStats = {
		{ "cyclone_movement_speed_+%_final", 75 },
		{ "cyclone_extra_distance", 40 },
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"is_area_damage",
		"cyclone_places_ground_ice",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["IceElementalSpearSummoned"] = {
	name = "Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.2813000679016,
	incrementalEffectiveness = 0.034600000828505,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 25 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 4, damageEffectiveness = 1.5, levelRequirement = 3, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["IceElementalSpearSummonedDeathNova"] = {
	name = "Death Nova",
	hidden = true,
	color = 3,
	baseEffectiveness = 4.5626001358032,
	incrementalEffectiveness = 0.034600000828505,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "monster_reverse_point_blank_damage_-%_at_minimum_range", 25 },
		{ "number_of_additional_projectiles", 13 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"projectiles_nova",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, damageEffectiveness = 1.5, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["DeathExplodeIceElementalSummoned"] = {
	name = "Explode",
	hidden = true,
	color = 4,
	baseEffectiveness = 5.4699997901917,
	incrementalEffectiveness = 0.034699998795986,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		area = true,
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 3, statInterpolation = { 3, 3, }, },
	},
}
skills["LightningGolemArcSummoned"] = {
	name = "Storm Orb",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.78420001268387,
	incrementalEffectiveness = 0.028500000014901,
	skillTypes = { [SkillType.Duration] = true, [SkillType.Lightning] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ProjectileSpeed] = true, [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 8000 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.20000000298023, 1.7999999523163, cooldown = 8, critChance = 6, damageEffectiveness = 0.6, levelRequirement = 1, storedUses = 2, statInterpolation = { 3, 3, }, },
	},
}
skills["MonsterProjectileSpellLightningGolemSummoned"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2934999465942,
	incrementalEffectiveness = 0.036100000143051,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 11 },
		{ "active_skill_cast_speed_+%_final", -15 },
		{ "spell_maximum_action_distance_+%", -40 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.20000000298023, 1.7999999523163, critChance = 6, damageEffectiveness = 2.5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["LightningGolemWrath"] = {
	name = "Lightning Golem Wrath",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.16249999403954,
	incrementalEffectiveness = 0.019999999552965,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.Aura] = true, [SkillType.Lightning] = true, [SkillType.Duration] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	statMap = {
		["attack_minimum_added_lightning_damage"] = {
			mod("LightningMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_maximum_added_lightning_damage"] = {
			mod("LightningMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_minimum_added_lightning_damage"] = {
			mod("LightningMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_maximum_added_lightning_damage"] = {
			mod("LightningMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"attack_minimum_added_lightning_damage",
		"attack_maximum_added_lightning_damage",
		"spell_minimum_added_lightning_damage",
		"spell_maximum_added_lightning_damage",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 0.20000000298023, 1.7999999523163, 0.11999999731779, 1.0800000429153, cooldown = 12, levelRequirement = 1, storedUses = 1, statInterpolation = { 3, 3, 3, 3, }, },
	},
}
skills["SpectralSkullShieldCharge"] = {
	name = "Charge",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Charges at an enemy, bashing it with the character's shield and striking it. This knocks it back and stuns it. Enemies in the way are pushed to the side. Damage and stun are proportional to distance travelled.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "shield_charge_stun_duration_+%_maximum", 200 },
		{ "base_movement_velocity_+%", 500 },
		{ "shield_charge_damage_+%_maximum", 300 },
		{ "active_skill_damage_+%_final", -50 },
	},
	stats = {
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { cooldown = 5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["RagingSpiritMeleeAttack"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	stats = {
		"active_skill_damage_+%_final",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 76, levelRequirement = 4, statInterpolation = { 1, }, },
		[2] = { 71, levelRequirement = 6, statInterpolation = { 1, }, },
		[3] = { 66, levelRequirement = 9, statInterpolation = { 1, }, },
		[4] = { 61, levelRequirement = 12, statInterpolation = { 1, }, },
		[5] = { 56, levelRequirement = 15, statInterpolation = { 1, }, },
		[6] = { 52, levelRequirement = 19, statInterpolation = { 1, }, },
		[7] = { 47, levelRequirement = 23, statInterpolation = { 1, }, },
		[8] = { 42, levelRequirement = 28, statInterpolation = { 1, }, },
		[9] = { 37, levelRequirement = 33, statInterpolation = { 1, }, },
		[10] = { 32, levelRequirement = 39, statInterpolation = { 1, }, },
		[11] = { 28, levelRequirement = 43, statInterpolation = { 1, }, },
		[12] = { 23, levelRequirement = 46, statInterpolation = { 1, }, },
		[13] = { 18, levelRequirement = 49, statInterpolation = { 1, }, },
		[14] = { 12, levelRequirement = 52, statInterpolation = { 1, }, },
		[15] = { 10, levelRequirement = 55, statInterpolation = { 1, }, },
		[16] = { 7, levelRequirement = 58, statInterpolation = { 1, }, },
		[17] = { 5, levelRequirement = 61, statInterpolation = { 1, }, },
		[18] = { 2, levelRequirement = 64, statInterpolation = { 1, }, },
		[19] = { 0, levelRequirement = 66, statInterpolation = { 1, }, },
		[20] = { -2, levelRequirement = 68, statInterpolation = { 1, }, },
		[21] = { -4, levelRequirement = 70, statInterpolation = { 1, }, },
		[22] = { -7, levelRequirement = 72, statInterpolation = { 1, }, },
		[23] = { -10, levelRequirement = 74, statInterpolation = { 1, }, },
	},
}
skills["SkeletonMinionProjectileCold"] = {
	name = "Cold Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1579999923706,
	incrementalEffectiveness = 0.040899999439716,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Multicastable] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "base_chance_to_freeze_%", 20 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SkeletonMinionProjectileFire"] = {
	name = "Fire Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1579999923706,
	incrementalEffectiveness = 0.040899999439716,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Multicastable] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "base_chance_to_ignite_%", 20 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 12, statInterpolation = { 3, 3, }, },
	},
}
skills["SkeletonMinionProjectileLightning"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1579999923706,
	incrementalEffectiveness = 0.040899999439716,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Multicastable] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "base_chance_to_shock_%", 20 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["RockGolemSlam"] = {
	name = "Slam",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -20 },
		{ "chance_to_taunt_on_hit_%", 33 },
		{ "active_skill_area_of_effect_radius_+%_final", 200 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 2, cooldown = 4, damageEffectiveness = 2, levelRequirement = 1, storedUses = 1, },
	},
}
skills["RockGolemMinionWhirlingBlades"] = {
	name = "Roll",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Dive through enemies, dealing weapon damage. If dual wielding attacks with both weapons, dealing the damage of both in one hit. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.43,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	constantStats = {
		{ "skill_sound_variation", 1 },
		{ "active_skill_attack_speed_+%_final", -25 },
		{ "monster_flurry", 1 },
	},
	stats = {
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 1, storedUses = 1, },
	},
}
skills["ZombieSlam"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 18),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 25 },
		{ "active_skill_attack_speed_+%_final", -25 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, cooldown = 6, damageEffectiveness = 1.5, levelRequirement = 1, storedUses = 1, },
		[2] = { baseMultiplier = 1.5, cooldown = 6, damageEffectiveness = 1.5, levelRequirement = 12, storedUses = 1, },
		[3] = { baseMultiplier = 1.5, cooldown = 6, damageEffectiveness = 1.5, levelRequirement = 20, storedUses = 1, },
		[4] = { baseMultiplier = 1.5, cooldown = 6, damageEffectiveness = 1.5, levelRequirement = 33, storedUses = 1, },
		[5] = { baseMultiplier = 1.5, cooldown = 6, damageEffectiveness = 1.5, levelRequirement = 45, storedUses = 1, },
	},
}
skills["GAZombieCorpseGroundImpact"] = {
	name = "Falling Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = 1 / (activeSkill.summonSkill.skillData.summonSpeed or 1)
	end,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	stats = {
		"is_area_damage",
		"global_always_hit",
	},
	levels = {
		[1] = { baseMultiplier = 2.5, damageEffectiveness = 2.5, levelRequirement = 1, },
	},
}
skills["SummonedSpiderViperStrike"] = {
	name = "Viper Strike",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.64999997615814,
	incrementalEffectiveness = 0.025499999523163,
	description = "Hits enemies, converting some of your physical damage to chaos damage and inflicting poison which will be affected by modifiers to skill duration. If dual wielding, will strike with both weapons. Requires a claw, dagger or sword.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "base_chance_to_poison_on_hit_%", 100 },
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"poison_duration_is_skill_duration",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["DancingDervishCycloneChannelled"] = {
	name = "Cyclone",
	hidden = true,
	color = 4,
	description = "Channel this skill to move towards a targeted location while spinning constantly attacking enemies in an area around you. While channelling this skill, you cannot be knocked back.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Channel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
		skill("radiusIsWeaponRange", true),
	},
	constantStats = {
		{ "cyclone_gain_stage_every_x_ms_while_channelling", 170 },
		{ "cyclone_melee_weapon_range_+_per_stage", 1 },
		{ "cyclone_stage_decay_time_ms", 330 },
		{ "cyclone_max_number_of_stages", 6 },
		{ "cyclone_area_of_effect_+%_per_additional_melee_range", 8 },
	},
	stats = {
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { attackSpeedMultiplier = 200, baseMultiplier = 0.65, damageEffectiveness = 0.65, levelRequirement = 0, },
	},
}
skills["SummonPhantasmFadingProjectile"] = {
	name = "Physical Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.0221999883652,
	incrementalEffectiveness = 0.048500001430511,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"always_pierce",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, damageEffectiveness = 1.5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["HeraldOfAgonyMinionMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	constantStats = {
		{ "projectile_spread_radius", 20 },
		{ "projectile_minimum_range", 10 },
		{ "base_number_of_projectiles", 6 },
		{ "active_skill_attack_speed_+%_final", -35 },
		{ "main_hand_base_maximum_attack_distance", 50 },
		{ "active_skill_area_of_effect_radius_+%_final", 20 },
	},
	stats = {
		"is_area_damage",
		"base_is_projectile",
		"distribute_projectiles_over_contact_points",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { baseMultiplier = 0.4, cooldown = 7.5, damageEffectiveness = 0.4, levelRequirement = 1, storedUses = 1, },
	},
}
skills["HeraldOfAgonyMinionTailSpike"] = {
	name = "Tail Spike",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.3,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 39 },
		{ "number_of_additional_projectiles", 4 },
	},
	stats = {
		"base_is_projectile",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["HeraldOfAgonyMinionCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 1,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 30 },
	},
	stats = {
		"is_area_damage",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["HeraldOfLightMinionSlam"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -33 },
		{ "active_skill_area_of_effect_radius_+%_final", 100 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["SentinelHolySlam"] = {
	name = "Crusade Slam",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "active_skill_attack_speed_+%_final", -33 },
		{ "active_skill_area_of_effect_radius_+%_final", 100 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 2, cooldown = 5, damageEffectiveness = 2, levelRequirement = 0, storedUses = 1, },
	},
}
skills["RelicTriggeredNova"] = {
	name = "Nova",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.1052000522614,
	incrementalEffectiveness = 0.057900000363588,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "holy_relic_trigger_on_parent_attack_%", 100 },
		{ "base_skill_effect_duration", 4000 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_area_of_effect_radius_+%_final",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -24, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 4, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[2] = { 0.80000001192093, 1.2000000476837, -23, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 6, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[3] = { 0.80000001192093, 1.2000000476837, -22, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 9, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[4] = { 0.80000001192093, 1.2000000476837, -20, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 12, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[5] = { 0.80000001192093, 1.2000000476837, -19, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 16, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[6] = { 0.80000001192093, 1.2000000476837, -18, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 20, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[7] = { 0.80000001192093, 1.2000000476837, -17, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 24, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[8] = { 0.80000001192093, 1.2000000476837, -15, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 28, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[9] = { 0.80000001192093, 1.2000000476837, -14, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 32, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[10] = { 0.80000001192093, 1.2000000476837, -13, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 36, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[11] = { 0.80000001192093, 1.2000000476837, -12, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 40, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[12] = { 0.80000001192093, 1.2000000476837, -10, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 44, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[13] = { 0.80000001192093, 1.2000000476837, -9, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 48, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[14] = { 0.80000001192093, 1.2000000476837, -8, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 52, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[15] = { 0.80000001192093, 1.2000000476837, -7, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 55, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[16] = { 0.80000001192093, 1.2000000476837, -5, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 58, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[17] = { 0.80000001192093, 1.2000000476837, -4, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 61, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[18] = { 0.80000001192093, 1.2000000476837, -3, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 64, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[19] = { 0.80000001192093, 1.2000000476837, -2, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 67, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[20] = { 0.80000001192093, 1.2000000476837, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 70, storedUses = 1, statInterpolation = { 3, 3, }, },
		[21] = { 0.80000001192093, 1.2000000476837, 1, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 72, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[22] = { 0.80000001192093, 1.2000000476837, 3, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 74, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[23] = { 0.80000001192093, 1.2000000476837, 4, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 76, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[24] = { 0.80000001192093, 1.2000000476837, 6, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 78, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[25] = { 0.80000001192093, 1.2000000476837, 7, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 80, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[26] = { 0.80000001192093, 1.2000000476837, 9, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 82, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[27] = { 0.80000001192093, 1.2000000476837, 10, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 84, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[28] = { 0.80000001192093, 1.2000000476837, 12, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 86, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[29] = { 0.80000001192093, 1.2000000476837, 13, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 88, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[30] = { 0.80000001192093, 1.2000000476837, 15, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 90, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[31] = { 0.80000001192093, 1.2000000476837, 16, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 91, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[32] = { 0.80000001192093, 1.2000000476837, 18, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 92, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[33] = { 0.80000001192093, 1.2000000476837, 19, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 93, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[34] = { 0.80000001192093, 1.2000000476837, 21, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 94, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[35] = { 0.80000001192093, 1.2000000476837, 22, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 95, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[36] = { 0.80000001192093, 1.2000000476837, 24, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 96, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[37] = { 0.80000001192093, 1.2000000476837, 25, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 97, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[38] = { 0.80000001192093, 1.2000000476837, 27, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 98, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[39] = { 0.80000001192093, 1.2000000476837, 28, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 99, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
		[40] = { 0.80000001192093, 1.2000000476837, 30, cooldown = 0.3, critChance = 5, damageEffectiveness = 2.5, levelRequirement = 100, storedUses = 1, statInterpolation = { 3, 3, 1, }, },
	},
}
skills["DominatingBlowMinionCharge"] = {
	name = "Shield Charge",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Charges at a targeted location or enemy, pushing away enemies in your path and repeatedly dealing damage in a small area in front of you. You deal damage in a larger area when you reach the target. The further you travel, the more damage you deal, and the greater your chance of stunning enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RequiresShield] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "shield_charge_scaling_stun_threshold_reduction_+%_at_maximum_range", 25 },
		{ "base_movement_velocity_+%", 400 },
		{ "shield_charge_damage_+%_maximum", 30 },
		{ "active_skill_area_of_effect_radius_+%_final", -40 },
	},
	stats = {
		"ignores_proximity_shield",
		"global_cannot_crit",
	},
	levels = {
		[1] = { cooldown = 4, levelRequirement = 1, storedUses = 1, },
	},
}
skills["VaalDominationMelee"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
	},
	levels = {
		[1] = { attackSpeedMultiplier = -72, baseMultiplier = 3, damageEffectiveness = 3, levelRequirement = 1, },
	},
}
skills["VaalDominationSunder"] = {
	name = "Sunder",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "shockwave_slam_explosion_damage_+%_final", -60 },
		{ "old_sunder_additional_width_per_stage", 1 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 2.7, damageEffectiveness = 2.7, levelRequirement = 1, },
	},
}
skills["GAVaalDominationLargeSlam"] = {
	name = "AoE Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	constantStats = {
		{ "melee_range_+", 15 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -77, baseMultiplier = 3.5, cooldown = 7, damageEffectiveness = 3.5, levelRequirement = 0, storedUses = 1, },
	},
}
skills["AbsolutionMinion"] = {
	name = "Absolution",
	hidden = true,
	color = 1,
	baseEffectiveness = 1.9819999933243,
	incrementalEffectiveness = 0.045299999415874,
	description = "Damages enemies in an area, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the corpse will be consumed to summon a Sentinel of Absolution for a secondary duration, or to refresh the duration and life of an existing one instead if you have the maximum number of them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "minion_spell_damage_skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		area = true,
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "active_skill_area_of_effect_radius_+%_final", -25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 12, statInterpolation = { 3, 3, }, },
	},
}
skills["AbsolutionMinionEmpowered"] = {
	name = "Empowered Absolution",
	hidden = true,
	color = 1,
	baseEffectiveness = 1.4865000247955,
	incrementalEffectiveness = 0.045299999415874,
	description = "Damages enemies in an area, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the corpse will be consumed to summon a Sentinel of Absolution for a secondary duration, or to refresh the duration and life of an existing one instead if you have the maximum number of them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "minion_spell_damage_skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		area = true,
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -50 },
		{ "absolution_blast_shockwave_every_x_beams", 1 },
		{ "active_skill_area_of_effect_radius_+%_final", -25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, critChance = 6, damageEffectiveness = 1.3, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["AbsolutionMinionVaal"] = {
	name = "Absolution",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.92720001935959,
	incrementalEffectiveness = 0.045299999415874,
	description = "Damages enemies in an area, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the corpse will be consumed to summon a Sentinel of Absolution for a secondary duration, or to refresh the duration and life of an existing one instead if you have the maximum number of them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "minion_spell_damage_skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		area = true,
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", -35 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 1.8, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["AbsolutionMinionVaalCascade"] = {
	name = "Absolution Cascade",
	hidden = true,
	color = 1,
	baseEffectiveness = 1.4026999473572,
	incrementalEffectiveness = 0.045299999415874,
	description = "Damages enemies in an area, applying a debuff for a short duration. If a non-unique enemy dies while affected by the debuff, the corpse will be consumed to summon a Sentinel of Absolution for a secondary duration, or to refresh the duration and life of an existing one instead if you have the maximum number of them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.Physical] = true, [SkillType.Lightning] = true, [SkillType.MinionsCanExplode] = true, [SkillType.CreatesMinion] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Cascadable] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "minion_spell_damage_skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		area = true,
		spell = true,
		duration = true,
	},
	constantStats = {
		{ "support_spell_cascade_number_of_cascades_per_side", 1 },
		{ "active_skill_area_of_effect_radius_+%_final", -25 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"support_spell_cascade_sideways",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 6, damageEffectiveness = 2.4, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}
skills["VaalAbsolutionDelayedBlast"] = {
	name = "AoE Blast",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.1199998855591,
	incrementalEffectiveness = 0.045299999415874,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		area = true,
		spell = true,
	},
	constantStats = {
		{ "active_skill_area_of_effect_+%_final", 300 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 6, critChance = 6, damageEffectiveness = 3.2, levelRequirement = 0, storedUses = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SummonedRhoaShieldCharge"] = {
	name = "Shield Charge",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Charges at a targeted location or enemy, pushing away enemies in your path and repeatedly dealing damage in a small area in front of you. You deal damage in a larger area when you reach the target. The further you travel, the more damage you deal, and the greater your chance of stunning enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RequiresShield] = true, [SkillType.Melee] = true, [SkillType.Area] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Dagger"] = true,
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "shield_charge_scaling_stun_threshold_reduction_+%_at_maximum_range", 50 },
		{ "base_movement_velocity_+%", 100 },
		{ "shield_charge_damage_+%_maximum", 10 },
		{ "attack_speed_+%", 20 },
		{ "physical_damage_%_to_add_as_lightning", 15 },
	},
	stats = {
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { cooldown = 3, levelRequirement = 1, storedUses = 1, },
	},
}
skills["SummonedSnakeProjectile"] = {
	name = "Chaos Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 1 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["DropBearSummonedGroundSlam"] = {
	name = "Ground Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "The character slams the ground in front of them with a Staff, Mace or Sceptre, creating a wave that travels forward and damages enemies with an increased chance to stun.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Two Handed Mace"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { cooldown = 3, levelRequirement = 1, storedUses = 1, },
	},
}
skills["DropBearSummonedRallyingCry"] = {
	name = "[DNT] Old Rallying Cry",
	hidden = true,
	color = 1,
	description = "[DNT] Unused (replaced)",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.25,
	statMap = {
		["damage_+%"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("buffAllies", true),
	},
	constantStats = {
		{ "damage_+%", 25 },
		{ "base_skill_effect_duration", 4000 },
		{ "base_mana_regeneration_rate_per_minute", 888 },
		{ "active_skill_area_of_effect_radius_+%_final", -25 },
	},
	stats = {
		"base_deal_no_attack_damage",
		"base_deal_no_spell_damage",
		"base_deal_no_secondary_damage",
	},
	levels = {
		[1] = { cooldown = 5, levelRequirement = 1, storedUses = 1, },
	},
}
skills["BoneGolemMultiAttack"] = {
	name = "Combo Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["bone_golem_attack_speed_+%_final_after_third_combo_index"] = {
			mod("Speed", "MORE", nil, 0, KeywordFlag.Attack),
			div = 1.5,
		},
		["bone_golem_damage_+%_final_after_third_combo_index"] = {
			mod("Damage", "MORE", nil),
			div = 1.5,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "bone_golem_attack_speed_+%_final_after_third_combo_index", 200 },
		{ "bone_golem_damage_+%_final_after_third_combo_index", 20 },
	},
	stats = {
	},
	levels = {
		[1] = { baseMultiplier = 1.6, damageEffectiveness = 1.6, levelRequirement = 1, },
	},
}
skills["BoneGolemCascade"] = {
	name = "Cascade",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 4 },
		{ "active_skill_base_radius_+", 1 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -10, baseMultiplier = 0.65, cooldown = 6, damageEffectiveness = 0.65, levelRequirement = 1, storedUses = 1, },
	},
}
skills["BoneGolemLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump through the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "active_skill_area_of_effect_radius_+%_final", 30 },
		{ "active_skill_base_area_of_effect_radius", 15 },
	},
	stats = {
		"is_area_damage",
		"disable_attack_repeats",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -44, baseMultiplier = 2.25, cooldown = 4, damageEffectiveness = 2.25, levelRequirement = 1, storedUses = 1, },
	},
}
skills["EGBoneGolemConsumeCorpse"] = {
	name = "Consume Corpse",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
	},
	constantStats = {
		{ "spell_maximum_action_distance_+%", -90 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 5, levelRequirement = 0, storedUses = 1, },
	},
}
skills["BoneGolemCascadeEmpowered"] = {
	name = "Empowered Cascade",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	constantStats = {
		{ "upheaval_number_of_spikes", 4 },
		{ "active_skill_area_of_effect_+%_final", 100 },
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -10, baseMultiplier = 2.3, damageEffectiveness = 2.3, levelRequirement = 1, },
	},
}
skills["SkitterbotWait"] = {
	name = "Skitterbot Wait",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		duration = true,
	},
	constantStats = {
		{ "base_skill_effect_duration", 200 },
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["MinionInstability"] = {
	name = "Minion Instability",
	hidden = true,
	color = 4,
	baseFlags = {
		cast = true,
		area = true,
		fire = true,
	},
	skillTypes = { [SkillType.Damage] = true, [SkillType.Area] = true },
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = 1 / (activeSkill.summonSkill.skillData.summonSpeed or 1)
	end,
	baseMods = {
		skill("FireMin", 1, { type = "PerStat", stat = "Life", div = 1/.33 }),
		skill("FireMax", 1, { type = "PerStat", stat = "Life", div = 1/.33 }),
		skill("showAverage", true),
		skill("radius", 22),
	},
	stats = {
	},
	levelMods = {
	},
	levels = {
		[1] = { cost = { } },
	},
}
skills["SiegebreakerCausticGround"] = {
	name = "Caustic Ground",
	hidden = true,
	color = 4,
	baseFlags = {
		area = true,
		duration = true,
	},
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, },
	baseMods = {
		skill("ChaosDot", 1, { type = "PercentStat", stat = "Life", percentVar = "SiegebreakerCausticGroundPercent" }),
		skill("dotIsArea", true),
		flag("dotIsCausticGround"),
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cost = { } },
	},
}
skills["ReplicaSiegebreakerBurningGround"] = {
	name = "Burning Ground",
	hidden = true,
	color = 4,
	baseFlags = {
		area = true,
		duration = true,
	},
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, [SkillType.CausesBurning] = true, },
	baseMods = {
		skill("FireDot", 1, { type = "PercentStat", stat = "Life", percentVar = "SiegebreakerBurningGroundPercent" }),
		skill("dotIsArea", true),
		flag("dotIsBurningGround"),
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cost = { } },
	},
}
skills["InfernalLegion"] = {
	name = "Infernal Legion",
	hidden = true,
	color = 4,
	baseFlags = {
		spell = true,
		area = true,
	},
	skillTypes = { [SkillType.DamageOverTime] = true, [SkillType.CausesBurning] = true },
	baseMods = {
		skill("FireDot", 1, { type = "Multiplier", var = "InfernalLegionBaseDamage" }),
		skill("dotIsArea", true),
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cost = { } },
	},
}

skills["GuardianSentinelFireAura"] = {
	name = "Burning Aura",
	hidden = true,
	color = 4,
	baseFlags = {
		spell = true,
		area = true,
	},
	skillTypes = { [SkillType.DamageOverTime] = true, [SkillType.CausesBurning] = true },
	baseMods = {
		skill("FireDot", 1, { type = "Multiplier", var = "GuardianSentinelFireAuraBaseDamage" }, { type = "PercentStat", stat = "Life", percent = 1}),
		skill("dotIsArea", true),
		skill("radius", 1, { type = "Multiplier", var = "GuardianSentinelFireAuraRadius" }),
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cost = { } },
	},
}

skills["MeleeAtAnimationSpeedUnique"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -25, levelRequirement = 1, },
	},
}
skills["SummonedReaperMelee"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	stats = {
		"active_skill_damage_+%_final",
		"action_attack_or_cast_time_uses_animation_length",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 1, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 28, statInterpolation = { 2, }, },
		[2] = { 60, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 80, statInterpolation = { 2, }, },
	},
}
skills["SummonedReaperUltimate"] = {
	name = "Ultimate",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Movement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 1, baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 28, statInterpolation = { 2, }, },
		[2] = { 60, baseMultiplier = 1.65, damageEffectiveness = 1.65, levelRequirement = 80, statInterpolation = { 2, }, },
	},
}
skills["GASummonReaperUltimateLeftSlash"] = {
	name = "Ultimate Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 1, baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 28, statInterpolation = { 2, }, },
		[2] = { 60, baseMultiplier = 1.5, damageEffectiveness = 1.5, levelRequirement = 80, statInterpolation = { 2, }, },
	},
}
skills["GASummonReaperComboWhirl"] = {
	name = "Whirl",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 1, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 28, statInterpolation = { 2, }, },
		[2] = { 60, baseMultiplier = 0.5, damageEffectiveness = 0.5, levelRequirement = 80, statInterpolation = { 2, }, },
	},
}
skills["GASummonReaperComboLeftSlash"] = {
	name = "Combo Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	notMinionStat = {
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 1, levelRequirement = 28, statInterpolation = { 2, }, },
		[2] = { 60, levelRequirement = 80, statInterpolation = { 2, }, },
	},
}
skills["ReaperConsumeMinionForBuff"] = {
	name = "Consume",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
	},
	baseMods = {
		mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", 40) }, 0, 0, { type = "SkillName", skillName = "Summon Reaper", includeTransfigured = true }, { type = "GlobalEffect", effectType = "Buff" }),
		mod("MinionModifier", "LIST", { mod = mod("MovementSpeed", "INC", 40) }, 0, 0, { type = "SkillName", skillName = "Summon Reaper", includeTransfigured = true }, { type = "GlobalEffect", effectType = "Buff" }),
		mod("MinionModifier", "LIST", { mod = mod("AreaOfEffect", "INC", 30) }, 0, 0, { type = "SkillName", skillName = "Summon Reaper", includeTransfigured = true }, { type = "GlobalEffect", effectType = "Buff" }),
		skill("buffAllies", true),
	},
	constantStats = {
		{ "base_skill_effect_duration", 6000 },
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 25, levelRequirement = 0, storedUses = 1, },
	},
}
skills["MPWExpeditionSummonedArbalestProjectile"] = {
	name = "Projectile Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 145 },
	},
	stats = {
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["BlinkMirrorArrowMelee"] = {
	name = "Projectile Attack",
	hidden = true,
	color = 4,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { baseMultiplier = 1.75, damageEffectiveness = 1.75, levelRequirement = 0, },
	},
}
skills["RainOfArrowsCloneShot"] = {
	name = "Rain of Arrow",
	hidden = true,
	color = 2,
	description = "Fires multiple arrows into the air, to land in sequence after a delay, starting at the targeted location and spreading outwards in all directions. Each arrow deals damage in an area around it. Half of the arrows will land directly on targets if there are targets in their range.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 10),
		flag("OneShotProj"),
	},
	constantStats = {
		{ "number_of_additional_arrows", 10 },
	},
	stats = {
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
		"cannot_pierce",
	},
	levels = {
		[1] = { levelRequirement = 0, },
	},
}
skills["ElementalHitCloneShot"] = {
	name = "Elemental Hit",
	hidden = true,
	color = 2,
	description = "Each attack with this skill will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.RandomElement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	constantStats = {
		{ "chance_to_freeze_shock_ignite_%", 20 },
		{ "active_skill_base_area_of_effect_radius", 10 },
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { baseMultiplier = 5.4, damageEffectiveness = 5.4, levelRequirement = 0, },
	},
}
skills["SumonRagingSpiritMelee"] = {
	name = "Melee",
	hidden = true,
	color = 4,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 1, },
	},
}
skills["AnimateGuardianSmite"] = {
	name = "Smite",
	hidden = true,
	color = 4,
	description = "Performs a melee attack, and causes lightning to strike a nearby enemy, dealing damage in an area. Each target can only be hit once by this skill. Hitting an enemy grants an aura for a duration. Requires a Sword, Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Melee] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Multistrikeable] = true, [SkillType.Damage] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Aura] = true, [SkillType.Buff] = true, [SkillType.Lightning] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Axe"] = true,
		["One Handed Mace"] = true,
		["One Handed Sword"] = true,
		["Sceptre"] = true,
		["Staff"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	constantStats = {
		{ "skill_physical_damage_%_to_convert_to_lightning", 50 },
		{ "smite_lightning_target_range", 20 },
		{ "base_smite_number_of_targets", 3 },
		{ "smite_lightning_target_range", 50 },
		{ "active_skill_base_area_of_effect_radius", 15 },
		{ "active_skill_base_secondary_area_of_effect_radius", 36 },
		{ "active_skill_secondary_area_of_effect_description_mode", 4 },
	},
	stats = {
		"visual_hit_effect_elemental_is_holy",
	},
	levels = {
		[1] = { baseMultiplier = 3.25, damageEffectiveness = 3.25, levelRequirement = 1, },
	},
}
skills["ElderTentacleMinionProjectileDeepcaller"] = {
	name = "Projectile Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.041000001132488,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 44 },
		{ "skill_visual_scale_+%", 50 },
		{ "base_chance_to_shock_%", 60 },
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	notMinionStat = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, },
	},
}
skills["SummonedLivingLightningZap"] = {
	name = "Living Lightning Zap",
	hidden = true,
	color = 4,
	description = "Jolt through an enemy, causing chaining Lightning Damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Lightning] = true, [SkillType.Chains] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	constantStats = {
		{ "additional_base_critical_strike_chance", 800 },
	},
	stats = {
		"supress_weapon_surges",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 0, storedUses = 1, },
	},
}
skills["MPSPhantasmBasicBlood"] = {
	name = "Projectile Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.1059999465942,
	incrementalEffectiveness = 0.035999998450279,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	constantStats = {
		{ "monster_projectile_variation", 248 },
		{ "spell_maximum_action_distance_+%", -40 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"maintain_projectile_direction_when_using_contact_position",
		"base_is_projectile",
	},
	notMinionStat = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 0, statInterpolation = { 3, 3, }, },
	},
}