-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Minion Data
-- Monster data (c) Grinding Gear Games
--
local minions, mod = ...

minions["RaisedZombie"] = {
	name = "Raised Zombie",
	monsterTags = { "animal_claw_weapon", "fast_movement", "flesh_armour", "is_unarmed", "medium_height", "melee", "physical_affinity", "red_blood", "undead", "zombie", },
	life = 3.75,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.65,
	damageSpread = 0.4,
	attackTime = 1.17,
	attackRange = 11,
	accuracy = 3.4,
	limit = "ActiveZombieLimit",
	skillList = {
		"Melee",
		"ZombieSlam",
		"GAZombieCorpseGroundImpact",
	},
	modList = {
		mod("Armour", "INC", 40, 0, 0), -- MonsterImplicitDamageReduction1 [physical_damage_reduction_rating_+% = 40]
		mod("StunThreshold", "INC", 30, 0, 0), -- RaiseZombieStunThreshold [stun_threshold_+% = 30]
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["SummonedChaosGolem"] = {
	name = "Chaos Golem",
	monsterTags = { "bludgeoning_weapon", "caster", "chaos_affinity", "construct", "fast_movement", "ghost_blood", "is_unarmed", "large_model", "medium_height", "melee", "not_dex", "physical_affinity", "stone_armour", },
	life = 6.9,
	energyShield = 0.2,
	armour = 0.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 60,
	damage = 2.9,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 8,
	accuracy = 3.4,
	limit = "ActiveGolemLimit",
	skillList = {
		"Melee",
		"SandstormChaosElementalSummoned",
		"ChaosElementalCascadeSummoned",
		"SandstormChaosElementalSummonedEmpowered",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		mod("LifeRegenPercent", "BASE", 1, 0, 0), -- SummonedGolemLifeRegeneration [life_regeneration_rate_per_minute_% = 60]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
	},
}

minions["SummonedFlameGolem"] = {
	name = "Flame Golem",
	monsterTags = { "bludgeoning_weapon", "caster", "construct", "fast_movement", "fire_affinity", "is_unarmed", "mud_blood", "not_dex", "not_str", "ranged", "small_height", "stone_armour", },
	life = 5.82,
	energyShield = 0.4,
	fireResist = 70,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.5,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 6,
	accuracy = 3.4,
	damageFixup = 0.22,
	limit = "ActiveGolemLimit",
	skillList = {
		"FireElementalFlameRedSummoned",
		"FireElementalConeSummoned",
		"FireElementalMortarSummoned",
		"FireElementalMeteorSummoned",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- MonsterSpeedAndDamageFixupLarge [monster_base_type_attack_cast_speed_+%_and_damage_-%_final = 22]
		mod("LifeRegenPercent", "BASE", 1, 0, 0), -- SummonedGolemLifeRegeneration [life_regeneration_rate_per_minute_% = 60]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
	},
}

minions["SummonedIceGolem"] = {
	name = "Ice Golem",
	monsterTags = { "caster", "cold_affinity", "construct", "fast_movement", "hard_armour", "is_unarmed", "medium_height", "melee", "not_dex", "not_str", "physical_affinity", "ranged", "slashing_weapon", "water", },
	life = 5.82,
	energyShield = 0.4,
	fireResist = 40,
	coldResist = 70,
	lightningResist = 40,
	chaosResist = 20,
	damage = 3.06,
	damageSpread = 0.2,
	attackTime = 0.85,
	attackRange = 6,
	accuracy = 3.4,
	limit = "ActiveGolemLimit",
	skillList = {
		"Melee",
		"IceElementalIceCyclone",
		"IceElementalSpearSummoned",
		"IceElementalSpearSummonedDeathNova",
		"DeathExplodeIceElementalSummoned",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		mod("LifeRegenPercent", "BASE", 1, 0, 0), -- SummonedGolemLifeRegeneration [life_regeneration_rate_per_minute_% = 60]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
	},
}

minions["SummonedLightningGolem"] = {
	name = "Lightning Golem",
	monsterTags = { "aura_bearer", "bludgeoning_weapon", "caster", "construct", "fast_movement", "is_unarmed", "large_model", "lightning_affinity", "mud_blood", "not_dex", "not_str", "ranged", "small_height", "stone_armour", },
	life = 5.82,
	energyShield = 0.2,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 70,
	chaosResist = 20,
	damage = 1.5,
	damageSpread = 0.2,
	attackTime = 1.17,
	attackRange = 8,
	accuracy = 3.4,
	damageFixup = 0.22,
	limit = "ActiveGolemLimit",
	skillList = {
		"LightningGolemArcSummoned",
		"LightningGolemWrath",
		"MonsterProjectileSpellLightningGolemSummoned",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- MonsterSpeedAndDamageFixupLarge [monster_base_type_attack_cast_speed_+%_and_damage_-%_final = 22]
		mod("LifeRegenPercent", "BASE", 1, 0, 0), -- SummonedGolemLifeRegeneration [life_regeneration_rate_per_minute_% = 60]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
	},
}

minions["SummonedStoneGolem"] = {
	name = "Stone Golem",
	monsterTags = { "bludgeoning_weapon", "construct", "fast_movement", "has_one_hand_sword", "has_one_handed_melee", "medium_height", "melee", "mud_blood", "not_int", "physical_affinity", "stone_armour", },
	life = 7.25,
	armour = 1,
	evasion = 0.4,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.7,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 10,
	accuracy = 3.4,
	weaponType1 = "One Handed Sword",
	limit = "ActiveGolemLimit",
	skillList = {
		"Melee",
		"RockGolemSlam",
		"RockGolemMinionWhirlingBlades",
	},
	modList = {
		mod("LifeRegenPercent", "BASE", 2, 0, 0), -- SummonedGolemLifeRegenerationStone [life_regeneration_rate_per_minute_% = 120]
	},
}

minions["SummonedRagingSpirit"] = {
	name = "Raging Spirit",
	monsterTags = { "bone_armour", "construct", "extra_extra_small_height", "fast_movement", "is_unarmed", "melee", "physical_affinity", "skeleton", "undead", },
	life = 2.16,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.02,
	damageSpread = 0.2,
	attackTime = 0.57,
	attackRange = 8,
	accuracy = 3.4,
	limit = "ActiveRagingSpiritLimit",
	skillList = {
		"SumonRagingSpiritMelee",
	},
	modList = {
		mod("PhysicalDamageConvertToFire", "BASE", 100, 0, 0), -- RagingSpiritConvertPhysToFire [base_physical_damage_%_to_convert_to_fire = 100]
		mod("PhysicalMin", "BASE", 4, 0, 65536), -- RagingSpiritAddedPhys [attack_minimum_added_physical_damage = 4]
		mod("PhysicalMax", "BASE", 5, 0, 65536), -- RagingSpiritAddedPhys [attack_maximum_added_physical_damage = 5]
		-- CannotGainAfflictedMods [cannot_have_affliction_mods = 1]
		mod("Speed", "MORE", 40, 1, 0), -- MonsterSummonedSkullFastAttack1 [active_skill_attack_speed_+%_final = 40]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
	},
}

minions["SummonedEssenceSpirit"] = {
	name = "Essence Spirit",
	monsterTags = { "bone_armour", "construct", "extra_extra_small_height", "fast_movement", "has_claw", "has_one_handed_melee", "melee", "physical_affinity", "skeleton", "undead", },
	life = 2.25,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.28,
	damageSpread = 0.2,
	attackTime = 0.57,
	attackRange = 8,
	accuracy = 3.4,
	skillList = {
		"RagingSpiritMeleeAttack",
		"SpectralSkullShieldCharge",
	},
	modList = {
		mod("Speed", "MORE", 40, 1, 0), -- MonsterSummonedSkullFastAttack1 [active_skill_attack_speed_+%_final = 40]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
		-- set_projectiles_always_pierce_you [set_projectiles_always_pierce_you = 1]
		mod("Condition:FullLife", "FLAG", true),
	},
}

minions["SummonedSpectralWolf"] = {
	name = "Spectral Wolf Companion",
	monsterTags = { "animal_claw_weapon", "beast", "canine_beast", "fast_movement", "ghost", "has_dagger", "has_one_handed_melee", "light_armour", "mammal_beast", "melee", "physical_affinity", "red_blood", "undead", },
	life = 11,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 6.2,
	damageSpread = 0.2,
	attackTime = 1.5,
	attackRange = 11,
	accuracy = 3.4,
	weaponType1 = "Dagger",
	limit = "ActiveWolfLimit",
	skillList = {
		"MeleeAtAnimationSpeed",
	},
	modList = {
		mod("PhysicalDamageLifeLeech", "BASE", 100, 1, 0), -- SummonedWolfLifeLeech [life_leech_from_physical_attack_damage_permyriad = 10000]
	},
}

minions["SummonedSpectralTiger"] = {
	name = "Spectral Tiger Companion",
	monsterTags = { "animal_claw_weapon", "beast", "fast_movement", "feline_beast", "ghost", "has_dagger", "has_one_handed_melee", "light_armour", "mammal_beast", "melee", "physical_affinity", "red_blood", "undead", },
	life = 24.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 24.5,
	damageSpread = 0.2,
	attackTime = 1.5,
	attackRange = 11,
	accuracy = 3.4,
	weaponType1 = "Dagger",
	limit = "ActiveTigerLimit",
	skillList = {
		"MeleeAtAnimationSpeed",
	},
	modList = {
		mod("PhysicalDamageLifeLeech", "BASE", 100, 1, 0), -- SummonedWolfLifeLeech [life_leech_from_physical_attack_damage_permyriad = 10000]
	},
}

minions["RaisedSkeleton"] = {
	name = "Summoned Skeleton",
	monsterTags = { "bone_armour", "bones", "has_one_hand_sword", "has_one_handed_melee", "humanoid", "medium_height", "melee", "physical_affinity", "skeleton", "slashing_weapon", "slow_movement", "undead", },
	life = 1.05,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.45,
	damageSpread = 0.4,
	attackTime = 0.8,
	attackRange = 8,
	accuracy = 3.4,
	weaponType1 = "One Handed Sword",
	weaponType2 = "Shield",
	limit = "ActiveSkeletonLimit",
	skillList = {
		"Melee",
		"MonsterQuickDodgeRunUnarmed",
	},
	modList = {
		mod("BlockChance", "BASE", 30, 0, 0), -- MonsterAttackBlock30Bypass15 [monster_base_block_% = 30]
		mod("BlockEffect", "BASE", 15, 0, 0), -- MonsterAttackBlock30Bypass15 [base_block_%_damage_taken = 15]
		-- SummonSkeletonsSkeletonIsWarrior [summoned_skeleton_is_warrior = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["RaisedSkeletonCaster"] = {
	name = "Summoned Skeleton Caster",
	monsterTags = { "bone_armour", "bones", "caster", "cold_affinity", "humanoid", "is_unarmed", "medium_height", "not_dex", "not_str", "ranged", "skeleton", "slashing_weapon", "undead", "very_slow_movement", },
	life = 1.05,
	energyShield = 0.4,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0.98,
	damageSpread = 0.3,
	attackTime = 1.07,
	attackRange = 46,
	accuracy = 3.4,
	limit = "ActiveSkeletonLimit",
	skillList = {
		"SkeletonMinionProjectileCold",
		"SkeletonMinionProjectileFire",
		"SkeletonMinionProjectileLightning",
	},
	modList = {
		-- SummonSkeletonsSkeletonIsMage [summoned_skeleton_is_mage = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["RaisedSkeletonMeleeVaal"] = {
	name = "Summoned Skeleton Soldier",
	monsterTags = { "bone_armour", "bones", "has_one_hand_sword", "has_one_handed_melee", "humanoid", "medium_height", "melee", "not_dex", "not_int", "physical_affinity", "skeleton", "slashing_weapon", "slow_movement", "undead", },
	life = 1.05,
	armour = 0.25,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.37,
	damageSpread = 0.4,
	attackTime = 0.8,
	attackRange = 8,
	accuracy = 3.4,
	weaponType1 = "One Handed Sword",
	weaponType2 = "Shield",
	limit = "ActiveSkeletonLimit",
	skillList = {
		"Melee",
	},
	modList = {
		mod("BlockChance", "BASE", 30, 0, 0), -- MonsterAttackBlock30Bypass15 [monster_base_block_% = 30]
		mod("BlockEffect", "BASE", 15, 0, 0), -- MonsterAttackBlock30Bypass15 [base_block_%_damage_taken = 15]
		-- SummonSkeletonsSkeletonIsWarrior [summoned_skeleton_is_warrior = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["RaisedSkeletonArcherVaal"] = {
	name = "Summoned Skeleton Archer",
	monsterTags = { "bone_armour", "bones", "has_bow", "humanoid", "medium_height", "not_int", "not_str", "physical_affinity", "puncturing_weapon", "ranged", "skeleton", "undead", "very_slow_movement", },
	life = 1.05,
	evasion = 0.25,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0.98,
	damageSpread = 0.16,
	attackTime = 1.33,
	attackRange = 40,
	accuracy = 3.4,
	weaponType1 = "Bow",
	limit = "ActiveSkeletonLimit",
	skillList = {
		"Melee",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["RaisedSkeletonArcher"] = {
	name = "Summoned Skeleton Archer",
	monsterTags = { "bone_armour", "bones", "has_bow", "humanoid", "not_int", "not_str", "physical_affinity", "puncturing_weapon", "ranged", "skeleton", "undead", "very_slow_movement", },
	life = 1.05,
	evasion = 0.25,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.25,
	damageSpread = 0.16,
	attackTime = 1.33,
	attackRange = 60,
	accuracy = 3.4,
	weaponType1 = "Bow",
	limit = "ActiveSkeletonLimit",
	skillList = {
		"Melee",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["Clone"] = {
	name = "Clone",
	monsterTags = { "construct", "fast_movement", "flesh_armour", "is_unarmed", "medium_height", "melee", "physical_affinity", "red_blood", "slashing_weapon", },
	life = 1,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 0.83,
	attackRange = 6,
	accuracy = 3.4,
	skillList = {
		"Melee",
	},
	modList = {
		mod("EnergyShield", "BASE", 10, 0, 0), -- MirrorArrowEnergyShield [base_maximum_energy_shield = 10]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_is_double [set_is_double = 1]
		-- set_suppress_mod_stat_display [set_suppress_mod_stat_display = 1]
		mod("EnergyShieldRecharge", "OVERRIDE", 0, 0, 0), -- set_energy_shield_recharge_rate_per_minute_% [set_energy_shield_recharge_rate_per_minute_% = 0]
		mod("DamageTaken", "MORE", -80, 0, 0), -- monster_inherent_damage_taken_+%_final [monster_inherent_damage_taken_+%_final = -80]
	},
}

minions["ArrowClone"] = {
	name = "Clone",
	monsterTags = { "construct", "fast_movement", "flesh_armour", "is_unarmed", "medium_height", "melee", "physical_affinity", "red_blood", "slashing_weapon", },
	life = 1.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 0.83,
	attackRange = 6,
	accuracy = 3.4,
	skillList = {
		"BlinkMirrorArrowMelee",
	},
	modList = {
		mod("EnergyShield", "BASE", 10, 0, 0), -- MirrorArrowEnergyShield [base_maximum_energy_shield = 10]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_is_double [set_is_double = 1]
		-- set_suppress_mod_stat_display [set_suppress_mod_stat_display = 1]
		mod("EnergyShieldRecharge", "OVERRIDE", 0, 0, 0), -- set_energy_shield_recharge_rate_per_minute_% [set_energy_shield_recharge_rate_per_minute_% = 0]
		mod("DamageTaken", "MORE", -80, 0, 0), -- monster_inherent_damage_taken_+%_final [monster_inherent_damage_taken_+%_final = -80]
	},
}

minions["ArrowCloneRoA"] = {
	name = "Clone",
	monsterTags = { "construct", "fast_movement", "flesh_armour", "is_unarmed", "medium_height", "melee", "physical_affinity", "red_blood", "slashing_weapon", },
	life = 1.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 0.83,
	attackRange = 6,
	accuracy = 3.4,
	skillList = {
		"RainOfArrowsCloneShot",
	},
	modList = {
		mod("EnergyShield", "BASE", 10, 0, 0), -- MirrorArrowEnergyShield [base_maximum_energy_shield = 10]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_is_double [set_is_double = 1]
		-- set_suppress_mod_stat_display [set_suppress_mod_stat_display = 1]
		mod("EnergyShieldRecharge", "OVERRIDE", 0, 0, 0), -- set_energy_shield_recharge_rate_per_minute_% [set_energy_shield_recharge_rate_per_minute_% = 0]
		mod("DamageTaken", "MORE", -80, 0, 0), -- monster_inherent_damage_taken_+%_final [monster_inherent_damage_taken_+%_final = -80]
	},
}

minions["ArrowCloneEle"] = {
	name = "Clone",
	monsterTags = { "construct", "fast_movement", "flesh_armour", "is_unarmed", "medium_height", "melee", "physical_affinity", "red_blood", "slashing_weapon", },
	life = 1.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 0.83,
	attackRange = 6,
	accuracy = 3.4,
	skillList = {
		"ElementalHitCloneShot",
	},
	modList = {
		mod("EnergyShield", "BASE", 10, 0, 0), -- MirrorArrowEnergyShield [base_maximum_energy_shield = 10]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_is_double [set_is_double = 1]
		-- set_suppress_mod_stat_display [set_suppress_mod_stat_display = 1]
		mod("EnergyShieldRecharge", "OVERRIDE", 0, 0, 0), -- set_energy_shield_recharge_rate_per_minute_% [set_energy_shield_recharge_rate_per_minute_% = 0]
		mod("DamageTaken", "MORE", -80, 0, 0), -- monster_inherent_damage_taken_+%_final [monster_inherent_damage_taken_+%_final = -80]
	},
}

minions["SpiderMinion"] = {
	name = "Spider Minion",
	monsterTags = { "animal_claw_weapon", "beast", "chaos_affinity", "extra_extra_small_height", "ghost_armour", "has_one_hand_sword", "has_one_handed_melee", "spider", "very_fast_movement", },
	life = 1.8,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.76,
	damageSpread = 0.2,
	attackTime = 0.96,
	attackRange = 7,
	accuracy = 3.4,
	weaponType1 = "One Handed Sword",
	limit = "ActiveSpiderLimit",
	skillList = {
		"SummonedSpiderViperStrike",
	},
	modList = {
		-- SummonedSpiderPhasing [phase_through_objects = 1]
		-- SummonedSpiderPhasing [suppress_phasing_visual = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- set_is_spider [set_is_spider = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
	},
}

minions["AnimatedWeapon"] = {
	name = "Animated Weapon",
	monsterTags = { "construct", "fast_movement", "ghost_armour", "is_unarmed", "medium_height", "melee", "physical_affinity", },
	life = 4,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 3.4,
	limit = "ActiveAnimatedWeaponLimit",
	skillList = {
		"Melee",
	},
	modList = {
		-- EmergeSpeedLow [emerge_speed_+% = 100]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- minion_does_not_equip_quiver [minion_does_not_equip_quiver = 1]
		-- monster_gets_item_stats [monster_gets_item_stats = 1]
	},
}

minions["AnimatedArmour"] = {
	name = "Animated Guardian",
	monsterTags = { "construct", "extra_extra_small_height", "ghost_armour", "is_unarmed", "medium_movement", "melee", "not_dex", "not_int", "physical_affinity", },
	life = 5,
	armour = 0.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 3.4,
	skillList = {
		"Melee",
		"AnimateGuardianSmite",
	},
	modList = {
		-- LabyrinthArrowTrapDamageTakenAnimateArmour [damage_taken_+%_from_arrow_traps_final = -90]
		mod("Speed", "MORE", 10, 1, 0, { type = "Condition", var = "DualWielding" }), -- dual_wield_inherent_attack_speed_+%_final [dual_wield_inherent_attack_speed_+%_final = 10]
		mod("BlockChance", "BASE", 15, 0, 0, { type = "Condition", var = "DualWielding" }), -- block_while_dual_wielding_% [block_while_dual_wielding_% = 15]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- monster_gets_item_stats [monster_gets_item_stats = 1]
		mod("PhysicalMin", "BASE", 2, 8192, 65536), -- main_hand_local_minimum_added_physical_damage [main_hand_local_minimum_added_physical_damage = 2]
		mod("PhysicalMax", "BASE", 6, 8192, 65536), -- main_hand_local_maximum_added_physical_damage [main_hand_local_maximum_added_physical_damage = 6]
	},
}

minions["IcyRagingSpirit"] = {
	name = "Grave Spirit",
	monsterTags = { "bone_armour", "cleaving_weapon", "construct", "extra_extra_small_height", "fast_movement", "is_unarmed", "melee", "physical_affinity", "skeleton", "undead", },
	life = 3.75,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.5,
	damageSpread = 0.2,
	attackTime = 0.57,
	attackRange = 8,
	accuracy = 3.4,
	skillList = {
		"RagingSpiritMeleeAttack",
	},
	modList = {
		mod("PhysicalDamageConvertToCold", "BASE", 50, 0, 0), -- MonsterSummonedElementalCold [base_physical_damage_%_to_convert_to_cold = 50]
		-- MonsterCannotBeChainedFrom_ [cannot_be_chained_from = 1]
		mod("Speed", "MORE", 40, 1, 0), -- MonsterSummonedSkullFastAttack1 [active_skill_attack_speed_+%_final = 40]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
	},
}

minions["UniqueAnimatedWeapon"] = {
	name = "Dancing Dervish",
	monsterTags = { "construct", "fast_movement", "ghost_armour", "is_unarmed", "medium_height", "physical_affinity", },
	life = 5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 105,
	accuracy = 3.4,
	limit = "ActiveAnimatedWeaponLimit",
	skillList = {
		"Melee",
		"DancingDervishCycloneChannelled",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- minion_does_not_equip_quiver [minion_does_not_equip_quiver = 1]
		mod("DamageTaken", "MORE", -95, 0, 0), -- monster_inherent_damage_taken_+%_final [monster_inherent_damage_taken_+%_final = -95]
		-- monster_gets_item_stats [monster_gets_item_stats = 1]
		mod("Life", "MORE", 698), -- MonsterUnique2,
		mod("Damage", "MORE", 70), -- MonsterUnique5,
		mod("Speed", "MORE", 33, ModFlag.Attack), -- MonsterUnique8,
		mod("Damage", "MORE", -33, ModFlag.Attack), -- MonsterUnique8,
	},
}

minions["SummonedPhantasm"] = {
	name = "Summoned Phantasm",
	monsterTags = { "caster", "flesh_armour", "ghost", "is_unarmed", "medium_movement", "melee", "not_dex", "not_str", "physical_affinity", "ranged", "red_blood", "slashing_weapon", "small_height", "undead", },
	life = 1.58,
	energyShield = 0.2,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.1,
	damageSpread = 0.2,
	attackTime = 1.17,
	attackRange = 6,
	accuracy = 1,
	limit = "ActivePhantasmLimit",
	skillList = {
		"Melee",
		"SummonPhantasmFadingProjectile",
		"SummonPhantasmFadingProjectile2",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_cannot_spawn_support_ghosts [set_cannot_spawn_support_ghosts = 1]
	},
}

minions["HeraldOfAgonySpiderPlated"] = {
	name = "Agony Crawler",
	monsterTags = { "animal_claw_weapon", "beast", "flesh_armour", "has_one_hand_sword", "has_one_handed_melee", "insect", "insect_blood", "medium_height", "melee", "physical_affinity", "very_fast_movement", },
	life = 1.5,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.5,
	damageSpread = 0.2,
	attackTime = 1.3,
	attackRange = 12,
	accuracy = 3.4,
	weaponType1 = "One Handed Sword",
	skillList = {
		"HeraldOfAgonyMinionMortar",
		"HeraldOfAgonyMinionTailSpike",
		"HeraldOfAgonyMinionCleave",
		"Melee",
	},
	modList = {
		mod("PhysicalDamageConvertToChaos", "BASE", 40, 0, 0), -- MonsterConvertToChaosHeraldOfAgony1 [base_physical_damage_%_to_convert_to_chaos = 40]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- MonsterCannotBeDamaged [base_cannot_be_damaged = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_cannot_die [set_cannot_die = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
		mod("Condition:FullLife", "FLAG", true),
	},
}

minions["AxisEliteSoldierHeraldOfLight"] = {
	name = "Sentinel of Purity",
	monsterTags = { "bludgeoning_weapon", "fast_movement", "has_staff", "has_two_handed_melee", "human", "humanoid", "medium_height", "melee", "not_dex", "not_int", "physical_affinity", "plate_armour", "red_blood", },
	life = 3.4,
	armour = 1,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 3.04,
	damageSpread = 0.2,
	attackTime = 0.83,
	attackRange = 12,
	accuracy = 3.4,
	weaponType1 = "Staff",
	limit = "ActiveSentinelOfPurityLimit",
	skillList = {
		"Melee",
		"HeraldOfLightMinionSlam",
		"ChampionTeleport",
		"SentinelHolySlam",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["HolyLivingRelic"] = {
	name = "Holy Relic",
	monsterTags = { "cannot_be_monolith", "caster", "construct", "extra_extra_small_height", "ghost_armour", "is_unarmed", "medium_movement", "not_dex", "not_str", "physical_affinity", "unusable_corpse", },
	life = 6,
	energyShield = 0.6,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	limit = "ActiveHolyRelicLimit",
	skillList = {
		"RelicTriggeredNova",
		"RelicTeleport",
	},
	modList = {
		-- EmergeSpeedHigh [emerge_speed_+% = 0]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- minion_targeting_use_parent_location [minion_targeting_use_parent_location = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- set_cannot_be_afflicted [set_cannot_be_afflicted = 1]
	},
}

minions["AxisEliteSoldierDominatingBlow"] = {
	name = "Sentinel of Dominance",
	monsterTags = { "bludgeoning_weapon", "fast_movement", "has_one_hand_mace", "has_one_handed_melee", "human", "humanoid", "medium_height", "melee", "not_dex", "not_int", "physical_affinity", "plate_armour", },
	life = 4,
	armour = 1,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.8,
	damageSpread = 0.2,
	attackTime = 0.83,
	attackRange = 11,
	accuracy = 3.4,
	weaponType1 = "One Handed Mace",
	weaponType2 = "Shield",
	limit = "ActiveSentinelOfDominanceLimit",
	skillList = {
		"Melee",
		"DominatingBlowMinionCharge",
		"SentinelHolySlam",
	},
	modList = {
		-- MonsterCastsShieldChargeText [monster_casts_shield_charge_text = 1]
		mod("BlockChance", "BASE", 40, 0, 0), -- MonsterAttackBlock40Bypass20 [monster_base_block_% = 40]
		mod("BlockEffect", "BASE", 20, 0, 0), -- MonsterAttackBlock40Bypass20 [base_block_%_damage_taken = 20]
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["AxisEliteSoldierDominatingBlowVaal"] = {
	name = "Ascended Sentinel of Dominance",
	monsterTags = { "bludgeoning_weapon", "has_one_hand_mace", "has_one_handed_melee", "human", "humanoid", "medium_height", "melee", "not_dex", "not_int", "physical_affinity", "plate_armour", "very_slow_movement", },
	life = 4,
	armour = 1,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.8,
	damageSpread = 0.2,
	attackTime = 0.83,
	attackRange = 28,
	accuracy = 3.4,
	limit = "ActiveSentinelOfDominanceLimit",
	skillList = {
		"TeleportVaalDomination",
		"GAVaalDominationTeleportSlam",
		"VaalDominationSunderMelee",
		"VaalDominationSunder",
		"GAVaalDominationLargeSlam",
		"VaalDominationMelee",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Damage", "MORE", 200),
		mod("DamageTaken", "MORE", -70),
	},
}

minions["AbsolutionTemplarJudge"] = {
	name = "Sentinel of Absolution",
	monsterTags = { "bludgeoning_weapon", "caster", "fast_movement", "flesh_armour", "has_one_hand_mace", "has_one_handed_melee", "human", "humanoid", "melee", "not_dex", "not_str", "physical_affinity", "templar", },
	life = 4,
	energyShield = 0.2,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.8,
	damageSpread = 0.2,
	attackTime = 1.17,
	attackRange = 9,
	accuracy = 1,
	weaponType1 = "One Handed Mace",
	limit = "ActiveSentinelOfAbsolutionLimit",
	skillList = {
		"Melee",
		"AbsolutionMinion",
		"AbsolutionMinionEmpowered",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["AbsolutionTemplarJudgeVaal"] = {
	name = "Ascended Sentinel of Absolution",
	monsterTags = { "bludgeoning_weapon", "caster", "fast_movement", "flesh_armour", "has_one_hand_mace", "has_one_handed_melee", "human", "humanoid", "innocence_story", "melee", "not_dex", "not_str", "physical_affinity", "ranged", "templar", },
	life = 4,
	energyShield = 0.2,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.8,
	damageSpread = 0.2,
	attackTime = 1.17,
	attackRange = 9,
	accuracy = 1,
	limit = "ActiveSentinelOfAbsolutionLimit",
	skillList = {
		"AbsolutionMinionVaal",
		"AbsolutionMinionVaalCascade",
		"GTVaalAbsolutionLarge",
		"VaalAbsolutionDelayedBlast",
		"GSVaalAbsolutionEmerge",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Damage", "MORE", 200),
		mod("DamageTaken", "MORE", -70),
	},
}

minions["RhoaUniqueSummoned"] = {
	name = "Summoned Rhoa",
	monsterTags = { "animal_claw_weapon", "avian_beast", "beast", "fast_movement", "has_claw", "has_one_handed_melee", "large_model", "light_armour", "lightning_affinity", "medium_height", "melee", "not_dex", "not_int", "physical_affinity", "red_blood", },
	life = 9,
	armour = 0.25,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 4.28,
	damageSpread = 0.2,
	attackTime = 0.93,
	attackRange = 14,
	accuracy = 3.4,
	limit = "ActiveBeastMinionLimit",
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"SummonedRhoaShieldCharge",
	},
	modList = {
		-- MonsterNearbyEnemiesAreIntimidated [is_intimidated = 1]
		-- MonsterNearbyEnemiesAreIntimidated [local_display_nearby_enemies_are_intimidated = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
	},
}

minions["SnakeSpitUniqueSummoned"] = {
	name = "Summoned Cobra",
	monsterTags = { "beast", "fast_movement", "has_dagger", "has_one_handed_melee", "light_armour", "medium_small_height", "not_int", "not_str", "physical_affinity", "ranged", "red_blood", "reptile_beast", },
	baseDamageIgnoresAttackSpeed = true,
	life = 9,
	evasion = 0.15,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 3.23,
	damageSpread = 0.2,
	attackTime = 1.1,
	attackRange = 9,
	accuracy = 3.4,
	limit = "ActiveBeastMinionLimit",
	skillList = {
		"SummonedSnakeProjectile",
	},
	modList = {
		mod("PhysicalDamageConvertToChaos", "BASE", 30, 0, 0), -- MonsterSnakeChaos [base_physical_damage_%_to_convert_to_chaos = 30]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
	},
}

minions["DropBearUniqueSummoned"] = {
	name = "Summoned Ursa",
	monsterTags = { "animal_claw_weapon", "beast", "extra_small_height", "fast_movement", "has_one_hand_mace", "has_one_handed_melee", "light_armour", "melee", "not_int", "not_str", "physical_affinity", "red_blood", "ursine_beast", },
	baseDamageIgnoresAttackSpeed = true,
	life = 9,
	evasion = 0.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 3.53,
	damageSpread = 0.2,
	attackTime = 1.1,
	attackRange = 10,
	accuracy = 3.4,
	weaponType1 = "One Handed Mace",
	limit = "ActiveBeastMinionLimit",
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"DropBearSummonedGroundSlam",
		"DropBearSummonedRallyingCry",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
	},
}

minions["SummonedCarrionGolem"] = {
	name = "Carrion Golem",
	monsterTags = { "bludgeoning_weapon", "construct", "fast_movement", "golem", "is_unarmed", "large_height", "mud_blood", "not_dex", "not_str", "physical_affinity", "stone_armour", },
	life = 5.82,
	energyShield = 0.4,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0.6,
	damageSpread = 0.2,
	attackTime = 0.9,
	attackRange = 13,
	accuracy = 3.4,
	limit = "ActiveGolemLimit",
	skillList = {
		"BoneGolemMultiAttack",
		"BoneGolemCascade",
		"BoneGolemLeapSlam",
		"EGBoneGolemConsumeCorpse",
		"BoneGolemCascadeEmpowered",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		mod("LifeRegenPercent", "BASE", 1, 0, 0), -- SummonedGolemLifeRegeneration [life_regeneration_rate_per_minute_% = 60]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
	},
}

minions["SkitterbotCold"] = {
	name = "Chilling Skitterbot",
	monsterTags = { "construct", "extra_extra_small_height", "is_unarmed", "non_attacking", "stone_armour", "very_fast_movement", },
	life = 1,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"SkitterbotDetonateMines",
		"SkitterbotWait",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_immune_to_cheats [set_immune_to_cheats = 1]
		-- set_cannot_die [set_cannot_die = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_taunt_enemies [set_cannot_taunt_enemies = 1]
		-- set_untargetable_by_monster_ai [set_untargetable_by_monster_ai = 1]
		mod("StunImmune", "FLAG", 1, 0, 0), -- base_cannot_be_stunned [base_cannot_be_stunned = 1]
		mod("KnockbackImmune", "FLAG", 1, 0, 0), -- cannot_be_knocked_back [cannot_be_knocked_back = 1]
		mod("EnduranceChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_endurance_charges [set_max_endurance_charges = 0]
		mod("FrenzyChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_frenzy_charges [set_max_frenzy_charges = 0]
		mod("PowerChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_power_charges [set_max_power_charges = 0]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
		-- set_cannot_be_splashed_from [set_cannot_be_splashed_from = 1]
	},
}

minions["SkitterbotLightning"] = {
	name = "Shocking Skitterbot",
	monsterTags = { "construct", "extra_extra_small_height", "is_unarmed", "non_attacking", "stone_armour", "very_fast_movement", },
	life = 1,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"SkitterbotDetonateMines",
		"SkitterbotWait",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_immune_to_cheats [set_immune_to_cheats = 1]
		-- set_cannot_die [set_cannot_die = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_taunt_enemies [set_cannot_taunt_enemies = 1]
		-- set_untargetable_by_monster_ai [set_untargetable_by_monster_ai = 1]
		mod("StunImmune", "FLAG", 1, 0, 0), -- base_cannot_be_stunned [base_cannot_be_stunned = 1]
		mod("KnockbackImmune", "FLAG", 1, 0, 0), -- cannot_be_knocked_back [cannot_be_knocked_back = 1]
		mod("EnduranceChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_endurance_charges [set_max_endurance_charges = 0]
		mod("FrenzyChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_frenzy_charges [set_max_frenzy_charges = 0]
		mod("PowerChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_power_charges [set_max_power_charges = 0]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
		-- set_cannot_be_splashed_from [set_cannot_be_splashed_from = 1]
	},
}

minions["SkitterbotFire"] = {
	name = "Scorching Skitterbot",
	monsterTags = { "construct", "extra_extra_small_height", "is_unarmed", "non_attacking", "stone_armour", "very_fast_movement", },
	life = 1,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"SkitterbotDetonateMines",
		"SkitterbotWait",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_immune_to_cheats [set_immune_to_cheats = 1]
		-- set_cannot_die [set_cannot_die = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_taunt_enemies [set_cannot_taunt_enemies = 1]
		-- set_untargetable_by_monster_ai [set_untargetable_by_monster_ai = 1]
		mod("StunImmune", "FLAG", 1, 0, 0), -- base_cannot_be_stunned [base_cannot_be_stunned = 1]
		mod("KnockbackImmune", "FLAG", 1, 0, 0), -- cannot_be_knocked_back [cannot_be_knocked_back = 1]
		mod("EnduranceChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_endurance_charges [set_max_endurance_charges = 0]
		mod("FrenzyChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_frenzy_charges [set_max_frenzy_charges = 0]
		mod("PowerChargesMax", "OVERRIDE", 0, 0, 0), -- set_max_power_charges [set_max_power_charges = 0]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
		-- set_cannot_be_splashed_from [set_cannot_be_splashed_from = 1]
	},
}

minions["SummonedReaper"] = {
	name = "Reaper",
	monsterTags = { "bone_armour", "bones", "fast_movement", "has_dual_wield_melee", "has_one_hand_sword", "has_one_handed_melee", "melee", "not_int", "physical_affinity", "skeleton", "slashing_weapon", "undead", },
	life = 3.74,
	armour = 0.5,
	evasion = 1,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 2.4,
	damageSpread = 0.2,
	attackTime = 1.5,
	attackRange = 13,
	accuracy = 3.4,
	weaponType1 = "One Handed Sword",
	weaponType2 = "One Handed Sword",
	limit = "ActiveReaperLimit",
	skillList = {
		"ReaperConsumeMinionForHeal",
		"ReaperConsumeMinionForBuff",
		"SummonedReaperMelee",
		"SummonedReaperDash",
		"SummonedReaperUltimate",
		"GASummonReaperUltimateLeftSlash",
		"GASummonReaperUltimateRightSlash",
		"EAASummonedReaperComboAttack",
		"GASummonReaperComboWhirl",
		"GASummonReaperComboLeftSlash",
		"GASummonReaperComboRightSlash",
		"GASummonReaperDashImpactSlash",
		"GASummonReaperDash",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

minions["SummonedArbalists"] = {
	name = "Summoned Arbalist",
	monsterTags = { "bone_armour", "bones", "fast_movement", "is_unarmed", "not_int", "physical_affinity", "puncturing_weapon", "skeleton", "undead", },
	life = 7.41,
	armour = 0.5,
	evasion = 0.5,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 4.29,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 60,
	accuracy = 3.4,
	limit = "ActiveArbalistLimit",
	skillList = {
		"MPWExpeditionSummonedArbalestProjectile",
	},
	modList = {
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- MonsterCannotBeDamaged [base_cannot_be_damaged = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_cannot_die [set_cannot_die = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["GuardianSentinel"] = {
	name = "Sentinel of Radiance",
	monsterTags = { "bludgeoning_weapon", "has_one_hand_mace", "has_one_handed_melee", "human", "humanoid", "medium_height", "melee", "not_dex", "not_int", "physical_affinity", "plate_armour", "very_slow_movement", },
	life = 12,
	armour = 1,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 20,
	damageSpread = 0.2,
	attackTime = 0.83,
	attackRange = 17,
	accuracy = 3.4,
	skillList = {
		"TeleportVaalDomination",
		"VaalDominationMelee",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
	},
}

-- This is a fake Minion to apply all 3 auras
minions["GuardianRelicAll"] = {
	name = "All Relics",
	life = 4,
	energyShield = 0.6,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"RelicTeleport",
		"Anger",
		"Hatred",
		"Wrath",
	},
	modList = {
		-- EmergeSpeedHigh [emerge_speed_+% = 0]
	},
}

minions["GuardianRelicFire"] = {
	name = "Fire Relic",
	monsterTags = { "cannot_be_monolith", "caster", "construct", "extra_extra_small_height", "ghost_armour", "is_unarmed", "medium_movement", "not_dex", "not_str", "physical_affinity", "unusable_corpse", },
	life = 4,
	energyShield = 0.6,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"RelicTeleport",
		"Anger",
	},
	modList = {
		-- EmergeSpeedHigh [emerge_speed_+% = 0]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- minion_targeting_use_parent_location [minion_targeting_use_parent_location = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- set_cannot_be_afflicted [set_cannot_be_afflicted = 1]
	},
}

minions["GuardianRelicCold"] = {
	name = "Cold Relic",
	monsterTags = { "cannot_be_monolith", "caster", "construct", "extra_extra_small_height", "ghost_armour", "is_unarmed", "medium_movement", "not_dex", "not_str", "physical_affinity", "unusable_corpse", },
	life = 4,
	energyShield = 0.6,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"RelicTeleport",
		"Hatred",
	},
	modList = {
		-- EmergeSpeedHigh [emerge_speed_+% = 0]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- minion_targeting_use_parent_location [minion_targeting_use_parent_location = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- set_cannot_be_afflicted [set_cannot_be_afflicted = 1]
	},
}

minions["GuardianRelicLightning"] = {
	name = "Lightning Relic",
	monsterTags = { "cannot_be_monolith", "caster", "construct", "extra_extra_small_height", "ghost_armour", "is_unarmed", "medium_movement", "not_dex", "not_str", "physical_affinity", "unusable_corpse", },
	life = 4,
	energyShield = 0.6,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1,
	damageSpread = 0,
	attackTime = 1,
	attackRange = 6,
	accuracy = 1,
	skillList = {
		"RelicTeleport",
		"Wrath",
	},
	modList = {
		-- EmergeSpeedHigh [emerge_speed_+% = 0]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- minion_targeting_use_parent_location [minion_targeting_use_parent_location = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- set_cannot_be_afflicted [set_cannot_be_afflicted = 1]
	},
}

minions["VoidSpawn"] = {
	name = "Void Spawn",
	monsterTags = { "caster", "construct", "elder_monster", "eldritch", "extra_large_height", "flesh_armour", "influence_monster", "is_unarmed", "lightning_affinity", "medium_movement", "not_dex", "not_str", "ranged", "red_blood", },
	life = 6,
	energyShield = 1,
	fireResist = 30,
	coldResist = 30,
	lightningResist = 30,
	chaosResist = 20,
	damage = 1.5,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 9,
	accuracy = 1,
	limit = "ActiveVoidSpawnLimit",
	skillList = {
		"ElderTentacleMinionProjectileDeepcaller",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
	},
}

minions["AncestralAhuanaMinion"] = {
	name = "Spirit of Ahuana",
	monsterTags = { "human", "humanoid", "medium_movement", "not_int", "not_str", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 0.9,
	evasion = 1,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.3,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 70,
	accuracy = 1,
	weaponType1 = "Bow",
	skillList = {
		"MPWAhuanaIceShot",
		"MonsterSnipeAhuana",
		"MPWAhuanaFakeArrow",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralAkoyaMinion"] = {
	name = "Spirit of Akoya",
	monsterTags = { "human", "humanoid", "medium_movement", "not_int", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1.1,
	armour = 0.75,
	evasion = 0.25,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.2,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 20,
	accuracy = 1,
	weaponType1 = "Two Handed Axe",
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"MPSAkoyaJadeSpray",
		"GSAkoyaRockExplosion",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralIkiahoMinion"] = {
	name = "Spirit of Ikiaho",
	monsterTags = { "human", "humanoid", "medium_movement", "not_dex", "not_str", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1,
	energyShield = 4,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.2,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 10,
	accuracy = 1,
	skillList = {
		"AncestralIkiahoArcticBreath",
		"AncestralIkiahoIceStorm",
		"EASIkiahoIceStorm",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralKahuturoaMinion"] = {
	name = "Spirit of Kahuturoa",
	monsterTags = { "fast_movement", "human", "humanoid", "not_dex", "not_int", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1.2,
	armour = 1,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.6,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 24,
	accuracy = 1,
	skillList = {
		"KahuturoaMelee",
		"DTTKahuturoaLeapSlam",
		"GAKahuturoaLeapSlamImpact",
		"GAKahuturoaForwardMelee",
		"GAKahuturoaLeapSlamWeaponSwing",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralKaomMinion"] = {
	name = "Spirit of Kaom",
	monsterTags = { "human", "humanoid", "not_int", "red_blood", "slow_movement", },
	baseDamageIgnoresAttackSpeed = true,
	life = 2,
	armour = 0.75,
	evasion = 0.25,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.3,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 20,
	accuracy = 1,
	weaponType1 = "Two Handed Axe",
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"MPSKaomFireFist",
		"GAKaomFistBlast",
		"GAKaomFistBlastFinal",
		"AncestralKaomUnarmedCombo",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralKiloavaMinion"] = {
	name = "Spirit of Kiloava",
	monsterTags = { "fast_movement", "human", "humanoid", "not_int", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1.2,
	armour = 0.75,
	evasion = 0.25,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 19,
	accuracy = 1,
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"MPWKiloavaSpearThrow",
		"GSKiloavaLightningBolt",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralMaataMinion"] = {
	name = "Spirit of Maata",
	monsterTags = { "human", "humanoid", "medium_movement", "not_str", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 0.9,
	energyShield = 1.6,
	evasion = 0.4,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 20,
	accuracy = 1,
	weaponType1 = "One Handed Mace",
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"DonutCircleMaata",
		"SSMMaataVine",
		"GSMaataVineCascade",
		"GTMaataVineCascade",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralRakiataMinion"] = {
	name = "Spirit of Rakiata",
	monsterTags = { "fast_movement", "human", "humanoid", "not_int", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1,
	armour = 0.75,
	evasion = 0.3,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.3,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 20,
	accuracy = 1,
	weaponType1 = "Two Handed Sword",
	skillList = {
		"GARakiataSlam",
		"RakiataSweep",
		"RakiataSlam",
		"RakiataLacerate",
		"GTRakiataSlam",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralTawhanukuMinion"] = {
	name = "Spirit of Tawhanuku",
	monsterTags = { "human", "humanoid", "medium_movement", "not_dex", "not_str", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 2,
	energyShield = 0.4,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.2,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 10,
	accuracy = 1,
	skillList = {
		"GSAncestralTawhanukuWave",
		"AncestralTawhanukuSoulRend",
		"GTTawhanukuMultiSoulrend",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["AncestralUtulaMinion"] = {
	name = "Spirit of Utula",
	monsterTags = { "fast_movement", "human", "humanoid", "not_int", "red_blood", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1.2,
	armour = 0.75,
	evasion = 0.1,
	fireResist = 0,
	coldResist = 0,
	lightningResist = 0,
	chaosResist = 0,
	damage = 1.2,
	damageSpread = 0.2,
	attackTime = 1,
	attackRange = 19,
	accuracy = 1,
	weaponType1 = "One Handed Axe",
	weaponType2 = "One Handed Axe",
	skillList = {
		"MeleeAtAnimationSpeedUnique",
		"UtulaFireSwing",
		"MPSUtulaFireball",
	},
	modList = {
		-- set_item_drop_slots [set_item_drop_slots = 0]
		mod("Condition:CannotBeDamaged", "FLAG", 1, 0, 0), -- base_cannot_be_damaged [base_cannot_be_damaged = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		-- cannot_taunt_enemies [cannot_taunt_enemies = 1]
		-- minion_aggro_range_scaled_by_distance_to_parent_target [minion_aggro_range_scaled_by_distance_to_parent_target = 1]
	},
}

minions["LivingLightningMinion"] = {
	name = "Living Lightning",
	monsterTags = { "elemental", "lightning", "not_dex", "not_str", "small_height", "very_fast_movement", },
	baseDamageIgnoresAttackSpeed = true,
	life = 1.4,
	energyShield = 0.2,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 1.4,
	damageSpread = 0.8,
	attackTime = 1.17,
	attackRange = 20,
	accuracy = 1,
	limit = "ActiveLivingLightningLimit",
	skillList = {
		"SummonedLivingLightningZap",
	},
	modList = {
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_item_drop_slots [set_item_drop_slots = 0]
		-- set_cannot_spawn_support_ghosts [set_cannot_spawn_support_ghosts = 1]
		-- untargetable_by_monster_ai [untargetable_by_monster_ai = 1]
		mod("DamageTaken", "MORE", -100, 0, 0), -- set_base_cannot_be_damaged [set_base_cannot_be_damaged = 1]
		-- set_cannot_be_chained_from [set_cannot_be_chained_from = 1]
		mod("Life", "OVERRIDE", 1, 0, 0), -- set_maximum_life_is_one [set_maximum_life_is_one = 1]
		mod("AvoidProjectilesChance", "BASE", 100, 0, 0), -- set_base_avoid_projectiles_%_chance [set_base_avoid_projectiles_%_chance = 100]
	},
}

minions["PenanceMarkPhantasm"] = {
	name = "Shackled Phantasm",
	monsterTags = { "caster", "fire_affinity", "ghost", "ghost_armour", "ghost_blood", "is_unarmed", "medium_movement", "slashing_weapon", "undead", },
	life = 1.3,
	fireResist = 40,
	coldResist = 40,
	lightningResist = 40,
	chaosResist = 20,
	damage = 0.9,
	damageSpread = 0.2,
	attackTime = 1.755,
	attackRange = 6,
	accuracy = 1,
	hostile = true,
	skillList = {
		"MPSPhantasmBasicBlood",
	},
	modList = {
		-- MonsterNoDropsOrExperience [monster_no_drops_or_experience = 1]
		-- CannotSpawnBeyondPortals [monster_no_beyond_portal = 1]
		mod("KnockbackImmune", "FLAG", 1, 0, 0), -- ImmuneToKnockback [cannot_be_knocked_back = 1]
		-- CannotBeAugmented [cannot_have_azmeri_dust = 1]
		-- CannotBeAugmented [cant_possess_this = 1]
		-- CannotBeAugmented [cant_touch_this = 1]
		-- CannotBeAugmented [cannot_be_tagged_by_sentinel = 1]
		-- CannotBeAugmented [cannot_be_afflicted = 1]
		-- CannotBeAugmented [cannot_have_affliction_mods = 1]
		-- set_monster_no_drops_or_experience [set_monster_no_drops_or_experience = 1]
		mod("CurseImmune", "FLAG", 1, 0, 0), -- set_immune_to_curses [set_immune_to_curses = 1]
		-- set_monster_can_grant_vaal_souls_if_no_experience [set_monster_can_grant_vaal_souls_if_no_experience = 1]
	},
}
