/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.provectus.kafka.ui.util.jsonschema.FieldSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonType;
import com.provectus.kafka.ui.util.jsonschema.SimpleJsonType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class ObjectFieldSchema
implements FieldSchema {
    static final ObjectFieldSchema EMPTY = new ObjectFieldSchema(Map.of(), List.of());
    private final Map<String, FieldSchema> properties;
    private final List<String> required;

    ObjectFieldSchema(Map<String, FieldSchema> properties, List<String> required) {
        this.properties = properties;
        this.required = required;
    }

    Map<String, FieldSchema> getProperties() {
        return this.properties;
    }

    List<String> getRequired() {
        return this.required;
    }

    public JsonNode toJsonNode(ObjectMapper mapper) {
        Map<String, JsonNode> nodes = this.properties.entrySet().stream().map(e -> Tuples.of((Object)((String)e.getKey()), (Object)((FieldSchema)e.getValue()).toJsonNode(mapper))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.setAll(new SimpleJsonType(JsonType.Type.OBJECT).toJsonNode(mapper));
        objectNode.set("properties", mapper.valueToTree(nodes));
        if (!this.required.isEmpty()) {
            objectNode.set("required", mapper.valueToTree((Object)this.required));
        }
        return objectNode;
    }
}

