/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.provectus.kafka.ui.util.jsonschema.FieldSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonType;
import com.provectus.kafka.ui.util.jsonschema.SimpleJsonType;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonSchema {
    private final URI id;
    private final URI schema = URI.create("https://json-schema.org/draft/2020-12/schema");
    private final String title;
    private final JsonType type;
    private final Map<String, FieldSchema> properties;
    private final Map<String, FieldSchema> definitions;
    private final List<String> required;
    private final String rootRef;

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.set("$id", (JsonNode)new TextNode(this.id.toString()));
        objectNode.set("$schema", (JsonNode)new TextNode(this.schema.toString()));
        objectNode.setAll(this.type.toJsonNode(mapper));
        if (this.properties != null && !this.properties.isEmpty()) {
            objectNode.set("properties", mapper.valueToTree(this.properties.entrySet().stream().map(e -> Tuples.of((Object)((String)e.getKey()), (Object)((FieldSchema)e.getValue()).toJsonNode(mapper))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))));
            if (!this.required.isEmpty()) {
                objectNode.set("required", mapper.valueToTree((Object)this.required));
            }
        }
        if (this.definitions != null && !this.definitions.isEmpty()) {
            objectNode.set("definitions", mapper.valueToTree(this.definitions.entrySet().stream().map(e -> Tuples.of((Object)((String)e.getKey()), (Object)((FieldSchema)e.getValue()).toJsonNode(mapper))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))));
        }
        if (this.rootRef != null) {
            objectNode.set("$ref", (JsonNode)new TextNode(this.rootRef));
        }
        return objectNode.toString();
    }

    public static JsonSchema stringSchema() {
        return JsonSchema.builder().id(new URI("http://unknown.unknown")).type((JsonType)new SimpleJsonType(JsonType.Type.STRING)).build();
    }

    JsonSchema(URI id, String title, JsonType type, Map<String, FieldSchema> properties, Map<String, FieldSchema> definitions, List<String> required, String rootRef) {
        this.id = id;
        this.title = title;
        this.type = type;
        this.properties = properties;
        this.definitions = definitions;
        this.required = required;
        this.rootRef = rootRef;
    }

    public static JsonSchemaBuilder builder() {
        return new JsonSchemaBuilder();
    }

    public URI getId() {
        return this.id;
    }

    public URI getSchema() {
        return this.schema;
    }

    public String getTitle() {
        return this.title;
    }

    public JsonType getType() {
        return this.type;
    }

    public Map<String, FieldSchema> getProperties() {
        return this.properties;
    }

    public Map<String, FieldSchema> getDefinitions() {
        return this.definitions;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public String getRootRef() {
        return this.rootRef;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonSchema)) {
            return false;
        }
        JsonSchema other = (JsonSchema)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        URI this$id = this.getId();
        URI other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        URI this$schema = this.getSchema();
        URI other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        JsonType this$type = this.getType();
        JsonType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map this$properties = this.getProperties();
        Map other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Map this$definitions = this.getDefinitions();
        Map other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        List this$required = this.getRequired();
        List other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        String this$rootRef = this.getRootRef();
        String other$rootRef = other.getRootRef();
        return !(this$rootRef == null ? other$rootRef != null : !this$rootRef.equals(other$rootRef));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        URI $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        JsonType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Map $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        List $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        String $rootRef = this.getRootRef();
        result = result * 59 + ($rootRef == null ? 43 : $rootRef.hashCode());
        return result;
    }

    public String toString() {
        return "JsonSchema(id=" + this.getId() + ", schema=" + this.getSchema() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", properties=" + this.getProperties() + ", definitions=" + this.getDefinitions() + ", required=" + this.getRequired() + ", rootRef=" + this.getRootRef() + ")";
    }
}

