/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util.jsonschema;

import com.provectus.kafka.ui.util.jsonschema.ArrayFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.AvroJsonSchemaConverter;
import com.provectus.kafka.ui.util.jsonschema.EnumJsonType;
import com.provectus.kafka.ui.util.jsonschema.FieldSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonAvroConversion;
import com.provectus.kafka.ui.util.jsonschema.JsonSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonSchemaConverter;
import com.provectus.kafka.ui.util.jsonschema.JsonType;
import com.provectus.kafka.ui.util.jsonschema.MapFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.ObjectFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.OneOfFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.RefFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.SimpleFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.SimpleJsonType;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class AvroJsonSchemaConverter
implements JsonSchemaConverter<Schema> {
    public JsonSchema convert(URI basePath, Schema schema) {
        JsonSchema.JsonSchemaBuilder builder = JsonSchema.builder();
        builder.id(basePath.resolve(schema.getName()));
        JsonType type = this.convertType(schema);
        builder.type(type);
        HashMap definitions = new HashMap();
        FieldSchema root = this.convertSchema(schema, definitions, true);
        builder.definitions(definitions);
        if (type.getType().equals((Object)JsonType.Type.OBJECT)) {
            ObjectFieldSchema objectRoot = (ObjectFieldSchema)root;
            builder.properties(objectRoot.getProperties());
            builder.required(objectRoot.getRequired());
        }
        return builder.build();
    }

    private FieldSchema convertField(Schema.Field field, Map<String, FieldSchema> definitions) {
        return this.convertSchema(field.schema(), definitions, false);
    }

    private FieldSchema convertSchema(Schema schema, Map<String, FieldSchema> definitions, boolean isRoot) {
        Optional logicalTypeSchema = JsonAvroConversion.LogicalTypeConversion.getJsonSchema((Schema)schema);
        if (logicalTypeSchema.isPresent()) {
            return (FieldSchema)logicalTypeSchema.get();
        }
        if (!schema.isUnion()) {
            JsonType type = this.convertType(schema);
            switch (1.$SwitchMap$com$provectus$kafka$ui$util$jsonschema$JsonType$Type[type.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return new SimpleFieldSchema(type);
                }
                case 7: {
                    if (schema.getType().equals((Object)Schema.Type.MAP)) {
                        return new MapFieldSchema(this.convertSchema(schema.getValueType(), definitions, isRoot));
                    }
                    return this.createObjectSchema(schema, definitions, isRoot);
                }
                case 8: {
                    return this.createArraySchema(schema, definitions);
                }
            }
            throw new RuntimeException("Unknown type");
        }
        return this.createUnionSchema(schema, definitions);
    }

    private FieldSchema createUnionSchema(Schema schema, Map<String, FieldSchema> definitions) {
        boolean nullable = schema.getTypes().stream().anyMatch(t -> t.getType().equals((Object)Schema.Type.NULL));
        Map<String, FieldSchema> fields = schema.getTypes().stream().filter(t -> !t.getType().equals((Object)Schema.Type.NULL)).map(f -> {
            String oneOfFieldName = f.getType().equals((Object)Schema.Type.RECORD) ? f.getFullName() : f.getType().getName().toLowerCase();
            return Tuples.of((Object)oneOfFieldName, (Object)this.convertSchema(f, definitions, false));
        }).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
        if (nullable) {
            return new OneOfFieldSchema(List.of(new SimpleFieldSchema((JsonType)new SimpleJsonType(JsonType.Type.NULL)), new ObjectFieldSchema(fields, Collections.emptyList())));
        }
        return new ObjectFieldSchema(fields, Collections.emptyList());
    }

    private FieldSchema createObjectSchema(Schema schema, Map<String, FieldSchema> definitions, boolean isRoot) {
        String definitionName = schema.getFullName();
        if (definitions.containsKey(definitionName)) {
            return this.createRefField(definitionName);
        }
        definitions.put(definitionName, (FieldSchema)ObjectFieldSchema.EMPTY);
        Map<String, FieldSchema> fields = schema.getFields().stream().map(f -> Tuples.of((Object)f.name(), (Object)this.convertField(f, definitions))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
        List required = schema.getFields().stream().filter(f -> !f.schema().isNullable()).map(Schema.Field::name).collect(Collectors.toList());
        ObjectFieldSchema objectSchema = new ObjectFieldSchema(fields, required);
        if (isRoot) {
            definitions.put(definitionName, (FieldSchema)new RefFieldSchema("#"));
            return objectSchema;
        }
        definitions.put(definitionName, (FieldSchema)objectSchema);
        return this.createRefField(definitionName);
    }

    private RefFieldSchema createRefField(String definitionName) {
        return new RefFieldSchema(String.format("#/definitions/%s", definitionName));
    }

    private ArrayFieldSchema createArraySchema(Schema schema, Map<String, FieldSchema> definitions) {
        return new ArrayFieldSchema(this.convertSchema(schema.getElementType(), definitions, false));
    }

    private JsonType convertType(Schema schema) {
        return switch (1.$SwitchMap$org$apache$avro$Schema$Type[schema.getType().ordinal()]) {
            case 1, 2 -> new SimpleJsonType(JsonType.Type.INTEGER);
            case 3, 4 -> new SimpleJsonType(JsonType.Type.OBJECT);
            case 5 -> new EnumJsonType(schema.getEnumSymbols());
            case 6, 7 -> new SimpleJsonType(JsonType.Type.STRING);
            case 8 -> new SimpleJsonType(JsonType.Type.NULL);
            case 9 -> new SimpleJsonType(JsonType.Type.ARRAY);
            case 10, 11, 12 -> new SimpleJsonType(JsonType.Type.NUMBER);
            case 13 -> new SimpleJsonType(JsonType.Type.BOOLEAN);
            default -> new SimpleJsonType(JsonType.Type.STRING);
        };
    }
}

