/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util;

import com.google.common.annotations.VisibleForTesting;
import com.provectus.kafka.ui.util.GithubReleaseInfo;
import com.provectus.kafka.ui.util.WebClientConfigurator;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
public class GithubReleaseInfo {
    private static final Logger log = LoggerFactory.getLogger(GithubReleaseInfo.class);
    private static final String GITHUB_LATEST_RELEASE_RETRIEVAL_URL = "https://api.github.com/repos/provectus/kafka-ui/releases/latest";
    private static final Duration GITHUB_API_MAX_WAIT_TIME = Duration.ofSeconds(2L);
    private volatile GithubReleaseDto release = GithubReleaseDto.empty();
    private final Mono<Void> refreshMono;

    public GithubReleaseInfo() {
        this("https://api.github.com/repos/provectus/kafka-ui/releases/latest");
    }

    @VisibleForTesting
    GithubReleaseInfo(String url) {
        this.refreshMono = new WebClientConfigurator().build().get().uri(url, new Object[0]).exchangeToMono(resp -> resp.bodyToMono(GithubReleaseDto.class)).timeout(GITHUB_API_MAX_WAIT_TIME).doOnError(th -> log.trace("Error getting latest github release info", th)).onErrorResume(th -> true, th -> Mono.just((Object)GithubReleaseDto.empty())).doOnNext(release -> {
            this.release = release;
        }).then();
    }

    public GithubReleaseDto get() {
        return this.release;
    }

    public Mono<Void> refresh() {
        return this.refreshMono;
    }
}

