/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.config.WebclientProperties;
import com.provectus.kafka.ui.config.auth.OAuthProperties;
import com.provectus.kafka.ui.config.auth.RoleBasedAccessControlProperties;
import com.provectus.kafka.ui.exception.FileUploadException;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.util.DynamicConfigOperations;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DynamicConfigOperations {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigOperations.class);
    static final String DYNAMIC_CONFIG_ENABLED_ENV_PROPERTY = "dynamic.config.enabled";
    static final String FILTERING_GROOVY_ENABLED_PROPERTY = "filtering.groovy.enabled";
    static final String DYNAMIC_CONFIG_PATH_ENV_PROPERTY = "dynamic.config.path";
    static final String DYNAMIC_CONFIG_PATH_ENV_PROPERTY_DEFAULT = "/etc/kafkaui/dynamic_config.yaml";
    static final String CONFIG_RELATED_UPLOADS_DIR_PROPERTY = "config.related.uploads.dir";
    static final String CONFIG_RELATED_UPLOADS_DIR_DEFAULT = "/etc/kafkaui/uploads";
    private final ConfigurableApplicationContext ctx;

    public static ApplicationContextInitializer<ConfigurableApplicationContext> dynamicConfigPropertiesInitializer() {
        return appCtx -> new DynamicConfigOperations(appCtx).loadDynamicPropertySource().ifPresent(source -> appCtx.getEnvironment().getPropertySources().addFirst(source));
    }

    public boolean dynamicConfigEnabled() {
        return "true".equalsIgnoreCase(this.ctx.getEnvironment().getProperty("dynamic.config.enabled"));
    }

    public boolean filteringGroovyEnabled() {
        return "true".equalsIgnoreCase(this.ctx.getEnvironment().getProperty("filtering.groovy.enabled"));
    }

    private Path dynamicConfigFilePath() {
        return Paths.get(Optional.ofNullable(this.ctx.getEnvironment().getProperty("dynamic.config.path")).orElse("/etc/kafkaui/dynamic_config.yaml"), new String[0]);
    }

    public Optional<PropertySource<?>> loadDynamicPropertySource() {
        if (this.dynamicConfigEnabled()) {
            Path configPath = this.dynamicConfigFilePath();
            if (!Files.exists(configPath, new LinkOption[0]) || !Files.isReadable(configPath)) {
                log.warn("Dynamic config file {} doesnt exist or not readable", (Object)configPath);
                return Optional.empty();
            }
            CompositePropertySource propertySource = new CompositePropertySource("dynamicProperties");
            new YamlPropertySourceLoader().load("dynamicProperties", (Resource)new FileSystemResource(configPath)).forEach(arg_0 -> ((CompositePropertySource)propertySource).addPropertySource(arg_0));
            log.info("Dynamic config loaded from {}", (Object)configPath);
            return Optional.of(propertySource);
        }
        return Optional.empty();
    }

    public PropertiesStructure getCurrentProperties() {
        this.checkIfDynamicConfigEnabled();
        return PropertiesStructure.builder().kafka((ClustersProperties)this.getNullableBean(ClustersProperties.class)).rbac((RoleBasedAccessControlProperties)this.getNullableBean(RoleBasedAccessControlProperties.class)).auth(PropertiesStructure.Auth.builder().type(this.ctx.getEnvironment().getProperty("auth.type")).oauth2((OAuthProperties)this.getNullableBean(OAuthProperties.class)).build()).webclient((WebclientProperties)this.getNullableBean(WebclientProperties.class)).build();
    }

    @Nullable
    private <T> T getNullableBean(Class<T> clazz) {
        try {
            return (T)this.ctx.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            return null;
        }
    }

    public void persist(PropertiesStructure properties) {
        this.checkIfDynamicConfigEnabled();
        properties.initAndValidate();
        String yaml = this.serializeToYaml(properties);
        this.writeYamlToFile(yaml, this.dynamicConfigFilePath());
    }

    public Mono<Path> uploadConfigRelatedFile(FilePart file) {
        this.checkIfDynamicConfigEnabled();
        String targetDirStr = this.ctx.getEnvironment().getProperty("config.related.uploads.dir", "/etc/kafkaui/uploads");
        Path targetDir = Path.of(targetDirStr, new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                return Mono.error((Throwable)new FileUploadException("Error creating directory for uploads %s".formatted(targetDir), (Throwable)e));
            }
        }
        Path targetFilePath = targetDir.resolve(file.filename() + "-" + Instant.now().getEpochSecond());
        log.info("Uploading config-related file {}", (Object)targetFilePath);
        if (Files.exists(targetFilePath, new LinkOption[0])) {
            log.info("File {} already exists, it will be overwritten", (Object)targetFilePath);
        }
        return file.transferTo(targetFilePath).thenReturn((Object)targetFilePath).doOnError(th -> log.error("Error uploading file {}", (Object)targetFilePath, th)).onErrorMap(th -> new FileUploadException(targetFilePath, th));
    }

    public void checkIfFilteringGroovyEnabled() {
        if (!this.filteringGroovyEnabled()) {
            throw new ValidationException("Groovy filters is not allowed. Set filtering.groovy.enabled property to 'true' to enabled it.");
        }
    }

    private void checkIfDynamicConfigEnabled() {
        if (!this.dynamicConfigEnabled()) {
            throw new ValidationException("Dynamic config change is not allowed. Set dynamic.config.enabled property to 'true' to enabled it.");
        }
    }

    private void writeYamlToFile(String yaml, Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new ValidationException("Dynamic file path is a directory, but should be a file path");
        }
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
            throw new ValidationException("File already exists and is not writable");
        }
        try {
            Files.writeString(path, (CharSequence)yaml, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new ValidationException("Error writing to " + path, (Throwable)e);
        }
    }

    private String serializeToYaml(PropertiesStructure props) {
        1 representer = new /* Unavailable Anonymous Inner Class!! */;
        PropertyUtils propertyUtils = new PropertyUtils();
        propertyUtils.setBeanAccess(BeanAccess.FIELD);
        representer.setPropertyUtils(propertyUtils);
        representer.addClassTag(PropertiesStructure.class, Tag.MAP);
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml((Representer)representer).dump((Object)props);
    }

    public DynamicConfigOperations(ConfigurableApplicationContext ctx) {
        this.ctx = ctx;
    }
}

