/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util;

import com.google.common.annotations.VisibleForTesting;
import com.provectus.kafka.ui.emitter.PolledRecords;
import com.provectus.kafka.ui.model.KafkaCluster;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.atomic.AtomicInteger;

public class ApplicationMetrics {
    private static final String COMMON_PREFIX = "kui_";
    private final String clusterName;
    private final MeterRegistry registry;

    public static ApplicationMetrics forCluster(KafkaCluster cluster) {
        return new ApplicationMetrics(cluster.getName(), (MeterRegistry)Metrics.globalRegistry);
    }

    @VisibleForTesting
    public static ApplicationMetrics noop() {
        return new ApplicationMetrics("noop", (MeterRegistry)new SimpleMeterRegistry());
    }

    public void meterPolledRecords(String topic, PolledRecords polled, boolean throttled) {
        this.pollTimer(topic).record(polled.elapsed());
        this.polledRecords(topic).increment((double)polled.count());
        this.polledBytes(topic).record((double)polled.bytes());
        if (throttled) {
            this.pollThrottlingActivations().increment();
        }
    }

    private Counter polledRecords(String topic) {
        return Counter.builder((String)"kui_topic_records_polled").description("Number of records polled from topic").tag("cluster", this.clusterName).tag("topic", topic).register(this.registry);
    }

    private DistributionSummary polledBytes(String topic) {
        return DistributionSummary.builder((String)"kui_topic_polled_bytes").description("Bytes polled from kafka topic").tag("cluster", this.clusterName).tag("topic", topic).register(this.registry);
    }

    private Timer pollTimer(String topic) {
        return Timer.builder((String)"kui_topic_poll_time").description("Time spend in polling for topic").tag("cluster", this.clusterName).tag("topic", topic).register(this.registry);
    }

    private Counter pollThrottlingActivations() {
        return Counter.builder((String)"kui_poll_throttling_activations").description("Number of poll throttling activations").tag("cluster", this.clusterName).register(this.registry);
    }

    public AtomicInteger activeConsumers() {
        AtomicInteger count = new AtomicInteger();
        Gauge.builder((String)"kui_active_consumers", () -> count).description("Number of active consumers").tag("cluster", this.clusterName).register(this.registry);
        return count;
    }

    private ApplicationMetrics(String clusterName, MeterRegistry registry) {
        this.clusterName = clusterName;
        this.registry = registry;
    }
}

