/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.rbac.extractor;

import com.provectus.kafka.ui.config.auth.LdapProperties;
import com.provectus.kafka.ui.model.rbac.Role;
import com.provectus.kafka.ui.model.rbac.provider.Provider;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class RbacLdapAuthoritiesExtractor
extends DefaultLdapAuthoritiesPopulator {
    private static final Logger log = LoggerFactory.getLogger(RbacLdapAuthoritiesExtractor.class);
    private final AccessControlService acs;
    private final LdapProperties props;

    public RbacLdapAuthoritiesExtractor(ApplicationContext context, BaseLdapPathContextSource contextSource, String groupFilterSearchBase) {
        super((ContextSource)contextSource, groupFilterSearchBase);
        this.acs = (AccessControlService)context.getBean(AccessControlService.class);
        this.props = (LdapProperties)context.getBean(LdapProperties.class);
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
        Set ldapGroups = this.getRoles(user.getNameInNamespace(), username);
        return this.acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(subject -> subject.getProvider().equals((Object)Provider.LDAP)).filter(subject -> subject.getType().equals("group")).anyMatch(subject -> ldapGroups.contains(subject.getValue()))).map(Role::getName).peek(role -> log.trace("Mapped role [{}] for user [{}]", role, (Object)username)).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    private Set<String> getRoles(String userDn, String username) {
        String groupSearchBase = this.props.getGroupFilterSearchBase();
        Assert.notNull((Object)groupSearchBase, (String)"groupSearchBase is empty");
        String groupRoleAttribute = this.props.getGroupRoleAttribute();
        if (groupRoleAttribute == null) {
            groupRoleAttribute = "cn";
        }
        log.trace("Searching for roles for user [{}] with DN [{}], groupRoleAttribute [{}] and filter [{}] in search base [{}]", new Object[]{username, userDn, groupRoleAttribute, this.getGroupSearchFilter(), groupSearchBase});
        SpringSecurityLdapTemplate ldapTemplate = this.getLdapTemplate();
        ldapTemplate.setIgnoreNameNotFoundException(true);
        Set userRoles = ldapTemplate.searchForMultipleAttributeValues(groupSearchBase, this.getGroupSearchFilter(), (Object[])new String[]{userDn, username}, new String[]{groupRoleAttribute});
        return userRoles.stream().map(record -> (String)((List)record.get(this.getGroupRoleAttribute())).get(0)).peek(group -> log.trace("Found LDAP group [{}] for user [{}]", group, (Object)username)).collect(Collectors.toSet());
    }
}

