/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.rbac.extractor;

import com.google.common.collect.Sets;
import com.provectus.kafka.ui.config.auth.OAuthProperties;
import com.provectus.kafka.ui.model.rbac.Role;
import com.provectus.kafka.ui.model.rbac.provider.Provider;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.ProviderAuthorityExtractor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OauthAuthorityExtractor
implements ProviderAuthorityExtractor {
    private static final Logger log = LoggerFactory.getLogger(OauthAuthorityExtractor.class);
    public static final String ROLES_FIELD_PARAM_NAME = "roles-field";

    public boolean isApplicable(String provider, Map<String, String> customParams) {
        boolean containsRolesFieldNameParam = customParams.containsKey(ROLES_FIELD_PARAM_NAME);
        if (!containsRolesFieldNameParam) {
            log.debug("Provider [{}] doesn't contain a roles field param name, mapping won't be performed", (Object)provider);
            return false;
        }
        return Provider.Name.OAUTH.equalsIgnoreCase(provider) || Provider.Name.OAUTH.equalsIgnoreCase(customParams.get("type"));
    }

    public Mono<Set<String>> extract(AccessControlService acs, Object value, Map<String, Object> additionalParams) {
        DefaultOAuth2User principal;
        log.trace("Extracting OAuth2 user authorities");
        try {
            principal = (DefaultOAuth2User)value;
        }
        catch (ClassCastException e) {
            log.error("Can't cast value to DefaultOAuth2User", (Throwable)e);
            throw new RuntimeException();
        }
        OAuthProperties.OAuth2Provider provider = (OAuthProperties.OAuth2Provider)additionalParams.get("provider");
        Assert.notNull((Object)provider, (String)"provider is null");
        String rolesFieldName = (String)provider.getCustomParams().get(ROLES_FIELD_PARAM_NAME);
        Set rolesByUsername = acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH)).filter(s -> s.getType().equals("user")).anyMatch(s -> s.getValue().equals(principal.getName()))).map(Role::getName).collect(Collectors.toSet());
        Set rolesByRolesField = acs.getRoles().stream().filter(role -> role.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH)).filter(s -> s.getType().equals("role")).anyMatch(subject -> {
            String roleName = subject.getValue();
            Collection principalRoles = this.convertRoles(principal.getAttribute(rolesFieldName));
            boolean roleMatched = principalRoles.contains(roleName);
            if (roleMatched) {
                log.debug("Assigning role [{}] to user [{}]", (Object)roleName, (Object)principal.getName());
            } else {
                log.trace("Role [{}] not found in user [{}] roles", (Object)roleName, (Object)principal.getName());
            }
            return roleMatched;
        })).map(Role::getName).collect(Collectors.toSet());
        return Mono.just((Object)Sets.union(rolesByUsername, rolesByRolesField));
    }

    private Collection<String> convertRoles(Object roles) {
        if (roles == null) {
            log.debug("Param missing from attributes, skipping");
            return Collections.emptySet();
        }
        if (roles instanceof List || roles instanceof Set) {
            log.trace("The field is either a set or a list, returning as is");
            return (Collection)roles;
        }
        if (!(roles instanceof String)) {
            log.debug("The field is not a string, skipping");
            return Collections.emptySet();
        }
        log.trace("Trying to deserialize the field value [{}] as a string", roles);
        return Arrays.stream(((String)roles).split(",")).collect(Collectors.toSet());
    }
}

