/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.rbac.extractor;

import com.google.common.collect.Sets;
import com.provectus.kafka.ui.model.rbac.Role;
import com.provectus.kafka.ui.model.rbac.provider.Provider;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.ProviderAuthorityExtractor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import reactor.core.publisher.Mono;

public class CognitoAuthorityExtractor
implements ProviderAuthorityExtractor {
    private static final Logger log = LoggerFactory.getLogger(CognitoAuthorityExtractor.class);
    private static final String COGNITO_GROUPS_ATTRIBUTE_NAME = "cognito:groups";

    public boolean isApplicable(String provider, Map<String, String> customParams) {
        return Provider.Name.COGNITO.equalsIgnoreCase(provider) || Provider.Name.COGNITO.equalsIgnoreCase(customParams.get("type"));
    }

    public Mono<Set<String>> extract(AccessControlService acs, Object value, Map<String, Object> additionalParams) {
        DefaultOAuth2User principal;
        log.debug("Extracting cognito user authorities");
        try {
            principal = (DefaultOAuth2User)value;
        }
        catch (ClassCastException e) {
            log.error("Can't cast value to DefaultOAuth2User", (Throwable)e);
            throw new RuntimeException();
        }
        Set groupsByUsername = acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_COGNITO)).filter(s -> s.getType().equals("user")).anyMatch(s -> s.getValue().equals(principal.getName()))).map(Role::getName).collect(Collectors.toSet());
        List groups = (List)principal.getAttribute(COGNITO_GROUPS_ATTRIBUTE_NAME);
        if (groups == null) {
            log.debug("Cognito groups param is not present");
            return Mono.just(groupsByUsername);
        }
        Set groupsByGroups = acs.getRoles().stream().filter(role -> role.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_COGNITO)).filter(s -> s.getType().equals("group")).anyMatch(subject -> groups.stream().anyMatch(cognitoGroup -> cognitoGroup.equals(subject.getValue())))).map(Role::getName).collect(Collectors.toSet());
        return Mono.just((Object)Sets.union(groupsByUsername, groupsByGroups));
    }
}

