/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.rbac;

import com.provectus.kafka.ui.config.auth.AuthenticatedUser;
import com.provectus.kafka.ui.config.auth.RbacUser;
import com.provectus.kafka.ui.config.auth.RoleBasedAccessControlProperties;
import com.provectus.kafka.ui.model.ClusterDTO;
import com.provectus.kafka.ui.model.ConnectDTO;
import com.provectus.kafka.ui.model.InternalTopic;
import com.provectus.kafka.ui.model.rbac.AccessContext;
import com.provectus.kafka.ui.model.rbac.Permission;
import com.provectus.kafka.ui.model.rbac.Resource;
import com.provectus.kafka.ui.model.rbac.Role;
import com.provectus.kafka.ui.model.rbac.Subject;
import com.provectus.kafka.ui.model.rbac.permission.ConnectAction;
import com.provectus.kafka.ui.model.rbac.permission.ConsumerGroupAction;
import com.provectus.kafka.ui.model.rbac.permission.SchemaAction;
import com.provectus.kafka.ui.model.rbac.permission.TopicAction;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.CognitoAuthorityExtractor;
import com.provectus.kafka.ui.service.rbac.extractor.GithubAuthorityExtractor;
import com.provectus.kafka.ui.service.rbac.extractor.GoogleAuthorityExtractor;
import com.provectus.kafka.ui.service.rbac.extractor.OauthAuthorityExtractor;
import com.provectus.kafka.ui.service.rbac.extractor.ProviderAuthorityExtractor;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Service
@EnableConfigurationProperties(value={RoleBasedAccessControlProperties.class})
public class AccessControlService {
    private static final Logger log = LoggerFactory.getLogger(AccessControlService.class);
    private static final String ACCESS_DENIED = "Access denied";
    private static final String ACTIONS_ARE_EMPTY = "actions are empty";
    @Nullable
    private final InMemoryReactiveClientRegistrationRepository clientRegistrationRepository;
    private final RoleBasedAccessControlProperties properties;
    private final Environment environment;
    private boolean rbacEnabled = false;
    private Set<ProviderAuthorityExtractor> oauthExtractors = Collections.emptySet();

    @PostConstruct
    public void init() {
        if (CollectionUtils.isEmpty((Collection)this.properties.getRoles())) {
            log.trace("No roles provided, disabling RBAC");
            return;
        }
        this.rbacEnabled = true;
        this.oauthExtractors = this.properties.getRoles().stream().map(role -> role.getSubjects().stream().map(Subject::getProvider).distinct().map(provider -> switch (1.$SwitchMap$com$provectus$kafka$ui$model$rbac$provider$Provider[provider.ordinal()]) {
            case 1 -> new CognitoAuthorityExtractor();
            case 2 -> new GoogleAuthorityExtractor();
            case 3 -> new GithubAuthorityExtractor();
            case 4 -> new OauthAuthorityExtractor();
            default -> null;
        }).filter(Objects::nonNull).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!(this.properties.getRoles().isEmpty() || !"oauth2".equalsIgnoreCase(this.environment.getProperty("auth.type")) || this.clientRegistrationRepository != null && this.clientRegistrationRepository.iterator().hasNext())) {
            log.error("Roles are configured but no authentication methods are present. Authentication might fail.");
        }
    }

    public Mono<Void> validateAccess(AccessContext context) {
        if (!this.rbacEnabled) {
            return Mono.empty();
        }
        if (CollectionUtils.isNotEmpty((Collection)context.getApplicationConfigActions())) {
            return this.getUser().doOnNext(user -> {
                boolean accessGranted = this.isApplicationConfigAccessible(context, user);
                if (!accessGranted) {
                    throw new AccessDeniedException(ACCESS_DENIED);
                }
            }).then();
        }
        return this.getUser().doOnNext(user -> {
            boolean accessGranted;
            boolean bl = accessGranted = this.isApplicationConfigAccessible(context, user) && this.isClusterAccessible(context, user) && this.isClusterConfigAccessible(context, user) && this.isTopicAccessible(context, user) && this.isConsumerGroupAccessible(context, user) && this.isConnectAccessible(context, user) && this.isConnectorAccessible(context, user) && this.isSchemaAccessible(context, user) && this.isKsqlAccessible(context, user) && this.isAclAccessible(context, user) && this.isAuditAccessible(context, user);
            if (!accessGranted) {
                throw new AccessDeniedException(ACCESS_DENIED);
            }
        }).then();
    }

    public Mono<AuthenticatedUser> getUser() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).filter(authentication -> authentication.getPrincipal() instanceof RbacUser).map(authentication -> (RbacUser)authentication.getPrincipal()).map(user -> new AuthenticatedUser(user.name(), user.groups()));
    }

    public boolean isApplicationConfigAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)context.getApplicationConfigActions())) {
            return true;
        }
        Set requiredActions = context.getApplicationConfigActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.APPLICATIONCONFIG, null, user, context, requiredActions);
    }

    private boolean isClusterAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)context.getCluster()), (String)"cluster value is empty");
        return this.properties.getRoles().stream().filter(this.filterRole(user)).anyMatch(this.filterCluster(context.getCluster()));
    }

    public Mono<Boolean> isClusterAccessible(ClusterDTO cluster) {
        if (!this.rbacEnabled) {
            return Mono.just((Object)true);
        }
        AccessContext accessContext = AccessContext.builder().cluster(cluster.getName()).build();
        return this.getUser().map(u -> this.isClusterAccessible(accessContext, u));
    }

    public boolean isClusterConfigAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)context.getClusterConfigActions())) {
            return true;
        }
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)context.getCluster()), (String)"cluster value is empty");
        Set requiredActions = context.getClusterConfigActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.CLUSTERCONFIG, context.getCluster(), user, context, requiredActions);
    }

    public boolean isTopicAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getTopic() == null && context.getTopicActions().isEmpty()) {
            return true;
        }
        Assert.isTrue((!context.getTopicActions().isEmpty() ? 1 : 0) != 0, (String)ACTIONS_ARE_EMPTY);
        Set requiredActions = context.getTopicActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.TOPIC, context.getTopic(), user, context, requiredActions);
    }

    public Mono<List<InternalTopic>> filterViewableTopics(List<InternalTopic> topics, String clusterName) {
        if (!this.rbacEnabled) {
            return Mono.just(topics);
        }
        return this.getUser().map(user -> topics.stream().filter(topic -> {
            AccessContext accessContext = AccessContext.builder().cluster(clusterName).topic(topic.getName()).topicActions(new TopicAction[]{TopicAction.VIEW}).build();
            return this.isTopicAccessible(accessContext, user);
        }).toList());
    }

    private boolean isConsumerGroupAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getConsumerGroup() == null && context.getConsumerGroupActions().isEmpty()) {
            return true;
        }
        Assert.isTrue((!context.getConsumerGroupActions().isEmpty() ? 1 : 0) != 0, (String)ACTIONS_ARE_EMPTY);
        Set requiredActions = context.getConsumerGroupActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.CONSUMER, context.getConsumerGroup(), user, context, requiredActions);
    }

    public Mono<Boolean> isConsumerGroupAccessible(String groupId, String clusterName) {
        if (!this.rbacEnabled) {
            return Mono.just((Object)true);
        }
        AccessContext accessContext = AccessContext.builder().cluster(clusterName).consumerGroup(groupId).consumerGroupActions(new ConsumerGroupAction[]{ConsumerGroupAction.VIEW}).build();
        return this.getUser().map(u -> this.isConsumerGroupAccessible(accessContext, u));
    }

    public boolean isSchemaAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getSchema() == null && context.getSchemaActions().isEmpty()) {
            return true;
        }
        Assert.isTrue((!context.getSchemaActions().isEmpty() ? 1 : 0) != 0, (String)ACTIONS_ARE_EMPTY);
        Set requiredActions = context.getSchemaActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.SCHEMA, context.getSchema(), user, context, requiredActions);
    }

    public Mono<Boolean> isSchemaAccessible(String schema, String clusterName) {
        if (!this.rbacEnabled) {
            return Mono.just((Object)true);
        }
        AccessContext accessContext = AccessContext.builder().cluster(clusterName).schema(schema).schemaActions(new SchemaAction[]{SchemaAction.VIEW}).build();
        return this.getUser().map(u -> this.isSchemaAccessible(accessContext, u));
    }

    public boolean isConnectAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getConnect() == null && context.getConnectActions().isEmpty()) {
            return true;
        }
        Assert.isTrue((!context.getConnectActions().isEmpty() ? 1 : 0) != 0, (String)ACTIONS_ARE_EMPTY);
        Set requiredActions = context.getConnectActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.CONNECT, context.getConnect(), user, context, requiredActions);
    }

    public Mono<Boolean> isConnectAccessible(ConnectDTO dto, String clusterName) {
        if (!this.rbacEnabled) {
            return Mono.just((Object)true);
        }
        return this.isConnectAccessible(dto.getName(), clusterName);
    }

    public Mono<Boolean> isConnectAccessible(String connectName, String clusterName) {
        if (!this.rbacEnabled) {
            return Mono.just((Object)true);
        }
        AccessContext accessContext = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).build();
        return this.getUser().map(u -> this.isConnectAccessible(accessContext, u));
    }

    public boolean isConnectorAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        return this.isConnectAccessible(context, user);
    }

    public Mono<Boolean> isConnectorAccessible(String connectName, String connectorName, String clusterName) {
        if (!this.rbacEnabled) {
            return Mono.just((Object)true);
        }
        AccessContext accessContext = AccessContext.builder().cluster(clusterName).connect(connectName).connectActions(new ConnectAction[]{ConnectAction.VIEW}).connector(connectorName).build();
        return this.getUser().map(u -> this.isConnectorAccessible(accessContext, u));
    }

    private boolean isKsqlAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getKsqlActions().isEmpty()) {
            return true;
        }
        Set requiredActions = context.getKsqlActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.KSQL, null, user, context, requiredActions);
    }

    private boolean isAclAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getAclActions().isEmpty()) {
            return true;
        }
        Set requiredActions = context.getAclActions().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.ACL, null, user, context, requiredActions);
    }

    private boolean isAuditAccessible(AccessContext context, AuthenticatedUser user) {
        if (!this.rbacEnabled) {
            return true;
        }
        if (context.getAuditAction().isEmpty()) {
            return true;
        }
        Set requiredActions = context.getAuditAction().stream().map(a -> a.toString().toUpperCase()).collect(Collectors.toSet());
        return this.isAccessible(Resource.AUDIT, null, user, context, requiredActions);
    }

    public Set<ProviderAuthorityExtractor> getOauthExtractors() {
        return this.oauthExtractors;
    }

    public List<Role> getRoles() {
        if (!this.rbacEnabled) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.properties.getRoles());
    }

    private boolean isAccessible(Resource resource, @Nullable String resourceValue, AuthenticatedUser user, AccessContext context, Set<String> requiredActions) {
        Set grantedActions = this.properties.getRoles().stream().filter(this.filterRole(user)).filter(this.filterCluster(resource, context.getCluster())).flatMap(grantedRole -> grantedRole.getPermissions().stream()).filter(this.filterResource(resource)).filter(this.filterResourceValue(resourceValue)).flatMap(grantedPermission -> grantedPermission.getActions().stream()).map(String::toUpperCase).collect(Collectors.toSet());
        return grantedActions.containsAll(requiredActions);
    }

    private Predicate<Role> filterRole(AuthenticatedUser user) {
        return role -> user.groups().contains(role.getName());
    }

    private Predicate<Role> filterCluster(String cluster) {
        return grantedRole -> grantedRole.getClusters().stream().anyMatch(cluster::equalsIgnoreCase);
    }

    private Predicate<Role> filterCluster(Resource resource, String cluster) {
        if (resource == Resource.APPLICATIONCONFIG) {
            return role -> true;
        }
        return this.filterCluster(cluster);
    }

    private Predicate<Permission> filterResource(Resource resource) {
        return grantedPermission -> resource == grantedPermission.getResource();
    }

    private Predicate<Permission> filterResourceValue(@Nullable String resourceValue) {
        if (resourceValue == null) {
            return grantedPermission -> true;
        }
        return grantedPermission -> {
            Pattern valuePattern = grantedPermission.getCompiledValuePattern();
            if (valuePattern == null) {
                return true;
            }
            return valuePattern.matcher(resourceValue).matches();
        };
    }

    public boolean isRbacEnabled() {
        return this.rbacEnabled;
    }

    public AccessControlService(@Nullable InMemoryReactiveClientRegistrationRepository clientRegistrationRepository, RoleBasedAccessControlProperties properties, Environment environment) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.properties = properties;
        this.environment = environment;
    }
}

