/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.metrics;

import com.provectus.kafka.ui.service.metrics.RawMetric;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrometheusEndpointMetricsParser {
    private static final Logger log = LoggerFactory.getLogger(PrometheusEndpointMetricsParser.class);
    private static final Pattern PATTERN = Pattern.compile("(?<metricName>^\\w+)([ \t]*\\{*(?<properties>.*)}*)[ \\t]+(?<value>[\\d]+\\.?[\\d]+)?");

    PrometheusEndpointMetricsParser() {
    }

    static Optional<RawMetric> parse(String s) {
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            String value = matcher.group("value");
            String metricName = matcher.group("metricName");
            if (metricName == null || !NumberUtils.isCreatable((String)value)) {
                return Optional.empty();
            }
            Map<String, String> labels = Arrays.stream(matcher.group("properties").split(",")).filter(str -> !"".equals(str)).map(str -> str.split("=")).filter(spit -> ((String[])spit).length == 2).collect(Collectors.toUnmodifiableMap(str -> str[0].trim(), str -> str[1].trim().replace("\"", "")));
            return Optional.of(RawMetric.create((String)metricName, labels, (BigDecimal)new BigDecimal(value)));
        }
        return Optional.empty();
    }
}

