/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.metrics;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.MetricsConfig;
import com.provectus.kafka.ui.service.metrics.JmxMetricsFormatter;
import com.provectus.kafka.ui.service.metrics.JmxSslSocketFactory;
import com.provectus.kafka.ui.service.metrics.MetricsRetriever;
import com.provectus.kafka.ui.service.metrics.RawMetric;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
class JmxMetricsRetriever
implements MetricsRetriever,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(JmxMetricsRetriever.class);
    private static final boolean SSL_JMX_SUPPORTED = JmxSslSocketFactory.initialized();
    private static final String JMX_URL = "service:jmx:rmi:///jndi/rmi://";
    private static final String JMX_SERVICE_TYPE = "jmxrmi";
    private static final String CANONICAL_NAME_PATTERN = "kafka.server*:*";

    JmxMetricsRetriever() {
    }

    @Override
    public void close() {
        JmxSslSocketFactory.clearFactoriesCache();
    }

    public Flux<RawMetric> retrieve(KafkaCluster c, Node node) {
        if (this.isSslJmxEndpoint(c) && !SSL_JMX_SUPPORTED) {
            log.warn("Cluster {} has jmx ssl configured, but it is not supported", (Object)c.getName());
            return Flux.empty();
        }
        return Mono.fromSupplier(() -> this.retrieveSync(c, node)).subscribeOn(Schedulers.boundedElastic()).flatMapMany(Flux::fromIterable);
    }

    private boolean isSslJmxEndpoint(KafkaCluster cluster) {
        return cluster.getMetricsConfig().getKeystoreLocation() != null;
    }

    private List<RawMetric> retrieveSync(KafkaCluster c, Node node) {
        String jmxUrl = JMX_URL + node.host() + ":" + c.getMetricsConfig().getPort() + "/jmxrmi";
        log.debug("Collection JMX metrics for {}", (Object)jmxUrl);
        ArrayList<RawMetric> result = new ArrayList<RawMetric>();
        this.withJmxConnector(jmxUrl, c, jmxConnector -> this.getMetricsFromJmx(jmxConnector, result));
        log.debug("{} metrics collected for {}", (Object)result.size(), (Object)jmxUrl);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withJmxConnector(String jmxUrl, KafkaCluster c, Consumer<JMXConnector> consumer) {
        Map env = this.prepareJmxEnvAndSetThreadLocal(c);
        try {
            JMXConnector connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(jmxUrl), env);
            try {
                try {
                    connector.connect(env);
                }
                catch (Exception exception) {
                    log.error("Error connecting to {}", (Object)jmxUrl, (Object)exception);
                    if (connector != null) {
                        connector.close();
                    }
                    JmxSslSocketFactory.clearThreadLocalContext();
                    return;
                }
                consumer.accept(connector);
            }
            finally {
                if (connector != null) {
                    try {
                        connector.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error getting jmx metrics from {}", (Object)jmxUrl, (Object)e);
        }
        finally {
            JmxSslSocketFactory.clearThreadLocalContext();
        }
    }

    private Map<String, Object> prepareJmxEnvAndSetThreadLocal(KafkaCluster cluster) {
        MetricsConfig metricsConfig = cluster.getMetricsConfig();
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.isSslJmxEndpoint(cluster)) {
            ClustersProperties.TruststoreConfig clusterSsl = cluster.getOriginalProperties().getSsl();
            JmxSslSocketFactory.setSslContextThreadLocal((String)(clusterSsl != null ? clusterSsl.getTruststoreLocation() : null), (String)(clusterSsl != null ? clusterSsl.getTruststorePassword() : null), (String)metricsConfig.getKeystoreLocation(), (String)metricsConfig.getKeystorePassword());
            JmxSslSocketFactory.editJmxConnectorEnv(env);
        }
        if (StringUtils.isNotEmpty((CharSequence)metricsConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)metricsConfig.getPassword())) {
            env.put("jmx.remote.credentials", new String[]{metricsConfig.getUsername(), metricsConfig.getPassword()});
        }
        return env;
    }

    private void getMetricsFromJmx(JMXConnector jmxConnector, List<RawMetric> sink) {
        MBeanServerConnection msc = jmxConnector.getMBeanServerConnection();
        Set<ObjectName> jmxMetrics = msc.queryNames(new ObjectName(CANONICAL_NAME_PATTERN), null);
        for (ObjectName jmxMetric : jmxMetrics) {
            sink.addAll(this.extractObjectMetrics(jmxMetric, msc));
        }
    }

    private List<RawMetric> extractObjectMetrics(ObjectName objectName, MBeanServerConnection msc) {
        MBeanAttributeInfo[] attrNames = msc.getMBeanInfo(objectName).getAttributes();
        Object[] attrValues = new Object[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            attrValues[i] = msc.getAttribute(objectName, attrNames[i].getName());
        }
        return JmxMetricsFormatter.constructMetricsList((ObjectName)objectName, (MBeanAttributeInfo[])attrNames, (Object[])attrValues);
    }
}

