/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.metrics;

import com.provectus.kafka.ui.service.metrics.RawMetric;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;

/*
 * Exception performing whole class analysis ignored.
 */
class JmxMetricsFormatter {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("([^,=:\\*\\?]+)=(\"(?:[^\\\\\"]*(?:\\\\.)?)*\"|[^,=:\"]*)");

    JmxMetricsFormatter() {
    }

    static List<RawMetric> constructMetricsList(ObjectName jmxMetric, MBeanAttributeInfo[] attributes, Object[] attrValues) {
        String domain = JmxMetricsFormatter.fixIllegalChars((String)jmxMetric.getDomain());
        LinkedHashMap labels = JmxMetricsFormatter.getLabelsMap((ObjectName)jmxMetric);
        String firstLabel = (String)labels.keySet().iterator().next();
        String firstLabelValue = JmxMetricsFormatter.fixIllegalChars((String)((String)labels.get(firstLabel)));
        labels.remove(firstLabel);
        ArrayList<RawMetric> result = new ArrayList<RawMetric>(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String attrName = JmxMetricsFormatter.fixIllegalChars((String)attributes[i].getName());
            JmxMetricsFormatter.convertNumericValue((Object)attrValues[i]).ifPresent(convertedValue -> {
                String name = String.format("%s_%s_%s", domain, firstLabelValue, attrName);
                RawMetric metric = RawMetric.create((String)name, (Map)labels, (BigDecimal)convertedValue);
                result.add(metric);
            });
        }
        return result;
    }

    private static String fixIllegalChars(String str) {
        return str.replace('.', '_').replace('-', '_');
    }

    private static Optional<BigDecimal> convertNumericValue(Object value) {
        if (!(value instanceof Number)) {
            return Optional.empty();
        }
        try {
            if (value instanceof Long) {
                return Optional.of(new BigDecimal((Long)value));
            }
            if (value instanceof Integer) {
                return Optional.of(new BigDecimal((Integer)value));
            }
            return Optional.of(new BigDecimal(value.toString()));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }

    private static LinkedHashMap<String, String> getLabelsMap(ObjectName mbeanName) {
        LinkedHashMap<String, String> keyProperties = new LinkedHashMap<String, String>();
        String properties = mbeanName.getKeyPropertyListString();
        Matcher match = PROPERTY_PATTERN.matcher(properties);
        while (match.lookingAt()) {
            String labelName = JmxMetricsFormatter.fixIllegalChars((String)match.group(1));
            String labelValue = match.group(2);
            keyProperties.put(labelName, labelValue);
            properties = properties.substring(match.end());
            if (properties.startsWith(",")) {
                properties = properties.substring(1);
            }
            match.reset(properties);
        }
        return keyProperties;
    }
}

