/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.masking.policies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.service.masking.policies.FieldsSelector;
import com.provectus.kafka.ui.service.masking.policies.MaskingPolicy;

class Replace
extends MaskingPolicy {
    static final String DEFAULT_REPLACEMENT = "***DATA_MASKED***";
    private final String replacement;

    Replace(FieldsSelector fieldsSelector, String replacementString) {
        super(fieldsSelector);
        this.replacement = (String)Preconditions.checkNotNull((Object)replacementString);
    }

    public String applyToString(String str) {
        return this.replacement;
    }

    public ContainerNode<?> applyToJsonContainer(ContainerNode<?> node) {
        return (ContainerNode)this.replaceWithFieldsCheck(node);
    }

    private JsonNode replaceWithFieldsCheck(JsonNode node) {
        if (node.isObject()) {
            ObjectNode obj = ((ObjectNode)node).objectNode();
            node.fields().forEachRemaining(f -> {
                String fieldName = (String)f.getKey();
                JsonNode fieldVal = (JsonNode)f.getValue();
                if (this.fieldShouldBeMasked(fieldName)) {
                    obj.set(fieldName, this.replaceRecursive(fieldVal));
                } else {
                    obj.set(fieldName, this.replaceWithFieldsCheck(fieldVal));
                }
            });
            return obj;
        }
        if (node.isArray()) {
            ArrayNode arr = ((ArrayNode)node).arrayNode(node.size());
            node.elements().forEachRemaining(e -> arr.add(this.replaceWithFieldsCheck(e)));
            return arr;
        }
        return node;
    }

    private JsonNode replaceRecursive(JsonNode node) {
        if (node.isObject()) {
            ObjectNode obj = ((ObjectNode)node).objectNode();
            node.fields().forEachRemaining(f -> obj.set((String)f.getKey(), this.replaceRecursive((JsonNode)f.getValue())));
            return obj;
        }
        if (node.isArray()) {
            ArrayNode arr = ((ArrayNode)node).arrayNode(node.size());
            node.elements().forEachRemaining(e -> arr.add(this.replaceRecursive(e)));
            return arr;
        }
        return new TextNode(this.replacement);
    }
}

