/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.masking.policies;

import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.exception.ValidationException;
import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

interface FieldsSelector {
    public static FieldsSelector create(ClustersProperties.Masking property) {
        if (StringUtils.hasText((String)property.getFieldsNamePattern()) && !CollectionUtils.isEmpty((Collection)property.getFields())) {
            throw new ValidationException("You can't provide both fieldNames & fieldsNamePattern for masking");
        }
        if (StringUtils.hasText((String)property.getFieldsNamePattern())) {
            Pattern pattern = Pattern.compile(property.getFieldsNamePattern());
            return f -> pattern.matcher(f).matches();
        }
        if (!CollectionUtils.isEmpty((Collection)property.getFields())) {
            return f -> property.getFields().contains(f);
        }
        return fieldName -> true;
    }

    public boolean shouldBeMasked(String var1);
}

