/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.ksql.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.provectus.kafka.ui.exception.KsqlApiException;
import com.provectus.kafka.ui.service.ksql.KsqlApiClient;
import com.provectus.kafka.ui.service.ksql.response.DynamicParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.reactive.function.client.WebClientResponseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResponseParser {
    private ResponseParser() {
    }

    public static Optional<KsqlApiClient.KsqlResponseTable> parseSelectResponse(JsonNode jsonNode) {
        if (ResponseParser.arrayFieldNonEmpty((JsonNode)jsonNode, (String)"header")) {
            return Optional.of(KsqlApiClient.KsqlResponseTable.builder().header("Schema").columnNames(ResponseParser.parseSelectHeadersString((String)jsonNode.get("header").get("schema").asText())).build());
        }
        if (ResponseParser.arrayFieldNonEmpty((JsonNode)jsonNode, (String)"row")) {
            return Optional.of(KsqlApiClient.KsqlResponseTable.builder().header("Row").values(List.of(Lists.newArrayList((Iterable)jsonNode.get("row").get("columns")))).build());
        }
        if (jsonNode.hasNonNull("errorMessage")) {
            throw new KsqlApiException("Error: " + jsonNode.get("errorMessage"));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static List<String> parseSelectHeadersString(String str) {
        ArrayList<String> headers = new ArrayList<String>();
        int structNesting = 0;
        boolean quotes = false;
        StringBuilder headerBuilder = new StringBuilder();
        for (char ch : str.toCharArray()) {
            if (ch == '<') {
                ++structNesting;
            } else if (ch == '>') {
                --structNesting;
            } else if (ch == '`') {
                quotes = !quotes;
            } else {
                if (ch == ' ' && headerBuilder.isEmpty()) continue;
                if (ch == ',' && structNesting == 0 && !quotes) {
                    headers.add(headerBuilder.toString());
                    headerBuilder = new StringBuilder();
                    continue;
                }
            }
            headerBuilder.append(ch);
        }
        if (!headerBuilder.isEmpty()) {
            headers.add(headerBuilder.toString());
        }
        return headers;
    }

    public static KsqlApiClient.KsqlResponseTable errorTableWithTextMsg(String errorText) {
        return KsqlApiClient.KsqlResponseTable.builder().header("Execution error").columnNames(List.of("message")).values(List.of(List.of(new TextNode(errorText)))).error(true).build();
    }

    public static KsqlApiClient.KsqlResponseTable parseErrorResponse(WebClientResponseException e) {
        try {
            JsonNode errBody = new JsonMapper().readTree(e.getResponseBodyAsString());
            return DynamicParser.parseObject((String)"Execution error", (JsonNode)errBody).toBuilder().error(true).build();
        }
        catch (Exception ex) {
            return ResponseParser.errorTableWithTextMsg((String)String.format("Unparsable error response from ksqdb, status:'%s', body: '%s'", e.getStatusCode(), e.getResponseBodyAsString()));
        }
    }

    public static List<KsqlApiClient.KsqlResponseTable> parseStatementResponse(JsonNode jsonNode) {
        String type;
        switch (type = Optional.ofNullable(jsonNode.get("@type")).map(JsonNode::asText).orElse("unknown")) {
            case "currentStatus": {
                return ResponseParser.parseObject((String)"Status", List.of("status", "message"), (JsonNode)jsonNode.get("commandStatus"));
            }
            case "properties": {
                return ResponseParser.parseProperties((JsonNode)jsonNode);
            }
            case "queries": {
                return ResponseParser.parseArray((String)"Queries", (String)"queries", (JsonNode)jsonNode);
            }
            case "sourceDescription": {
                return ResponseParser.parseObjectDynamically((String)"Source Description", (JsonNode)jsonNode.get("sourceDescription"));
            }
            case "queryDescription": {
                return ResponseParser.parseObjectDynamically((String)"Queries Description", (JsonNode)jsonNode.get("queryDescription"));
            }
            case "topicDescription": {
                return ResponseParser.parseObject((String)"Topic Description", List.of("name", "kafkaTopic", "format", "schemaString"), (JsonNode)jsonNode);
            }
            case "streams": {
                return ResponseParser.parseArray((String)"Streams", (String)"streams", (JsonNode)jsonNode);
            }
            case "tables": {
                return ResponseParser.parseArray((String)"Tables", (String)"tables", (JsonNode)jsonNode);
            }
            case "kafka_topics": {
                return ResponseParser.parseArray((String)"Topics", (String)"topics", (JsonNode)jsonNode);
            }
            case "kafka_topics_extended": {
                return ResponseParser.parseArray((String)"Topics extended", (String)"topics", (JsonNode)jsonNode);
            }
            case "executionPlan": {
                return ResponseParser.parseObject((String)"Execution plan", List.of("executionPlanText"), (JsonNode)jsonNode);
            }
            case "source_descriptions": {
                return ResponseParser.parseArray((String)"Source descriptions", (String)"sourceDescriptions", (JsonNode)jsonNode);
            }
            case "query_descriptions": {
                return ResponseParser.parseArray((String)"Queries", (String)"queryDescriptions", (JsonNode)jsonNode);
            }
            case "describe_function": {
                return ResponseParser.parseObject((String)"Function description", List.of("name", "author", "version", "description", "functions", "path", "type"), (JsonNode)jsonNode);
            }
            case "function_names": {
                return ResponseParser.parseArray((String)"Function Names", (String)"functions", (JsonNode)jsonNode);
            }
            case "connector_info": {
                return ResponseParser.parseObjectDynamically((String)"Connector Info", (JsonNode)jsonNode.get("info"));
            }
            case "drop_connector": {
                return ResponseParser.parseObject((String)"Dropped connector", List.of("connectorName"), (JsonNode)jsonNode);
            }
            case "connector_list": {
                return ResponseParser.parseArray((String)"Connectors", (String)"connectors", (JsonNode)jsonNode);
            }
            case "connector_plugins_list": {
                return ResponseParser.parseArray((String)"Connector Plugins", (String)"connectorPlugins", (JsonNode)jsonNode);
            }
            case "connector_description": {
                return ResponseParser.parseObject((String)"Connector Description", List.of("connectorClass", "status", "sources", "topics"), (JsonNode)jsonNode);
            }
        }
        return ResponseParser.parseUnknownResponse((JsonNode)jsonNode);
    }

    private static List<KsqlApiClient.KsqlResponseTable> parseObjectDynamically(String tableName, JsonNode jsonNode) {
        return List.of(DynamicParser.parseObject((String)tableName, (JsonNode)jsonNode));
    }

    private static List<KsqlApiClient.KsqlResponseTable> parseObject(String tableName, List<String> fields, JsonNode jsonNode) {
        return List.of(DynamicParser.parseObject((String)tableName, fields, (JsonNode)jsonNode));
    }

    private static List<KsqlApiClient.KsqlResponseTable> parseArray(String tableName, String arrayField, JsonNode jsonNode) {
        return List.of(DynamicParser.parseArray((String)tableName, (JsonNode)jsonNode.get(arrayField)));
    }

    private static List<KsqlApiClient.KsqlResponseTable> parseProperties(JsonNode jsonNode) {
        ArrayList<KsqlApiClient.KsqlResponseTable> tables = new ArrayList<KsqlApiClient.KsqlResponseTable>();
        if (ResponseParser.arrayFieldNonEmpty((JsonNode)jsonNode, (String)"properties")) {
            tables.add(DynamicParser.parseArray((String)"properties", (JsonNode)jsonNode.get("properties")));
        }
        if (ResponseParser.arrayFieldNonEmpty((JsonNode)jsonNode, (String)"overwrittenProperties")) {
            tables.add(DynamicParser.parseArray((String)"overwrittenProperties", (JsonNode)jsonNode.get("overwrittenProperties")));
        }
        return tables;
    }

    private static List<KsqlApiClient.KsqlResponseTable> parseUnknownResponse(JsonNode jsonNode) {
        return List.of(DynamicParser.parseObject((String)"Ksql Response", (JsonNode)jsonNode));
    }

    private static boolean arrayFieldNonEmpty(JsonNode json, String field) {
        return json.hasNonNull(field) && !json.get(field).isEmpty();
    }
}

