/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd.schema;

import com.google.common.collect.ImmutableSet;
import com.provectus.kafka.ui.service.integration.odd.schema.DataSetFieldsExtractors;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import org.opendatadiscovery.client.model.DataSetField;
import org.opendatadiscovery.client.model.DataSetFieldType;
import org.opendatadiscovery.client.model.MetadataExtension;
import org.opendatadiscovery.oddrn.model.KafkaPath;

/*
 * Exception performing whole class analysis ignored.
 */
final class JsonSchemaExtractor {
    private JsonSchemaExtractor() {
    }

    static List<DataSetField> extract(JsonSchema jsonSchema, KafkaPath topicOddrn, boolean isKey) {
        Schema schema = jsonSchema.rawSchema();
        ArrayList<DataSetField> result = new ArrayList<DataSetField>();
        result.add(DataSetFieldsExtractors.rootField((KafkaPath)topicOddrn, (boolean)isKey));
        JsonSchemaExtractor.extract((Schema)schema, (String)(topicOddrn.oddrn() + "/columns/" + (isKey ? "key" : "value")), null, null, null, (ImmutableSet)ImmutableSet.of(), result);
        return result;
    }

    private static void extract(Schema schema, String parentOddr, String oddrn, String name, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        if (schema instanceof ReferenceSchema) {
            ReferenceSchema s = (ReferenceSchema)schema;
            Optional.ofNullable(s.getReferredSchema()).ifPresent(refSchema -> JsonSchemaExtractor.extract((Schema)refSchema, (String)parentOddr, (String)oddrn, (String)name, (Boolean)nullable, (ImmutableSet)registeredRecords, (List)sink));
        } else if (schema instanceof ObjectSchema) {
            ObjectSchema s = (ObjectSchema)schema;
            JsonSchemaExtractor.extractObject((ObjectSchema)s, (String)parentOddr, (String)oddrn, (String)name, (Boolean)nullable, registeredRecords, sink);
        } else if (schema instanceof ArraySchema) {
            ArraySchema s = (ArraySchema)schema;
            JsonSchemaExtractor.extractArray((ArraySchema)s, (String)parentOddr, (String)oddrn, (String)name, (Boolean)nullable, registeredRecords, sink);
        } else if (schema instanceof CombinedSchema) {
            CombinedSchema cs = (CombinedSchema)schema;
            JsonSchemaExtractor.extractCombined((CombinedSchema)cs, (String)parentOddr, (String)oddrn, (String)name, (Boolean)nullable, registeredRecords, sink);
        } else if (schema instanceof BooleanSchema || schema instanceof NumberSchema || schema instanceof StringSchema || schema instanceof NullSchema) {
            JsonSchemaExtractor.extractPrimitive((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (Boolean)nullable, sink);
        } else {
            JsonSchemaExtractor.extractUnknown((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (Boolean)nullable, sink);
        }
    }

    private static void extractPrimitive(Schema schema, String parentOddr, String oddrn, String name, Boolean nullable, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        sink.add(JsonSchemaExtractor.createDataSetField((Schema)schema, (String)(isRoot ? "Root JSON primitive" : name), (String)parentOddr, (String)(isRoot ? parentOddr + "/" + JsonSchemaExtractor.logicalTypeName((Schema)schema) : oddrn), (DataSetFieldType.TypeEnum)JsonSchemaExtractor.mapType((Schema)schema), (String)JsonSchemaExtractor.logicalTypeName((Schema)schema), (Boolean)nullable));
    }

    private static void extractUnknown(Schema schema, String parentOddr, String oddrn, String name, Boolean nullable, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        sink.add(JsonSchemaExtractor.createDataSetField((Schema)schema, (String)(isRoot ? "Root type " + JsonSchemaExtractor.logicalTypeName((Schema)schema) : name), (String)parentOddr, (String)(isRoot ? parentOddr + "/" + JsonSchemaExtractor.logicalTypeName((Schema)schema) : oddrn), (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.UNKNOWN, (String)JsonSchemaExtractor.logicalTypeName((Schema)schema), (Boolean)nullable));
    }

    private static void extractObject(ObjectSchema schema, String parentOddr, String oddrn, String name, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        String schemaLocation = schema.getSchemaLocation();
        if (!isRoot) {
            sink.add(JsonSchemaExtractor.createDataSetField((Schema)schema, (String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.STRUCT, (String)JsonSchemaExtractor.logicalTypeName((Schema)schema), (Boolean)nullable));
            if (schemaLocation != null && registeredRecords.contains((Object)schemaLocation)) {
                return;
            }
        }
        ImmutableSet newRegisteredRecords = schemaLocation == null ? registeredRecords : ImmutableSet.builder().addAll(registeredRecords).add((Object)schemaLocation).build();
        schema.getPropertySchemas().forEach((propertyName, propertySchema) -> {
            boolean required = schema.getRequiredProperties().contains(propertyName);
            JsonSchemaExtractor.extract((Schema)propertySchema, (String)(isRoot ? parentOddr : oddrn), (String)(isRoot ? parentOddr + "/" + propertyName : oddrn + "/fields/" + propertyName), (String)propertyName, (Boolean)(!required ? 1 : 0), (ImmutableSet)newRegisteredRecords, (List)sink);
        });
    }

    private static void extractArray(ArraySchema schema, String parentOddr, String oddrn, String name, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        Object object = oddrn = isRoot ? parentOddr + "/array" : oddrn;
        if (isRoot) {
            sink.add(JsonSchemaExtractor.createDataSetField((Schema)schema, (String)"Json array root", (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.LIST, (String)"array", (Boolean)nullable));
        } else {
            sink.add(JsonSchemaExtractor.createDataSetField((Schema)schema, (String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.LIST, (String)"array", (Boolean)nullable));
        }
        Schema itemsSchema = schema.getAllItemSchema();
        if (itemsSchema != null) {
            JsonSchemaExtractor.extract((Schema)itemsSchema, (String)oddrn, (String)((String)oddrn + "/items/" + JsonSchemaExtractor.logicalTypeName((Schema)itemsSchema)), (String)JsonSchemaExtractor.logicalTypeName((Schema)itemsSchema), (Boolean)false, registeredRecords, sink);
        }
    }

    private static void extractCombined(CombinedSchema schema, String parentOddr, String oddrn, String name, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        String combineType = "unknown";
        if (schema.getCriterion() == CombinedSchema.ALL_CRITERION) {
            combineType = "allOf";
        }
        if (schema.getCriterion() == CombinedSchema.ANY_CRITERION) {
            combineType = "anyOf";
        }
        if (schema.getCriterion() == CombinedSchema.ONE_CRITERION) {
            combineType = "oneOf";
        }
        boolean isRoot = oddrn == null;
        oddrn = isRoot ? parentOddr + "/" + combineType : (String)oddrn + "/" + combineType;
        sink.add(JsonSchemaExtractor.createDataSetField((Schema)schema, (String)(isRoot ? "Root %s".formatted(combineType) : name), (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.UNION, (String)combineType, (Boolean)nullable).addMetadataItem(new MetadataExtension().schemaUrl(URI.create("wontbeused.oops")).metadata(Map.of("criterion", combineType))));
        for (Schema subschema : schema.getSubschemas()) {
            JsonSchemaExtractor.extract((Schema)subschema, (String)oddrn, (String)((String)oddrn + "/values/" + JsonSchemaExtractor.logicalTypeName((Schema)subschema)), (String)JsonSchemaExtractor.logicalTypeName((Schema)subschema), (Boolean)nullable, registeredRecords, sink);
        }
    }

    private static String getDescription(Schema schema) {
        return Optional.ofNullable(schema.getTitle()).orElse(schema.getDescription());
    }

    private static String logicalTypeName(Schema schema) {
        return schema.getClass().getSimpleName().replace("Schema", "");
    }

    private static DataSetField createDataSetField(Schema schema, String name, String parentOddrn, String oddrn, DataSetFieldType.TypeEnum type, String logicalType, Boolean nullable) {
        return new DataSetField().name(name).parentFieldOddrn(parentOddrn).oddrn(oddrn).description(JsonSchemaExtractor.getDescription((Schema)schema)).type(new DataSetFieldType().isNullable(nullable).logicalType(logicalType).type(type));
    }

    private static DataSetFieldType.TypeEnum mapType(Schema type) {
        if (type instanceof NumberSchema) {
            return DataSetFieldType.TypeEnum.NUMBER;
        }
        if (type instanceof StringSchema) {
            return DataSetFieldType.TypeEnum.STRING;
        }
        if (type instanceof BooleanSchema || type instanceof TrueSchema || type instanceof FalseSchema) {
            return DataSetFieldType.TypeEnum.BOOLEAN;
        }
        if (type instanceof ObjectSchema) {
            return DataSetFieldType.TypeEnum.STRUCT;
        }
        if (type instanceof ReferenceSchema) {
            ReferenceSchema s = (ReferenceSchema)type;
            return JsonSchemaExtractor.mapType((Schema)s.getReferredSchema());
        }
        if (type instanceof CombinedSchema) {
            return DataSetFieldType.TypeEnum.UNION;
        }
        return DataSetFieldType.TypeEnum.UNKNOWN;
    }
}

