/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.provectus.kafka.ui.service.integration.odd.SchemaReferencesResolver;
import com.provectus.kafka.ui.sr.api.KafkaSrClientApi;
import com.provectus.kafka.ui.sr.model.SchemaReference;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

class SchemaReferencesResolver {
    private final KafkaSrClientApi client;

    SchemaReferencesResolver(KafkaSrClientApi client) {
        this.client = client;
    }

    Mono<ImmutableMap<String, String>> resolve(List<SchemaReference> refs) {
        return this.resolveReferences(refs, new Resolving(ImmutableMap.of(), ImmutableSet.of())).map(Resolving::resolved);
    }

    private Mono<Resolving> resolveReferences(@Nullable List<SchemaReference> refs, Resolving initState) {
        Mono result = Mono.just((Object)initState);
        for (SchemaReference reference : Optional.ofNullable(refs).orElse(List.of())) {
            result = result.flatMap(state -> {
                if (state.visited().contains((Object)reference.getName())) {
                    return Mono.just((Object)state);
                }
                Resolving newState = state.visit(reference.getName());
                return this.client.getSubjectVersion(reference.getSubject(), String.valueOf(reference.getVersion()), Boolean.valueOf(true)).flatMap(subj -> this.resolveReferences(subj.getReferences(), newState).map(withNewRefs -> withNewRefs.resolve(reference.getName(), subj.getSchema())));
            });
        }
        return result;
    }
}

