/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd;

import com.provectus.kafka.ui.connect.model.ConnectorTopics;
import com.provectus.kafka.ui.model.ConnectDTO;
import com.provectus.kafka.ui.model.ConnectorDTO;
import com.provectus.kafka.ui.model.ConnectorTypeDTO;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.KafkaConnectService;
import com.provectus.kafka.ui.service.integration.odd.ConnectorInfo;
import com.provectus.kafka.ui.service.integration.odd.Oddrn;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendatadiscovery.client.model.DataEntity;
import org.opendatadiscovery.client.model.DataEntityList;
import org.opendatadiscovery.client.model.DataEntityType;
import org.opendatadiscovery.client.model.DataSource;
import org.opendatadiscovery.client.model.DataTransformer;
import org.opendatadiscovery.client.model.MetadataExtension;
import reactor.core.publisher.Flux;

/*
 * Exception performing whole class analysis ignored.
 */
class ConnectorsExporter {
    private final KafkaConnectService kafkaConnectService;

    Flux<DataEntityList> export(KafkaCluster cluster) {
        return this.kafkaConnectService.getConnects(cluster).flatMap(connect -> this.kafkaConnectService.getConnectorNamesWithErrorsSuppress(cluster, connect.getName()).flatMap(connectorName -> this.kafkaConnectService.getConnector(cluster, connect.getName(), connectorName)).flatMap(connectorDTO -> this.kafkaConnectService.getConnectorTopics(cluster, connect.getName(), connectorDTO.getName()).map(topics -> ConnectorsExporter.createConnectorDataEntity((KafkaCluster)cluster, (ConnectDTO)connect, (ConnectorDTO)connectorDTO, (ConnectorTopics)topics))).buffer(100).map(connectDataEntities -> {
            String dsOddrn = Oddrn.connectDataSourceOddrn((String)connect.getAddress());
            return new DataEntityList().dataSourceOddrn(dsOddrn).items(connectDataEntities);
        }));
    }

    Flux<DataSource> getConnectDataSources(KafkaCluster cluster) {
        return this.kafkaConnectService.getConnects(cluster).map(ConnectorsExporter::toDataSource);
    }

    private static DataSource toDataSource(ConnectDTO connect) {
        return new DataSource().oddrn(Oddrn.connectDataSourceOddrn((String)connect.getAddress())).name(connect.getName()).description("Kafka Connect");
    }

    private static DataEntity createConnectorDataEntity(KafkaCluster cluster, ConnectDTO connect, ConnectorDTO connector, ConnectorTopics connectorTopics) {
        HashMap<String, String> metadata = new HashMap<String, String>(ConnectorsExporter.extractMetadata((ConnectorDTO)connector));
        metadata.put("type", connector.getType().name());
        ConnectorInfo info = ConnectorsExporter.extractConnectorInfo((KafkaCluster)cluster, (ConnectorDTO)connector, (ConnectorTopics)connectorTopics);
        DataTransformer transformer = new DataTransformer();
        transformer.setInputs(info.inputs());
        transformer.setOutputs(info.outputs());
        return new DataEntity().oddrn(Oddrn.connectorOddrn((String)connect.getAddress(), (String)connector.getName())).name(connector.getName()).description("Kafka Connector \"%s\" (%s)".formatted(connector.getName(), connector.getType())).type(DataEntityType.JOB).dataTransformer(transformer).metadata(List.of(new MetadataExtension().schemaUrl(URI.create("wontbeused.oops")).metadata(metadata)));
    }

    private static Map<String, Object> extractMetadata(ConnectorDTO connector) {
        return connector.getConfig();
    }

    private static ConnectorInfo extractConnectorInfo(KafkaCluster cluster, ConnectorDTO connector, ConnectorTopics topics) {
        return ConnectorInfo.extract((String)((String)connector.getConfig().get("connector.class")), (ConnectorTypeDTO)connector.getType(), (Map)connector.getConfig(), (List)topics.getTopics(), topic -> Oddrn.topicOddrn((KafkaCluster)cluster, (String)topic));
    }

    public ConnectorsExporter(KafkaConnectService kafkaConnectService) {
        this.kafkaConnectService = kafkaConnectService;
    }
}

