/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd;

import com.provectus.kafka.ui.model.ConnectorTypeDTO;
import com.provectus.kafka.ui.service.integration.odd.Oddrn;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.opendatadiscovery.oddrn.JdbcUrlParser;
import org.opendatadiscovery.oddrn.model.HivePath;
import org.opendatadiscovery.oddrn.model.MysqlPath;
import org.opendatadiscovery.oddrn.model.OddrnPath;
import org.opendatadiscovery.oddrn.model.PostgreSqlPath;
import org.opendatadiscovery.oddrn.model.SnowflakePath;

/*
 * Exception performing whole class analysis ignored.
 */
record ConnectorInfo(List<String> inputs, List<String> outputs) {
    private final List<String> inputs;
    private final List<String> outputs;

    ConnectorInfo(List<String> inputs, List<String> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    static ConnectorInfo extract(String className, ConnectorTypeDTO type, Map<String, Object> config, List<String> topicsFromApi, Function<String, String> topicOddrnBuilder) {
        return switch (className) {
            case "org.apache.kafka.connect.file.FileStreamSinkConnector", "org.apache.kafka.connect.file.FileStreamSourceConnector", "FileStreamSource", "FileStreamSink" -> ConnectorInfo.extractFileIoConnector((ConnectorTypeDTO)type, topicsFromApi, config, topicOddrnBuilder);
            case "io.confluent.connect.s3.S3SinkConnector" -> ConnectorInfo.extractS3Sink((ConnectorTypeDTO)type, topicsFromApi, config, topicOddrnBuilder);
            case "io.confluent.connect.jdbc.JdbcSinkConnector" -> ConnectorInfo.extractJdbcSink((ConnectorTypeDTO)type, topicsFromApi, config, topicOddrnBuilder);
            case "io.debezium.connector.postgresql.PostgresConnector" -> ConnectorInfo.extractDebeziumPg(config);
            case "io.debezium.connector.mysql.MySqlConnector" -> ConnectorInfo.extractDebeziumMysql(config);
            default -> new ConnectorInfo(ConnectorInfo.extractInputs((ConnectorTypeDTO)type, topicsFromApi, config, topicOddrnBuilder), ConnectorInfo.extractOutputs((ConnectorTypeDTO)type, topicsFromApi, config, topicOddrnBuilder));
        };
    }

    private static ConnectorInfo extractFileIoConnector(ConnectorTypeDTO type, List<String> topics, Map<String, Object> config, Function<String, String> topicOddrnBuilder) {
        return new ConnectorInfo(ConnectorInfo.extractInputs((ConnectorTypeDTO)type, topics, config, topicOddrnBuilder), ConnectorInfo.extractOutputs((ConnectorTypeDTO)type, topics, config, topicOddrnBuilder));
    }

    private static ConnectorInfo extractJdbcSink(ConnectorTypeDTO type, List<String> topics, Map<String, Object> config, Function<String, String> topicOddrnBuilder) {
        PostgreSqlPath p;
        String tableNameFormat = (String)config.getOrDefault("table.name.format", "${topic}");
        List<String> targetTables = ConnectorInfo.extractTopicNamesBestEffort(topics, config).map(topic -> tableNameFormat.replace("${kafka}", (CharSequence)topic)).toList();
        String connectionUrl = (String)config.get("connection.url");
        ArrayList outputs = new ArrayList();
        OddrnPath knownJdbcPath = new JdbcUrlParser().parse(connectionUrl);
        if (knownJdbcPath instanceof PostgreSqlPath) {
            p = (PostgreSqlPath)knownJdbcPath;
            targetTables.forEach(t -> outputs.add(p.toBuilder().table(t).build().oddrn()));
        }
        if (knownJdbcPath instanceof MysqlPath) {
            p = (MysqlPath)knownJdbcPath;
            targetTables.forEach(arg_0 -> ConnectorInfo.lambda$extractJdbcSink$2(outputs, (MysqlPath)p, arg_0));
        }
        if (knownJdbcPath instanceof HivePath) {
            p = (HivePath)knownJdbcPath;
            targetTables.forEach(arg_0 -> ConnectorInfo.lambda$extractJdbcSink$3(outputs, (HivePath)p, arg_0));
        }
        if (knownJdbcPath instanceof SnowflakePath) {
            p = (SnowflakePath)knownJdbcPath;
            targetTables.forEach(arg_0 -> ConnectorInfo.lambda$extractJdbcSink$4(outputs, (SnowflakePath)p, arg_0));
        }
        return new ConnectorInfo(ConnectorInfo.extractInputs((ConnectorTypeDTO)type, topics, config, topicOddrnBuilder), outputs);
    }

    private static ConnectorInfo extractDebeziumPg(Map<String, Object> config) {
        String host = (String)config.get("database.hostname");
        String dbName = (String)config.get("database.dbname");
        List<String> inputs = List.of(PostgreSqlPath.builder().host(host).database(dbName).build().oddrn());
        return new ConnectorInfo(inputs, List.of());
    }

    private static ConnectorInfo extractDebeziumMysql(Map<String, Object> config) {
        String host = (String)config.get("database.hostname");
        List<String> inputs = List.of(MysqlPath.builder().host(host).build().oddrn());
        return new ConnectorInfo(inputs, List.of());
    }

    private static ConnectorInfo extractS3Sink(ConnectorTypeDTO type, List<String> topics, Map<String, Object> config, Function<String, String> topicOrrdnBuilder) {
        String bucketName = (String)config.get("s3.bucket.name");
        String topicsDir = (String)config.getOrDefault("topics.dir", "topics");
        String directoryDelim = (String)config.getOrDefault("directory.delim", "/");
        List<String> outputs = ConnectorInfo.extractTopicNamesBestEffort(topics, config).map(topic -> Oddrn.awsS3Oddrn((String)bucketName, (String)(topicsDir + directoryDelim + topic))).toList();
        return new ConnectorInfo(ConnectorInfo.extractInputs((ConnectorTypeDTO)type, topics, config, topicOrrdnBuilder), outputs);
    }

    private static List<String> extractInputs(ConnectorTypeDTO type, List<String> topicsFromApi, Map<String, Object> config, Function<String, String> topicOrrdnBuilder) {
        return type == ConnectorTypeDTO.SINK ? ConnectorInfo.extractTopicsOddrns(config, topicsFromApi, topicOrrdnBuilder) : List.of();
    }

    private static List<String> extractOutputs(ConnectorTypeDTO type, List<String> topicsFromApi, Map<String, Object> config, Function<String, String> topicOrrdnBuilder) {
        return type == ConnectorTypeDTO.SOURCE ? ConnectorInfo.extractTopicsOddrns(config, topicsFromApi, topicOrrdnBuilder) : List.of();
    }

    private static Stream<String> extractTopicNamesBestEffort(List<String> topicsFromApi, Map<String, Object> config) {
        if (CollectionUtils.isNotEmpty(topicsFromApi)) {
            return topicsFromApi.stream();
        }
        String topicsString = (String)config.get("topics");
        String topicString = (String)config.get("topic");
        return Stream.of(topicsString, topicString).filter(Objects::nonNull).flatMap(str -> Stream.of(str.split(","))).map(String::trim).filter(s -> !s.isBlank());
    }

    private static List<String> extractTopicsOddrns(Map<String, Object> config, List<String> topicsFromApi, Function<String, String> topicOrrdnBuilder) {
        return ConnectorInfo.extractTopicNamesBestEffort(topicsFromApi, config).map(topicOrrdnBuilder).toList();
    }

    public List<String> inputs() {
        return this.inputs;
    }

    public List<String> outputs() {
        return this.outputs;
    }

    private static /* synthetic */ void lambda$extractJdbcSink$4(List outputs, SnowflakePath p, String t) {
        outputs.add(p.toBuilder().table(t).build().oddrn());
    }

    private static /* synthetic */ void lambda$extractJdbcSink$3(List outputs, HivePath p, String t) {
        outputs.add(p.toBuilder().table(t).build().oddrn());
    }

    private static /* synthetic */ void lambda$extractJdbcSink$2(List outputs, MysqlPath p, String t) {
        outputs.add(p.toBuilder().table(t).build().oddrn());
    }
}

